/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.kladr.processors;

import org.jamel.kladr.data.City;
import org.jamel.kladr.data.Street;
import org.jamel.kladr.processors.KladrRowProcessor;
import org.jamel.kladr.utils.KladrCodeUtils;

public abstract class StreetProcessor
extends KladrRowProcessor {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void processKladrRow(byte[] code, byte regionId, int districtId, int cityId, int countryId, byte[] name, byte[] socr, int index) {
        long cityCode;
        long streetCode = KladrCodeUtils.getStreetCode(code);
        if (districtId == 0 && cityId == 0 && countryId == 0) {
            if (!KladrCodeUtils.isCityRegion(regionId)) {
                City city = new City(name, socr, index, regionId, regionId * 1000);
                this.processCity(streetCode, city);
                return;
            }
            cityCode = regionId * 1000000;
        } else {
            if (cityId == 0 && countryId == 0) {
                int districtCode = KladrCodeUtils.getDistrictCode(code);
                City city = new City(name, socr, index, regionId, districtCode);
                this.processCity(streetCode, city);
                return;
            }
            cityCode = countryId == 0 ? KladrCodeUtils.getCityCode(code) : KladrCodeUtils.getCountryCode(code);
        }
        Street street = new Street(name, socr, index, cityCode);
        this.processStreet(streetCode, street);
    }

    public void processCity(long cityCode, City city) {
    }

    public void processStreet(long streetCode, Street street) {
    }
}

