/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.kladr.processors;

import org.jamel.kladr.data.City;
import org.jamel.kladr.data.Country;
import org.jamel.kladr.data.District;
import org.jamel.kladr.data.Region;
import org.jamel.kladr.processors.KladrRowProcessor;
import org.jamel.kladr.utils.KladrCodeUtils;

public abstract class KladrObjectsProcessor
extends KladrRowProcessor {
    @Override
    public final void processKladrRow(byte[] code, byte regionId, int districtId, int cityId, int countryId, byte[] name, byte[] socr, int index) {
        if (districtId == 0 && cityId == 0 && countryId == 0) {
            Region region = new Region(name, socr, index);
            this.processRegion(regionId, region);
        } else if (cityId == 0 && countryId == 0) {
            int districtCode = KladrCodeUtils.getDistrictCode(code);
            District district = new District(name, socr, index, regionId);
            this.processDistrict(districtCode, district);
        } else if (countryId == 0) {
            int districtCode = districtId != 0 ? KladrCodeUtils.getDistrictCode(code) : 0;
            long cityCode = KladrCodeUtils.getCityCode(code);
            City city = new City(name, socr, index, regionId, districtCode);
            this.processCity(cityCode, city);
        } else {
            int districtCode = districtId != 0 ? KladrCodeUtils.getDistrictCode(code) : 0;
            long parentCityCode = cityId != 0 ? KladrCodeUtils.getCityCode(code) : 0L;
            long countryCode = KladrCodeUtils.getCountryCode(code);
            Country country = new Country(name, socr, index, regionId, districtCode, parentCityCode);
            this.processCountry(countryCode, country);
        }
    }

    public void processRegion(byte regionCode, Region region) {
    }

    public void processDistrict(int districtCode, District district) {
    }

    public void processCity(long cityCode, City city) {
    }

    public void processCountry(long countryCode, Country country) {
    }
}

