/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.kladr.cache;

import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TByteObjectProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import org.jamel.kladr.data.City;
import org.jamel.kladr.data.Country;
import org.jamel.kladr.data.District;
import org.jamel.kladr.data.Region;
import org.jamel.kladr.data.Street;

public class KladrCache {
    private final TByteObjectMap<Region> regions = new TByteObjectHashMap();
    private final TIntObjectMap<District> districts = new TIntObjectHashMap();
    private final TLongObjectMap<City> cities = new TLongObjectHashMap();
    private final TLongObjectMap<Country> countries = new TLongObjectHashMap();
    private final TLongObjectMap<Street> streets = new TLongObjectHashMap();

    public Region putRegion(byte regionCode, Region region) {
        return (Region)this.regions.put(regionCode, (Object)region);
    }

    public Region getRegion(byte regionCode) {
        return (Region)this.regions.get(regionCode);
    }

    public boolean forEachRegion(TByteObjectProcedure<Region> procedure) {
        return this.regions.forEachEntry(procedure);
    }

    public District putDistrict(int districtCode, District district) {
        return (District)this.districts.put(districtCode, (Object)district);
    }

    public District getDistrict(int districtCode) {
        return (District)this.districts.get(districtCode);
    }

    public boolean forEachDistrict(TIntObjectProcedure<District> procedure) {
        return this.districts.forEachEntry(procedure);
    }

    public City putCity(long cityCode, City city) {
        return (City)this.cities.put(cityCode, (Object)city);
    }

    public City getCity(long cityCode) {
        return (City)this.cities.get(cityCode);
    }

    public boolean forEachCity(TLongObjectProcedure<City> procedure) {
        return this.cities.forEachEntry(procedure);
    }

    public Country putCountry(long countryCode, Country country) {
        return (Country)this.countries.put(countryCode, (Object)country);
    }

    public Country getCountry(long countryCode) {
        return (Country)this.countries.get(countryCode);
    }

    public boolean forEachCountry(TLongObjectProcedure<Country> procedure) {
        return this.countries.forEachEntry(procedure);
    }

    public Street putStreet(long streetCode, Street street) {
        return (Street)this.streets.put(streetCode, (Object)street);
    }

    public Street getStreet(long streetCode) {
        return (Street)this.streets.get(streetCode);
    }

    public boolean forEachStreet(TLongObjectProcedure<Street> procedure) {
        return this.streets.forEachEntry(procedure);
    }
}

