/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.kladr;

import org.jamel.kladr.cache.KladrCache;
import org.jamel.kladr.data.City;
import org.jamel.kladr.data.Country;
import org.jamel.kladr.data.District;
import org.jamel.kladr.data.KladrObject;
import org.jamel.kladr.data.Region;
import org.jamel.kladr.data.Street;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AddressBuilder.class);
    private static final int MAX_KLADR_LEVEL = 5;
    private final KladrCache kladrCache;
    private StringBuilder buf = new StringBuilder(256);
    private KladrObject[] address = new KladrObject[5];

    public AddressBuilder(KladrCache kladrCache) {
        this.kladrCache = kladrCache;
    }

    public String buildFor(District district) {
        int i = 0;
        this.address[i++] = district;
        this.address[i++] = this.kladrCache.getRegion(district.getRegionCode());
        return this.toAddressString(this.address, i);
    }

    public String buildFor(City city) {
        return this.doBuildForCity(city, 0);
    }

    public String buildFor(Country country) {
        return this.doBuildForCountry(country, 0);
    }

    public String buildFor(Street street) {
        int i = 0;
        this.address[i++] = street;
        Country country = this.kladrCache.getCountry(street.getCityCode());
        if (country != null) {
            return this.doBuildForCountry(country, i);
        }
        City city = this.kladrCache.getCity(street.getCityCode());
        if (city != null) {
            return this.doBuildForCity(city, i);
        }
        logger.debug("Can't get city by code=" + street.getCityCode());
        return "";
    }

    private String doBuildForCity(City city, int i) {
        Region region;
        District district;
        this.address[i++] = city;
        if (city.getDistrictCode() != 0 && (district = this.kladrCache.getDistrict(city.getDistrictCode())) != null) {
            this.address[i++] = district;
        }
        if ((region = this.kladrCache.getRegion(city.getRegionCode())) != null) {
            this.address[i++] = region;
        }
        return this.toAddressString(this.address, i);
    }

    private String doBuildForCountry(Country country, int i) {
        Region region;
        District district;
        this.address[i++] = country;
        if (country.getParentCityCode() != 0L) {
            City city = this.kladrCache.getCity(country.getParentCityCode());
            this.address[i++] = city;
        }
        if (country.getDistrictCode() != 0 && (district = this.kladrCache.getDistrict(country.getDistrictCode())) != null) {
            this.address[i++] = district;
        }
        if ((region = this.kladrCache.getRegion(country.getRegionCode())) != null) {
            this.address[i++] = region;
        }
        return this.toAddressString(this.address, i);
    }

    private String toAddressString(KladrObject[] address, int count) {
        this.buf.setLength(0);
        for (int i = count - 1; i >= 0; --i) {
            KladrObject addressObject = address[i];
            if (addressObject == null) continue;
            this.buf.append(addressObject.getSocr()).append(". ").append(addressObject.getName()).append(", ");
        }
        this.buf.setLength(this.buf.length() - 2);
        return this.buf.toString();
    }
}

