package org.jamel.kladr;

/**
 * Таблицы КЛАДРа
 *
 * @author Sergey Polovko
 */
public enum KladrTable {

    /**
     * содержит записи с объектами первых четырех уровней классификации:
     * <ol>
     *     <li>регионы</li>
     *     <li>районы (улусы)</li>
     *     <li>города, поселки городского типа, сельсоветы</li>
     *     <li>сельские населенные пункты</li>
     * </ol>
     */
    KLADR,

    /**
     * содержит записи с объектами пятого уровня классификации:
     * <ol start="5">
     *     <li>улицы городов и населенных пунктов</li>
     * </ol>
     */
    STREET,

    /**
     * содержит записи с объектами шестого уровня классификации:
     * <ol start="6">
     *     <li>номера домов улиц городов и населенных пунктов</li>
     * </ol>
     */
    DOMA,

    /**
     * содержит записи с объектами седьмого уровня классификации:
     * <ol start="7">
     *     <li>номера квартир домов</li>
     * </ol>
     */
    FLAT,

    /**
     * содержит записи с краткими наименованиями типов адресных объектов
     */
    SOCRBASE,

    /**
     * содержит сведения о соответствии кодов записей со старыми и новыми наименованиями
     * адресных объектов, а также сведения о соответствии кодов адресных объектов до и
     * после их переподчинения
     */
    ALTNAMES,
    ;

    private final String fileName;


    private KladrTable() {
        this.fileName = name() + ".DBF";
    }

    public String getFileName() {
        return fileName;
    }
}
