/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.classifiedstats;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;

public class Result {
    private MultiKey classifierKeys;
    private List<Range<Double>> ranges;
    private int imageBand;
    private Statistic stat;
    private Double value;
    private long numOffered;
    private long numAccepted;
    private long numNaN;
    private long numNoData;

    public Result(int imageBand, Statistic stat, List<Range<Double>> ranges, Double value, long numOffered, long numAccepted, long numNaN, long numNoData, MultiKey classifierKeys) {
        this.imageBand = imageBand;
        this.stat = stat;
        this.value = value;
        this.numOffered = numOffered;
        this.numAccepted = numAccepted;
        this.numNaN = numNaN;
        this.numNoData = numNoData;
        this.ranges = ranges;
        this.classifierKeys = classifierKeys;
    }

    public Collection<Range<Double>> getRanges() {
        return Collections.unmodifiableCollection(this.ranges);
    }

    public int getImageBand() {
        return this.imageBand;
    }

    public Statistic getStatistic() {
        return this.stat;
    }

    public Double getValue() {
        return this.value;
    }

    public long getNumAccepted() {
        return this.numAccepted;
    }

    public long getNumOffered() {
        return this.numOffered;
    }

    public long getNumNaN() {
        return this.numNaN;
    }

    public long getNumNoData() {
        return this.numNoData;
    }

    public MultiKey getClassifierKeys() {
        return this.classifierKeys;
    }

    public String toString() {
        String rangess = this.ranges != null && !this.ranges.isEmpty() ? this.ranges.toString() : "";
        return String.format("band %d %s: %.4f Naccepted=%d (offered:%d - NoData:%d - NaN:%d) %s Classifier:%s", this.imageBand, this.stat, this.value, this.numAccepted, this.numOffered, this.numNoData, this.numNaN, rangess, this.classifierKeys);
    }
}

