/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.classifiedstats;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Collection;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;
import org.jaitools.media.jai.classifiedstats.ClassifiedStatsOpImage;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;

public class ClassifiedStatsRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        RenderedImage dataImage = paramBlock.getRenderedSource(0);
        RenderedImage[] classifierImages = null;
        RenderedImage[] pivotClassifierImages = null;
        classifierImages = (RenderedImage[])paramBlock.getObjectParameter(0);
        pivotClassifierImages = (RenderedImage[])paramBlock.getObjectParameter(1);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        if (layout == null) {
            layout = new ImageLayout();
        }
        Statistic[] stats = (Statistic[])paramBlock.getObjectParameter(2);
        Integer[] bands = (Integer[])paramBlock.getObjectParameter(3);
        Object localStats = paramBlock.getObjectParameter(7);
        Boolean rangeLocalStats = localStats != null ? (Boolean)localStats : Boolean.FALSE;
        Object rng = paramBlock.getObjectParameter(5);
        Collection ranges = rng != null ? (Collection)rng : null;
        Object noDataRng = paramBlock.getObjectParameter(8);
        Collection noDataRanges = noDataRng != null ? (Collection)noDataRng : null;
        Object rngType = paramBlock.getObjectParameter(6);
        Range.Type rangesType = rngType != null ? (Range.Type)rngType : (rng != null ? Range.Type.EXCLUDE : Range.Type.UNDEFINED);
        SampleModel sm = layout.getSampleModel(null);
        if (sm == null || sm.getNumBands() != stats.length) {
            int dataType = dataImage.getSampleModel().getDataType();
            if (dataType != 4 && dataType != 5) {
                for (Statistic stat : stats) {
                    if (stat.supportsIntegralResult()) continue;
                    dataType = 5;
                    break;
                }
            }
            sm = RasterFactory.createComponentSampleModel((SampleModel)dataImage.getSampleModel(), (int)dataType, (int)dataImage.getWidth(), (int)dataImage.getHeight(), (int)stats.length);
            layout.setSampleModel(sm);
            if (layout.getColorModel(null) != null) {
                ColorModel cm = ImageUtil.getCompatibleColorModel((SampleModel)sm, (Map)renderHints);
                layout.setColorModel(cm);
            }
        }
        Double[] noDataClassifiers = (Double[])paramBlock.getObjectParameter(9);
        Double[] noDataPivotClassifiers = (Double[])paramBlock.getObjectParameter(10);
        ROI roi = (ROI)paramBlock.getObjectParameter(4);
        return new ClassifiedStatsOpImage(dataImage, classifierImages, pivotClassifierImages, renderHints, layout, stats, bands, roi, ranges, rangesType, rangeLocalStats, noDataRanges, noDataClassifiers, noDataPivotClassifiers);
    }
}

