/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.classifiedstats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.jaitools.CollectionFactory;
import org.jaitools.media.jai.classifiedstats.Result;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;

public class ClassifiedStats {
    private List<Map<MultiKey, List<Result>>> results;

    ClassifiedStats() {
        HashMap map = new HashMap();
        this.results = new ArrayList<Map<MultiKey, List<Result>>>();
        this.results.add(map);
    }

    private ClassifiedStats(ClassifiedStats src, Integer band, Integer pivot, Statistic stat, List<Range<Double>> ranges) {
        this();
        int pivotIndex;
        Map<Object, Object> group = null;
        int n = pivotIndex = pivot == null ? 0 : pivot;
        if (pivotIndex < this.results.size()) {
            group = this.results.get(pivotIndex);
            if (group == null) {
                group = new HashMap();
                this.results.add(pivotIndex, group);
            }
        } else {
            group = new HashMap();
            this.results.add(group);
        }
        Set<MultiKey> ks = src.results.get(pivotIndex).keySet();
        for (MultiKey mk : ks) {
            List<Result> rs = src.results.get(pivotIndex).get(mk);
            List rsCopy = CollectionFactory.list();
            for (Result r : rs) {
                if (band != null && r.getImageBand() != band.intValue() || stat != null && r.getStatistic() != stat) continue;
                if (ranges == null || ranges.isEmpty()) {
                    rsCopy.add(r);
                    continue;
                }
                if (r.getRanges().containsAll(ranges)) {
                    rsCopy.add(r);
                    continue;
                }
                for (Range<Double> range : ranges) {
                    if (!r.getRanges().contains(range)) continue;
                    rsCopy.add(r);
                }
            }
            group.put(mk, rsCopy);
        }
    }

    void setResults(int band, int pivotIndex, MultiKey classificationKey, StreamingSampleStats stats, List<Range<Double>> ranges) {
        List rs;
        Map<Object, Object> group = null;
        if (pivotIndex < this.results.size()) {
            group = this.results.get(pivotIndex);
            if (group == null) {
                group = new HashMap();
                this.results.add(pivotIndex, group);
            }
        } else {
            group = new HashMap();
            this.results.add(group);
        }
        if ((rs = (List)group.get(classificationKey)) == null) {
            rs = CollectionFactory.list();
        }
        for (Statistic s : stats.getStatistics()) {
            Result r = new Result(band, s, ranges, stats.getStatisticValue(s), stats.getNumOffered(s), stats.getNumAccepted(s), stats.getNumNaN(s), stats.getNumNoData(s), classificationKey);
            rs.add(r);
        }
        group.put(classificationKey, rs);
    }

    void setResults(int band, int pivotIndex, MultiKey classifierKey, StreamingSampleStats stats) {
        this.setResults(band, pivotIndex, classifierKey, stats, null);
    }

    public ClassifiedStats band(int b) {
        return new ClassifiedStats(this, b, 0, null, null);
    }

    public ClassifiedStats group(int g) {
        return new ClassifiedStats(this, null, g, null, null);
    }

    public ClassifiedStats statistic(Statistic s) {
        return new ClassifiedStats(this, null, null, s, null);
    }

    public ClassifiedStats ranges(List<Range<Double>> ranges) {
        return new ClassifiedStats(this, null, null, null, ranges);
    }

    public List<Map<MultiKey, List<Result>>> results() {
        return Collections.unmodifiableList(this.results);
    }
}

