/*
 * Decompiled with CFR 0.152.
 */
package org.jabsaw.impl.pattern;

import java.util.Set;
import java.util.regex.Pattern;

public class ClassPattern {
    private final String originalPattern;
    private final long score;
    private final Pattern pattern;

    public ClassPattern(String pkg, String pattern) {
        this.originalPattern = pattern;
        if (pattern.startsWith(".")) {
            pattern = pkg.length() == 0 ? pattern.substring(1) : pkg + pattern;
        }
        this.score = this.calculateScore(pattern);
        this.pattern = this.createRegexpPattern(pattern);
    }

    private Pattern createRegexpPattern(String pattern) {
        if (pattern.endsWith("!")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        StringBuilder full = new StringBuilder(pattern.length());
        StringBuilder part = new StringBuilder(10);
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '*') {
                if (part.length() > 0) {
                    full.append(Pattern.quote(part.toString()));
                }
                part = new StringBuilder(10);
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '*') {
                    full.append(".*");
                    continue;
                }
                full.append("[^\\.]*");
                continue;
            }
            part.append(ch);
        }
        if (part.length() > 0) {
            full.append(Pattern.quote(part.toString()));
        }
        return Pattern.compile(full.toString());
    }

    private long calculateScore(String pattern) {
        boolean isImportant = false;
        if (pattern.endsWith("!")) {
            pattern = pattern.substring(0, pattern.length() - 1);
            isImportant = true;
        }
        String[] parts = pattern.split("\\.");
        long result = 0L;
        long factor = 2L;
        for (String part : parts) {
            int baseScore;
            if ("**".equals(part)) {
                baseScore = 4;
                factor = 1L;
            } else if ("*".equals(part)) {
                baseScore = 8;
                factor = 1L;
            } else if (part.contains("**")) {
                baseScore = 16;
                factor = 1L;
            } else if (part.contains("*")) {
                baseScore = 32;
                factor = 1L;
            } else {
                baseScore = 64;
            }
            result += (long)baseScore * factor;
        }
        if (isImportant) {
            result *= 1000L;
        }
        return result;
    }

    public String getOriginalPattern() {
        return this.originalPattern;
    }

    public long getScore() {
        return this.score;
    }

    public boolean matches(String qualifiedClassName) {
        return this.pattern.matcher(qualifiedClassName).matches();
    }

    public static ClassPattern getBestMatch(Set<ClassPattern> patterns, String qualifiedName) {
        ClassPattern result = null;
        for (ClassPattern p : patterns) {
            if (!p.matches(qualifiedName) || result != null && result.score >= p.score) continue;
            result = p;
        }
        return result;
    }

    public String toString() {
        return this.originalPattern;
    }
}

