/*
 * Decompiled with CFR 0.152.
 */
package org.jabsaw.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jabsaw.impl.model.ClassModel;
import org.jabsaw.impl.model.ModuleModel;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.TransitiveClosure;
import org.jgrapht.graph.SimpleDirectedGraph;

public class ProjectModel {
    private final HashMap<String, ClassModel> classes = new HashMap();
    private final HashMap<String, ModuleModel> modules = new HashMap();
    private boolean useModuleNames;
    boolean dependenciesResolved = false;

    public Map<String, ClassModel> getClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    public ClassModel getClassModel(String qualifiedName) {
        return this.classes.get(qualifiedName);
    }

    public Map<String, ModuleModel> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public Set<ModuleModel> getMatchingModules(ClassModel clazz) {
        HashSet<ModuleModel> result = new HashSet<ModuleModel>();
        for (ModuleModel module : this.modules.values()) {
            if (!module.isIncluded(clazz)) continue;
            result.add(module);
        }
        return result;
    }

    void addClass(ClassModel clazz) {
        this.checkDependenciesNotResolved();
        this.classes.put(clazz.getQualifiedName(), clazz);
    }

    void addModule(ModuleModel module) {
        this.checkDependenciesNotResolved();
        this.modules.put(module.getQualifiedNameOfRepresentingClass(), module);
    }

    public void checkDependenciesResolved() {
        if (!this.dependenciesResolved) {
            throw new Error("use resolveDependencies() to resolve dependencies");
        }
    }

    public void checkDependenciesNotResolved() {
        if (this.dependenciesResolved) {
            throw new Error("dependencies are already resolved");
        }
    }

    public void resolveDependencies() {
        if (this.dependenciesResolved) {
            throw new Error("Can resolve dependencies only once");
        }
        this.dependenciesResolved = true;
        for (ClassModel classModel : this.classes.values()) {
            classModel.resolveOuterClass();
        }
        for (ClassModel classModel : this.classes.values()) {
            classModel.resolveUsedClasses();
            if (classModel.outerClass != null) continue;
            classModel.resolveModule();
        }
        for (ClassModel classModel : new ArrayList<ClassModel>(this.classes.values())) {
            if (classModel.outerClass == null) continue;
            classModel.getToplevelClass().usesClasses.addAll(classModel.usesClasses);
            this.classes.remove(classModel.getQualifiedName());
        }
        for (ModuleModel moduleModel : this.modules.values()) {
            moduleModel.resolveDependencies();
        }
        this.calculateModuleDepenendencies();
    }

    void calculateModuleDepenendencies() {
        this.calculateExportedModules();
        this.calculateAccessibleModules();
        this.calculateModuleDependencies();
    }

    public void checkDependencyCycles(List<String> errors) {
        if (!this.dependenciesResolved) {
            throw new Error("Call resolveDependencies() first");
        }
        SimpleDirectedGraph<ModuleModel, Edge> g = this.buildModuleDependencyGraph();
        CycleDetector detector = new CycleDetector(g);
        Set cycleModules = detector.findCycles();
        if (!cycleModules.isEmpty()) {
            errors.add("Found cycle in module dependency graph. Involved modules: " + cycleModules);
        }
    }

    private SimpleDirectedGraph<ModuleModel, Edge> buildModuleDependencyGraph() {
        SimpleDirectedGraph<ModuleModel, Edge> g = this.buildExportGraph();
        for (ModuleModel module : this.modules.values()) {
            for (ModuleModel imported : module.importedModules) {
                g.addEdge((Object)module, (Object)imported);
            }
        }
        return g;
    }

    private void calculateExportedModules() {
        SimpleDirectedGraph<ModuleModel, Edge> g = this.buildExportGraph();
        TransitiveClosure.INSTANCE.closeSimpleDirectedGraph(g);
        for (ModuleModel module : this.modules.values()) {
            module.allExportedModules.add(module);
            for (Edge e : g.outgoingEdgesOf((Object)module)) {
                module.allExportedModules.add((ModuleModel)g.getEdgeTarget((Object)e));
            }
        }
    }

    private void calculateModuleDependencies() {
        SimpleDirectedGraph<ModuleModel, Edge> g = this.buildModuleDependencyGraph();
        TransitiveClosure.INSTANCE.closeSimpleDirectedGraph(g);
        for (ModuleModel module : this.modules.values()) {
            module.allModuleDependencies.add(module);
            for (Edge e : g.outgoingEdgesOf((Object)module)) {
                module.allModuleDependencies.add((ModuleModel)g.getEdgeTarget((Object)e));
            }
        }
    }

    private SimpleDirectedGraph<ModuleModel, Edge> buildExportGraph() {
        SimpleDirectedGraph g = new SimpleDirectedGraph((EdgeFactory)new EdgeFactory<ModuleModel, Edge>(){

            public Edge createEdge(ModuleModel sourceVertex, ModuleModel targetVertex) {
                return new Edge();
            }
        });
        for (ModuleModel module : this.modules.values()) {
            g.addVertex((Object)module);
        }
        for (ModuleModel module : this.modules.values()) {
            for (ModuleModel exported : module.exportedModules) {
                g.addEdge((Object)module, (Object)exported);
            }
        }
        return g;
    }

    private void calculateAccessibleModules() {
        for (ModuleModel module : this.modules.values()) {
            module.allAccessibleModules.add(module);
            for (ModuleModel imported : module.getReferencedModules()) {
                module.allAccessibleModules.addAll(imported.allExportedModules);
            }
        }
    }

    public ModuleModel getModule(String qualifiedNameOfRepresentingClass) {
        return this.modules.get(qualifiedNameOfRepresentingClass);
    }

    public void checkClassAccessibility(List<String> errors) {
        for (ClassModel clazz : this.classes.values()) {
            clazz.checkAccessibilityOfUsedClasses(errors);
        }
    }

    public void checkAllClassesInModule(List<String> errors) {
        for (ClassModel clazz : this.classes.values()) {
            if (clazz.getModule() != null) continue;
            errors.add("Class " + clazz + " is in no module");
        }
    }

    public String details() {
        StringBuilder sb = new StringBuilder();
        for (ModuleModel module : this.modules.values()) {
            sb.append(module.details());
            sb.append("\n");
        }
        for (ClassModel clazz : this.classes.values()) {
            sb.append(clazz.details());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isDependenciesResolved() {
        return this.dependenciesResolved;
    }

    public boolean isUseModuleNames() {
        return this.useModuleNames;
    }

    public void setUseModuleNames(boolean useModuleNames) {
        this.useModuleNames = useModuleNames;
    }

    private static class Edge {
        private Edge() {
        }
    }
}

