/*
 * Decompiled with CFR 0.152.
 */
package org.jabsaw.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jabsaw.impl.model.ClassModel;
import org.jabsaw.impl.model.ModelNode;
import org.jabsaw.impl.model.ProjectModel;
import org.jabsaw.impl.pattern.ClassPattern;

public class ModuleModel
implements ModelNode {
    private final ProjectModel projectModel;
    private final String qualifiedNameOfRepresentingClass;
    String name;
    String description;
    final Set<ClassModel> classes = new HashSet<ClassModel>();
    final Set<ClassPattern> inclusionPatterns = new HashSet<ClassPattern>();
    final Set<ClassPattern> exclusionPatterns = new HashSet<ClassPattern>();
    final Set<String> exportedModuleNames = new HashSet<String>();
    final Set<String> importedModuleNames = new HashSet<String>();
    final Set<ModuleModel> exportedModules = new HashSet<ModuleModel>();
    final Set<ModuleModel> importedModules = new HashSet<ModuleModel>();
    final Set<ModuleModel> allAccessibleModules = new HashSet<ModuleModel>();
    final Set<ModuleModel> allExportedModules = new HashSet<ModuleModel>();
    final Set<ModuleModel> allModuleDependencies = new HashSet<ModuleModel>();
    private boolean hideFromDependencyGraphOutput;
    public Set<ClassModel> allClassDependencies = new HashSet<ClassModel>();

    public ModuleModel(ProjectModel projectModel, String qualifiedNameOfRepresentingClass) {
        this.projectModel = projectModel;
        this.qualifiedNameOfRepresentingClass = qualifiedNameOfRepresentingClass;
        projectModel.addModule(this);
        String[] parts = qualifiedNameOfRepresentingClass.split("\\.");
        this.name = parts[parts.length - 1];
        if (this.name.endsWith("Module")) {
            this.name = this.name.substring(0, this.name.length() - "Module".length());
        }
    }

    public ProjectModel getProjectModel() {
        return this.projectModel;
    }

    public String getQualifiedNameOfRepresentingClass() {
        return this.qualifiedNameOfRepresentingClass;
    }

    public String getName() {
        return this.name;
    }

    public Set<ClassModel> getClasses() {
        return Collections.unmodifiableSet(this.classes);
    }

    public void addClass(ClassModel clazz) {
        if (clazz.module != null) {
            clazz.module.classes.remove(clazz);
        }
        this.classes.add(clazz);
        clazz.module = this;
    }

    public void resolveDependencies() {
        ModuleModel module;
        for (String name : this.importedModuleNames) {
            module = this.projectModel.getModule(name);
            if (module == null) {
                throw new RuntimeException("Module " + this.getIdentification() + ": could not find imported module " + name);
            }
            this.importedModules.add(module);
        }
        for (String name : this.exportedModuleNames) {
            module = this.projectModel.getModule(name);
            if (module == null) {
                throw new RuntimeException("Module " + this.qualifiedNameOfRepresentingClass + ": could not find exported module " + name);
            }
            this.exportedModules.add(module);
        }
    }

    public void addInclusionPattern(ClassPattern pattern) {
        this.inclusionPatterns.add(pattern);
    }

    public void addExclusionPattern(ClassPattern pattern) {
        this.exclusionPatterns.add(pattern);
    }

    public void addImportedModuleName(String qualifiedNameOfRepresentingClass) {
        this.importedModuleNames.add(qualifiedNameOfRepresentingClass);
    }

    public void addExportedModuleName(String qualifiedNameOfRepresentingClass) {
        this.exportedModuleNames.add(qualifiedNameOfRepresentingClass);
    }

    public boolean isIncluded(ClassModel model) {
        return this.isIncluded(model.getQualifiedName());
    }

    private boolean isIncluded(String qualifiedName) {
        ClassPattern bestInclusionMatch = ClassPattern.getBestMatch(this.inclusionPatterns, qualifiedName);
        ClassPattern bestExclusionMatch = ClassPattern.getBestMatch(this.exclusionPatterns, qualifiedName);
        if (bestInclusionMatch == null) {
            return false;
        }
        if (bestExclusionMatch == null) {
            return true;
        }
        if (bestExclusionMatch.getScore() == bestInclusionMatch.getScore()) {
            throw new RuntimeException("Module " + this.qualifiedNameOfRepresentingClass + ": contradicting patterns found for class " + qualifiedName + ": inclusion pattern " + bestInclusionMatch + "; exclusion pattern " + bestExclusionMatch);
        }
        return bestInclusionMatch.getScore() > bestExclusionMatch.getScore();
    }

    public String toString() {
        return this.getIdentification();
    }

    public boolean isAccessible(ClassModel clazz) {
        if (clazz.getModule() == null) {
            return true;
        }
        return this.allAccessibleModules.contains(clazz.getModule());
    }

    public String details() {
        StringBuilder sb = new StringBuilder();
        sb.append("Module " + this.qualifiedNameOfRepresentingClass + "\n");
        sb.append("Name " + this.name + "\n");
        sb.append("Description " + this.description + "\n");
        sb.append("imported: " + this.importedModules + "\n");
        sb.append("exported: " + this.exportedModules + "\n");
        sb.append("all accessible: " + this.allAccessibleModules + "\n");
        sb.append("all exported: " + this.allExportedModules + "\n");
        sb.append("included: " + this.inclusionPatterns + "\n");
        sb.append("excluded: " + this.exclusionPatterns + "\n");
        sb.append("classes: " + this.classes + "\n");
        return sb.toString();
    }

    public String getPackage() {
        String[] parts = this.qualifiedNameOfRepresentingClass.split("\\.");
        if (parts.length == 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public Set<ClassPattern> getInclusionPatterns() {
        return Collections.unmodifiableSet(this.inclusionPatterns);
    }

    public Set<ClassPattern> getExclusionPatterns() {
        return Collections.unmodifiableSet(this.exclusionPatterns);
    }

    public Set<String> getExportedModuleNames() {
        return Collections.unmodifiableSet(this.exportedModuleNames);
    }

    public Set<String> getImportedModuleNames() {
        return Collections.unmodifiableSet(this.importedModuleNames);
    }

    public Set<ModuleModel> getAllModuleDependencies() {
        return Collections.unmodifiableSet(this.allModuleDependencies);
    }

    public Set<ModuleModel> getImportedModules() {
        return Collections.unmodifiableSet(this.importedModules);
    }

    public Set<ModuleModel> getReferencedModules() {
        HashSet<ModuleModel> set = new HashSet<ModuleModel>();
        set.addAll(this.exportedModules);
        set.addAll(this.importedModules);
        return set;
    }

    public Set<ModuleModel> getExportedModules() {
        return Collections.unmodifiableSet(this.exportedModules);
    }

    public Set<ClassModel> getAllClassDependencies() {
        HashSet<ClassModel> result = new HashSet<ClassModel>();
        for (ModuleModel module : this.allModuleDependencies) {
            for (ClassModel clazz : module.classes) {
                ClassModel.getAllClassDependencies(result, clazz);
            }
        }
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIdentification() {
        if (this.projectModel.isUseModuleNames()) {
            return this.name;
        }
        return this.qualifiedNameOfRepresentingClass;
    }

    public boolean isHideFromDependencyGraphOutput() {
        return this.hideFromDependencyGraphOutput;
    }

    public void setHideFromDependencyGraphOutput(boolean hideFromDependencyGraphOutput) {
        this.hideFromDependencyGraphOutput = hideFromDependencyGraphOutput;
    }
}

