/*
 * Decompiled with CFR 0.152.
 */
package org.jabsaw.impl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jabsaw.impl.model.ModelNode;
import org.jabsaw.impl.model.ModuleModel;
import org.jabsaw.impl.model.ProjectModel;

public class ClassModel
implements ModelNode {
    private final ProjectModel projectModel;
    private final String qualifiedName;
    ClassModel outerClass;
    ModuleModel module;
    final Set<ClassModel> usesClasses = new HashSet<ClassModel>();
    final Set<String> usesClassNames = new HashSet<String>();
    public String outerClassName;
    private ClassModel toplevelClass;
    public Set<String> innerClassNames = new HashSet<String>();

    public ClassModel(ProjectModel projectModel, String qualifiedName) {
        this.projectModel = projectModel;
        this.qualifiedName = qualifiedName;
        projectModel.addClass(this);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public ProjectModel getProjectModel() {
        return this.projectModel;
    }

    public Set<ClassModel> getUsesClasses() {
        return Collections.unmodifiableSet(this.usesClasses);
    }

    public void addUsesClass(ClassModel clazz) {
        this.usesClasses.add(clazz);
    }

    public Set<String> getUsesClassNames() {
        return Collections.unmodifiableSet(this.usesClassNames);
    }

    public void addUsesClassName(String name) {
        this.usesClassNames.add(name);
    }

    public ModuleModel getModule() {
        return this.module;
    }

    public void setModule(ModuleModel module) {
        if (this.module != null) {
            this.module.classes.remove(this);
        }
        this.module = module;
        if (module != null) {
            module.addClass(this);
        }
    }

    public void resolveModule() {
        Set<ModuleModel> matchingModules = this.projectModel.getMatchingModules(this);
        if (matchingModules.size() > 1) {
            throw new RuntimeException("Multiple Modules found for class " + this.qualifiedName + ": " + matchingModules);
        }
        if (matchingModules.size() == 1) {
            this.setModule(matchingModules.iterator().next());
        }
    }

    public void resolveUsedClasses() {
        for (String usesClassName : this.usesClassNames) {
            ClassModel classModel = this.projectModel.getClassModel(usesClassName);
            if (classModel == null) continue;
            this.addUsesClass(classModel.getToplevelClass());
        }
    }

    public void resolveOuterClass() {
        ClassModel clazz;
        for (String name : this.innerClassNames) {
            ClassModel clazz2 = this.projectModel.getClassModel(name);
            if (clazz2 == null) continue;
            clazz2.outerClass = this;
        }
        if (this.outerClassName != null && (clazz = this.projectModel.getClassModel(this.outerClassName)) != null) {
            this.outerClass = clazz;
        }
    }

    public void checkAccessibilityOfUsedClasses(List<String> errors) {
        if (this.module == null) {
            return;
        }
        for (ClassModel clazz : this.usesClasses) {
            if (this.module.isAccessible(clazz)) continue;
            errors.add("Class " + this + " references class " + clazz + ", which is not accessible for classes in module " + this.module);
        }
    }

    public String toString() {
        return this.qualifiedName;
    }

    public String details() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class " + this.qualifiedName + "\n");
        sb.append("module: " + this.module + "\n");
        sb.append("usesClasses: " + this.usesClasses + "\n");
        return sb.toString();
    }

    ClassModel getToplevelClass() {
        if (this.toplevelClass == null) {
            HashSet<ClassModel> visited = new HashSet<ClassModel>();
            this.toplevelClass = this;
            while (this.toplevelClass.outerClass != null && visited.add(this.toplevelClass)) {
                this.toplevelClass = this.toplevelClass.outerClass;
            }
        }
        return this.toplevelClass;
    }

    public Set<ClassModel> getAllClassDependencies() {
        HashSet<ClassModel> result = new HashSet<ClassModel>();
        ClassModel.getAllClassDependencies(result, this);
        return result;
    }

    static void getAllClassDependencies(HashSet<ClassModel> result, ClassModel classModel) {
        if (!result.add(classModel)) {
            return;
        }
        for (ClassModel clazz : classModel.usesClasses) {
            ClassModel.getAllClassDependencies(result, clazz);
        }
    }

    public String getSimpleName() {
        String[] parts = this.qualifiedName.split("\\.");
        return parts[parts.length - 1];
    }
}

