/*
 * Decompiled with CFR 0.152.
 */
package org.jabsaw.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.jabsaw.impl.model.ClassModel;
import org.jabsaw.impl.model.ModuleModel;
import org.jabsaw.impl.model.ProjectModel;
import org.jabsaw.impl.pattern.ClassPattern;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassParser {
    private final ProjectModel project = new ProjectModel();

    public ProjectModel getProject() {
        return this.project;
    }

    public void parseDirectory(ArrayList<String> errors, Path directory, final DirectoryParsingCallback callback) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isRegularFile() && file.getFileName().toString().endsWith(".class")) {
                        callback.parsingFile(file);
                        try {
                            ClassParser.this.parse(file);
                        }
                        catch (Throwable t) {
                            StringWriter writer = new StringWriter();
                            t.printStackTrace(new PrintWriter(writer));
                            callback.error("Error while parsing " + file + ": " + t.getMessage() + "\n" + writer.toString());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading input files", e);
        }
    }

    public void parse(Path file) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            ClassReader reader = new ClassReader((InputStream)fis);
            this.parse(reader);
        }
    }

    public void parse(ClassReader reader) {
        reader.accept((ClassVisitor)new ParsingClassVisitor(), 4);
    }

    public void handleClassOrMethodSignature(ClassModel classModel, String signature) {
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            reader.accept((SignatureVisitor)new ParsingSignatureReader(classModel));
        }
    }

    public void handleFieldSignature(ClassModel classModel, String signature) {
        if (signature != null) {
            SignatureReader reader = new SignatureReader(signature);
            reader.acceptType((SignatureVisitor)new ParsingSignatureReader(classModel));
        }
    }

    public void handleMethodDescriptor(ClassModel classModel, String desc) {
        Type type = Type.getType((String)desc);
        this.handleType(classModel, type.getReturnType());
        for (Type p : type.getArgumentTypes()) {
            this.handleType(classModel, p);
        }
    }

    void handleTypeDescriptor(ClassModel classModel, String desc) {
        this.handleType(classModel, Type.getType((String)desc));
    }

    void handleType(ClassModel classModel, String internalName) {
        if (internalName != null) {
            this.handleType(classModel, Type.getObjectType((String)internalName));
        }
    }

    void handleType(ClassModel classModel, Type type) {
        classModel.addUsesClassName(type.getClassName());
    }

    public class ParsingSignatureReader
    extends SignatureVisitor {
        private ClassModel classModel;

        public ParsingSignatureReader(ClassModel classModel) {
            super(327680);
            this.classModel = classModel;
        }

        public SignatureVisitor visitClassBound() {
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return this;
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            return this;
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public void visitClassType(String name) {
            ClassParser.this.handleType(this.classModel, name);
        }
    }

    public class ParsingMethodVisitor
    extends MethodVisitor {
        private ClassModel classModel;

        public ParsingMethodVisitor(ClassModel classModel) {
            super(327680);
            this.classModel = classModel;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public void visitTypeInsn(int opcode, String type) {
            ClassParser.this.handleType(this.classModel, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            ClassParser.this.handleMethodDescriptor(this.classModel, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            ClassParser.this.handleMethodDescriptor(this.classModel, desc);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            ClassParser.this.handleMethodDescriptor(this.classModel, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            ClassParser.this.handleType(this.classModel, type);
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            ClassParser.this.handleFieldSignature(this.classModel, signature);
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                Type type = (Type)cst;
                if (type.getSort() == 10) {
                    ClassParser.this.handleType(this.classModel, type);
                } else if (type.getSort() == 9) {
                    ClassParser.this.handleType(this.classModel, type.getElementType());
                }
            }
        }
    }

    public class ParsingAnnotationVisitor
    extends AnnotationVisitor {
        private ClassModel classModel;

        public ParsingAnnotationVisitor(ClassModel classModel) {
            super(327680);
            this.classModel = classModel;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return this;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.classModel.addUsesClassName(((Type)value).getClassName());
            }
            if (value instanceof Type[]) {
                for (Type t : (Type[])value) {
                    this.classModel.addUsesClassName(t.getClassName());
                }
            }
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public void visitEnum(String name, String desc, String value) {
            this.classModel.addUsesClassName(Type.getObjectType((String)desc).getClassName());
        }
    }

    public class ModuleAnnotationArrayVisitor
    extends AnnotationVisitor {
        ModuleModel module;
        private String arrayName;

        public ModuleAnnotationArrayVisitor(ModuleModel module, String arrayName) {
            super(327680);
            this.module = module;
            this.arrayName = arrayName;
        }

        public void visit(String name, Object value) {
            if ("imported".equals(this.arrayName)) {
                this.module.addImportedModuleName(((Type)value).getClassName());
            }
            if ("exported".equals(this.arrayName)) {
                this.module.addExportedModuleName(((Type)value).getClassName());
            }
            if ("include".equals(this.arrayName)) {
                this.module.addInclusionPattern(new ClassPattern(this.module.getPackage(), ((Type)value).getClassName()));
            }
            if ("includePattern".equals(this.arrayName)) {
                this.module.addInclusionPattern(new ClassPattern(this.module.getPackage(), (String)value));
            }
            if ("exclude".equals(this.arrayName)) {
                this.module.addExclusionPattern(new ClassPattern(this.module.getPackage(), ((Type)value).getClassName()));
            }
            if ("excludePattern".equals(this.arrayName)) {
                this.module.addExclusionPattern(new ClassPattern(this.module.getPackage(), (String)value));
            }
        }
    }

    public class ModuleAnnotationVisitor
    extends AnnotationVisitor {
        ModuleModel module;
        private boolean includePackage;

        public ModuleAnnotationVisitor(String enclosingClass) {
            super(327680);
            this.includePackage = true;
            this.module = new ModuleModel(ClassParser.this.project, enclosingClass);
        }

        public void visit(String name, Object value) {
            String s;
            if ("includePackage".equals(name)) {
                this.includePackage = (Boolean)value;
            }
            if ("hideFromDependencyGraphOutput".equals(name)) {
                this.module.setHideFromDependencyGraphOutput((Boolean)value);
            }
            if ("name".equals(name) && (s = (String)value) != null && !s.isEmpty()) {
                this.module.setName(s);
            }
            if ("description".equals(name) && (s = (String)value) != null && !s.isEmpty()) {
                this.module.setDescription(s);
            }
        }

        public AnnotationVisitor visitArray(String name) {
            return new ModuleAnnotationArrayVisitor(this.module, name);
        }

        public void visitEnd() {
            if (this.includePackage) {
                this.module.addInclusionPattern(new ClassPattern(this.module.getPackage(), ".*"));
            }
        }
    }

    public class ParsingFieldVisitor
    extends FieldVisitor {
        private ClassModel classModel;

        public ParsingFieldVisitor(ClassModel classModel) {
            super(327680);
            this.classModel = classModel;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }
    }

    class ParsingClassVisitor
    extends ClassVisitor {
        ClassModel classModel;

        public ParsingClassVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classModel = new ClassModel(ClassParser.this.project, Type.getObjectType((String)name).getClassName());
            ClassParser.this.handleClassOrMethodSignature(this.classModel, signature);
            ClassParser.this.handleType(this.classModel, superName);
            for (String s : interfaces) {
                ClassParser.this.handleType(this.classModel, s);
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            super.visitOuterClass(owner, name, desc);
            this.classModel.outerClassName = Type.getObjectType((String)owner).getClassName();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if ("org.jabsaw.Module".equals(Type.getType((String)desc).getClassName())) {
                return new ModuleAnnotationVisitor(this.classModel.getQualifiedName());
            }
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingAnnotationVisitor(this.classModel);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (name != null && outerName != null) {
                if (Type.getObjectType((String)name).getClassName().equals(this.classModel.getQualifiedName())) {
                    this.classModel.outerClassName = Type.getObjectType((String)outerName).getClassName();
                }
                if (Type.getObjectType((String)outerName).getClassName().equals(this.classModel.getQualifiedName())) {
                    this.classModel.innerClassNames.add(Type.getObjectType((String)name).getClassName());
                }
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassParser.this.handleClassOrMethodSignature(this.classModel, signature);
            ClassParser.this.handleMethodDescriptor(this.classModel, desc);
            if (exceptions != null) {
                for (String s : exceptions) {
                    ClassParser.this.handleType(this.classModel, s);
                }
            }
            return new ParsingMethodVisitor(this.classModel);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassParser.this.handleFieldSignature(this.classModel, signature);
            ClassParser.this.handleTypeDescriptor(this.classModel, desc);
            return new ParsingFieldVisitor(this.classModel);
        }
    }

    public static interface DirectoryParsingCallback {
        public void parsingFile(Path var1);

        public void error(String var1);
    }
}

