/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.exceptions;

import java.io.IOException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.TelegramError;
import org.isuper.telegram.utils.TelegramUtils;

public class UnrecoverableErrorResponseException
extends Exception {
    private static final long serialVersionUID = 1982120160365789796L;
    private final TelegramError error;
    private final List<NameValuePair> requestFormItems;

    public UnrecoverableErrorResponseException(String rawContent, List<NameValuePair> requestFormItems) {
        try {
            this.error = (TelegramError)TelegramUtils.getObjectMapper().readValue(rawContent, TelegramError.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Failed to parse TelegramErrorResponse from %s", rawContent));
        }
        this.requestFormItems = requestFormItems;
    }

    public UnrecoverableErrorResponseException(TelegramError error, List<NameValuePair> requestFormItems) {
        Preconditions.notNull((Object)error, (String)"Error should be provided.");
        this.error = error;
        this.requestFormItems = requestFormItems;
    }

    @Override
    public String getMessage() {
        return String.format("[%d]%s", this.getError().getErrorCode(), this.getError().getDescription());
    }

    public TelegramError getError() {
        return this.error;
    }

    public List<NameValuePair> getRequestFormItems() {
        return this.requestFormItems;
    }
}

