/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.bot;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.TelegramApiBuilder;
import org.isuper.telegram.api.TelegramBotApi;
import org.isuper.telegram.api.models.Update;
import org.isuper.telegram.api.models.http.ApiErrorResponse;
import org.isuper.telegram.api.models.http.ApiResponse;
import org.isuper.telegram.api.models.http.GetUpdatesPayload;
import org.isuper.telegram.bot.BotSessionStore;
import org.isuper.telegram.bot.MemoryBasedBotSessionStore;
import org.isuper.telegram.bot.UpdateHandler;
import org.isuper.telegram.utils.TelegramUtils;
import retrofit2.Response;

public class StandaloneTelegramBot {
    public static final int DEFAULT_GET_UPDATES_LIMIT = 100;
    public static final int DEFAULT_GET_UPDATES_TIMEOUT_IN_SEC = 60;
    public static final String[] DEFAULT_ALLOWED_UPDATE_TYPE = null;
    private static final ExecutorService ES = Executors.newFixedThreadPool(2);
    private final String apiToken;
    private final UpdateHandler updateHander;
    private Integer limit;
    private Integer timeout;
    private String[] allowedUpdates;
    private BotSessionStore sessionStore;
    private UpdateQuerier querier;
    private UpdateProcessor processor;

    public StandaloneTelegramBot(String apiToken, UpdateHandler updateHander) {
        Preconditions.notEmptyString((String)apiToken, (String)"Telegram API token should be specified");
        this.apiToken = apiToken;
        Preconditions.notNull((Object)updateHander, (String)"Updates handler should be specified");
        this.updateHander = updateHander;
    }

    public void start() {
        BotSessionStore store = this.sessionStore == null ? new MemoryBasedBotSessionStore() : this.sessionStore;
        try {
            this.processor = new UpdateProcessor(store, this.updateHander);
            ES.submit(this.processor);
            this.querier = new UpdateQuerier(store, this.apiToken, this.limit, this.timeout, this.allowedUpdates);
            ES.submit(this.querier).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.stop();
            ES.shutdown();
            store.save();
        }
    }

    public StandaloneTelegramBot setBotSessionStore(BotSessionStore sessionStore) {
        this.sessionStore = sessionStore;
        return this;
    }

    public StandaloneTelegramBot setGetUpdatesLimit(Integer limit) {
        this.limit = limit == null ? 100 : limit;
        return this;
    }

    public StandaloneTelegramBot setGetUpdatesTimeoutInSec(Integer timeout) {
        this.timeout = timeout == null || timeout <= 0 ? null : timeout;
        return this;
    }

    public StandaloneTelegramBot setAllowedUpdateTypes(String ... allowedUpdates) {
        this.allowedUpdates = allowedUpdates;
        return this;
    }

    public void stop() {
        if (this.querier != null) {
            this.querier.stop();
        }
        if (this.processor != null) {
            this.processor.stop();
        }
    }

    private static class UpdateQuerier
    implements Runnable {
        private static final Logger LOGGER = LogManager.getLogger((String)UpdateQuerier.class.getName());
        private final BotSessionStore sessionStore;
        private final TelegramBotApi api;
        private final String apiToken;
        private final Integer limit;
        private final Integer timeout;
        private final String[] allowedUpdates;
        private boolean stopped = false;

        UpdateQuerier(BotSessionStore sessionStore, String apiToken, Integer limit, Integer timeout, String ... allowedUpdates) {
            Preconditions.notNull((Object)sessionStore, (String)"Updates queue should be specified");
            this.sessionStore = sessionStore;
            this.api = new TelegramApiBuilder().build();
            Preconditions.notEmptyString((String)apiToken, (String)"Telegram API token should be specified");
            this.apiToken = apiToken;
            this.limit = limit == null ? 100 : limit;
            this.timeout = timeout == null || timeout <= 0 ? null : timeout;
            this.allowedUpdates = allowedUpdates;
        }

        @Override
        public void run() {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                List received;
                if (this.sessionStore.hasUpdates()) {
                    LOGGER.debug("There're still some updates need to be proceeded, skip querying latest updates.");
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                long lastReceivedUpdateId = this.sessionStore.getLastReceivedUpdateId();
                GetUpdatesPayload payload = new GetUpdatesPayload(this.sessionStore.getLastReceivedUpdateId() + 1L, this.limit, this.timeout, this.allowedUpdates);
                try {
                    Response resp = this.api.getUpdates(this.apiToken, payload).execute();
                    if (resp.isSuccessful()) {
                        received = (List)((ApiResponse)resp.body()).getResult();
                        LOGGER.debug(String.format("Received %d update(s)", received.size()));
                        received = received.stream().filter(update -> update != null && update.id > lastReceivedUpdateId).collect(Collectors.toList());
                    } else {
                        ApiErrorResponse errResp = (ApiErrorResponse)TelegramUtils.getObjectMapper().readValue(resp.errorBody().bytes(), ApiErrorResponse.class);
                        LOGGER.error(errResp.getDescription());
                        received = Collections.emptyList();
                    }
                }
                catch (IOException ioe) {
                    received = Collections.emptyList();
                }
                if (received.isEmpty()) {
                    LOGGER.debug("No new update available.");
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                LOGGER.debug(String.format("Received %d new update(s)", received.size()));
                this.sessionStore.addUpdates(received);
                this.sessionStore.setLastReceivedUpdateId(received.parallelStream().map(update -> update.id).max(Long::compareTo).orElse(0L));
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    private static class UpdateProcessor
    implements Runnable {
        private static final Logger LOGGER = LogManager.getLogger((String)UpdateProcessor.class.getName());
        private final BotSessionStore sessionStore;
        private final UpdateHandler updateHander;
        private boolean stopped = false;

        UpdateProcessor(BotSessionStore sessionStore, UpdateHandler updateHander) {
            Preconditions.notNull((Object)sessionStore, (String)"Bot session store should be specified");
            this.sessionStore = sessionStore;
            Preconditions.notNull((Object)updateHander, (String)"Updates handler should be specified");
            this.updateHander = updateHander;
        }

        @Override
        public void run() {
            Update update = null;
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                try {
                    Update tmpUpdate = this.sessionStore.getLastUnprocessedUpdate();
                    if (tmpUpdate != null) {
                        update = tmpUpdate;
                    } else {
                        if (!this.sessionStore.hasUpdates()) {
                            LOGGER.debug("No more update available.");
                            try {
                                TimeUnit.MILLISECONDS.sleep(200L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        try {
                            update = this.sessionStore.retrieveUpdate(1L, TimeUnit.SECONDS);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (update == null) {
                        TimeUnit.MILLISECONDS.sleep(200L);
                        continue;
                    }
                    boolean processed = this.updateHander.handleUpdate(update);
                    if (processed) continue;
                    this.sessionStore.setLastUnprocessedUpdate(update);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

