/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.bot;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.Command;
import org.isuper.telegram.api.models.Message;
import org.isuper.telegram.api.models.Update;
import org.isuper.telegram.api.models.inline.ChosenInlineResult;
import org.isuper.telegram.api.models.inline.InlineQuery;
import org.isuper.telegram.bot.UpdateHandler;
import org.isuper.telegram.utils.TelegramUtils;

public abstract class DefaultUpdateHandler
implements UpdateHandler {
    @Override
    public boolean handleUpdate(Update update) {
        if (update == null) {
            return false;
        }
        ResourceBundle bundle = this.getResourceBundle(update);
        if (update.inlineQuery != null) {
            this.handleInlineQuery(bundle, update.inlineQuery);
        } else if (update.chosenInlineResult != null) {
            this.handleChosenInlineResult(bundle, update.chosenInlineResult);
        } else if (update.message != null) {
            if (update.message.newChatMember != null) {
                this.handleNewChatMember(bundle, update.message);
            } else if (update.message.leftChatMember != null) {
                this.handleLeftChatMember(bundle, update.message);
            } else if (update.message.location != null) {
                this.handleLocationMessage(bundle, update.message);
            } else if (!Preconditions.isEmptyString((String)update.message.text)) {
                Command cmd = TelegramUtils.parseCommandFromText(update.message.text);
                if (cmd == null) {
                    this.handleOrdinaryTextMessage(bundle, update.message);
                } else if (Preconditions.isEmptyString((String)cmd.toBot) || this.getRobotUsername().equalsIgnoreCase(cmd.toBot)) {
                    this.handleCommands(bundle, cmd, update.message);
                }
            }
        } else if (update.editedMessage != null) {
            this.handleEditedTextMessage(bundle, update.editedMessage);
        } else {
            try {
                this.getLogger().warn(TelegramUtils.getObjectMapper().writeValueAsString((Object)update));
            }
            catch (JsonProcessingException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    protected abstract Logger getLogger();

    protected abstract ResourceBundle getResourceBundle(Update var1);

    protected abstract String getRobotUsername();

    protected abstract void handleNewChatMember(ResourceBundle var1, Message var2);

    protected abstract void handleLeftChatMember(ResourceBundle var1, Message var2);

    protected abstract void handleLocationMessage(ResourceBundle var1, Message var2);

    protected abstract void handleOrdinaryTextMessage(ResourceBundle var1, Message var2);

    protected abstract void handleEditedTextMessage(ResourceBundle var1, Message var2);

    protected abstract void handleCommands(ResourceBundle var1, Command var2, Message var3);

    protected abstract void handleInlineQuery(ResourceBundle var1, InlineQuery var2);

    protected abstract void handleChosenInlineResult(ResourceBundle var1, ChosenInlineResult var2);
}

