/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.inline;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.Location;
import org.isuper.telegram.api.models.User;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQuery {
    @JsonProperty(value="id")
    public final String id;
    @JsonProperty(value="from")
    public final User from;
    @JsonProperty(value="location")
    public final Location location;
    @JsonProperty(value="query")
    public final String query;
    @JsonProperty(value="offset")
    public final String offset;

    @JsonCreator
    public InlineQuery(@JsonProperty(value="id") String id, @JsonProperty(value="from") User from, @JsonProperty(value="location") Location location, @JsonProperty(value="query") String query, @JsonProperty(value="offset") String offset) {
        Preconditions.notEmptyString((String)id, (String)"Inline query ID should be provided.");
        this.id = id;
        Preconditions.notNull((Object)from, (String)"Sender should be provided.");
        this.from = from;
        this.location = location;
        Preconditions.notNull((Object)query, (String)"Text of the query should be provided.");
        this.query = query;
        this.offset = offset;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

