/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.MessageParseMode;
import org.isuper.telegram.api.models.markups.ReplyMarkup;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SendMessagePayload {
    private final String chatId;
    private final String text;
    private final MessageParseMode parseMode;
    private final Boolean disablePreview;
    private final Boolean disableNotification;
    private final Long replyTo;
    private final ReplyMarkup replyMarkup;

    public SendMessagePayload(String chatId, String text) {
        this("" + chatId, text, null, null, null, null, null);
    }

    public SendMessagePayload(String chatId, String text, long replyTo) {
        this("" + chatId, text, null, null, null, replyTo, null);
    }

    public SendMessagePayload(String chatId, String text, MessageParseMode parseMode, Boolean disablePreview, Boolean disableNotification, Long replyTo, ReplyMarkup replyMarkup) {
        Preconditions.notEmptyString((String)chatId, (String)"Chat ID should be provided");
        this.chatId = chatId;
        Preconditions.notEmptyString((String)text, (String)"Content of the message should be provided");
        this.text = text;
        this.parseMode = parseMode;
        this.disablePreview = disablePreview;
        this.disableNotification = disableNotification;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="chat_id")
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="parse_mode")
    public MessageParseMode getParseMode() {
        return this.parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    public Boolean getDisablePreview() {
        return this.disablePreview;
    }

    @JsonProperty(value="disable_notification")
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    public Long getReplyTo() {
        return this.replyTo;
    }

    @JsonProperty(value="reply_markup")
    public String getReplyMarkupJson() throws JsonProcessingException {
        if (this.replyMarkup == null) {
            return null;
        }
        return TelegramUtils.getObjectMapper().writeValueAsString((Object)this.replyMarkup);
    }

    @JsonIgnore
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }
}

