/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetUpdatesPayload {
    private final long offset;
    private final Integer limit;
    private final Integer timeout;
    private final String[] allowedUpdates;

    public GetUpdatesPayload(Long offset, Integer limit, Integer timeout, String[] allowedUpdates) {
        this.offset = offset;
        if (limit != null && (limit < 1 || limit > 100)) {
            throw new IllegalArgumentException(String.format("limit should between 1 to 100 or a negative value, but got %s", limit));
        }
        this.limit = limit;
        if (timeout != null && timeout < 0) {
            throw new IllegalArgumentException("A negative timeout value does not make any sense.");
        }
        this.timeout = timeout;
        this.allowedUpdates = allowedUpdates;
    }

    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="allowed_updates")
    public String[] getAllowedUpdates() {
        return this.allowedUpdates;
    }
}

