/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.api.models.MessageParseMode;
import org.isuper.telegram.api.models.markups.ReplyMarkup;
import org.isuper.telegram.utils.TelegramUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EditMessageTextPayload {
    private final String chatId;
    private final Long messageId;
    private final String inlineMessageId;
    private final String text;
    private final MessageParseMode parseMode;
    private final Boolean disablePreview;
    private final ReplyMarkup replyMarkup;

    public EditMessageTextPayload(String chatId, Long messageId, String text, MessageParseMode parseMode, Boolean disablePreview, ReplyMarkup replyMarkup) {
        Preconditions.notEmptyString((String)chatId, (String)"Chat ID should be provided");
        this.chatId = chatId;
        Preconditions.notNull((Object)messageId, (String)"Message ID should be provided");
        this.messageId = messageId;
        this.inlineMessageId = null;
        Preconditions.notEmptyString((String)text, (String)"New text should be provided");
        this.text = text;
        this.parseMode = parseMode;
        this.disablePreview = disablePreview;
        this.replyMarkup = replyMarkup;
    }

    public EditMessageTextPayload(String inlineMessageId, String text, MessageParseMode parseMode, Boolean disablePreview, ReplyMarkup replyMarkup) {
        this.chatId = null;
        this.messageId = null;
        Preconditions.notNull((Object)inlineMessageId, (String)"Inline message ID should be provided");
        this.inlineMessageId = inlineMessageId;
        Preconditions.notEmptyString((String)text, (String)"New text should be provided");
        this.text = text;
        this.parseMode = parseMode;
        this.disablePreview = disablePreview;
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="chat_id")
    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="message_id")
    public Long getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="inline_message_id")
    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="parse_mode")
    public MessageParseMode getParseMode() {
        return this.parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    public Boolean getDisablePreview() {
        return this.disablePreview;
    }

    @JsonProperty(value="reply_markup")
    public String getReplyMarkupJson() throws JsonProcessingException {
        return TelegramUtils.getObjectMapper().writeValueAsString((Object)this.replyMarkup);
    }

    @JsonIgnore
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }
}

