/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User {
    @JsonProperty(value="id")
    public final long id;
    @JsonProperty(value="first_name")
    public final String firstName;
    @JsonProperty(value="last_name")
    public final String lastName;
    @JsonProperty(value="username")
    public final String username;

    @JsonCreator
    public User(@JsonProperty(value="id") Long id, @JsonProperty(value="first_name") String firstName, @JsonProperty(value="last_name") String lastName, @JsonProperty(value="username") String username) {
        Preconditions.notNull((Object)id, (String)"User's or bot's ID should be provided.");
        this.id = id;
        Preconditions.notNull((Object)firstName, (String)"User's or bot's first name should be provided.");
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

