/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.common.utils.Preconditions;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TelegramError {
    private final boolean ok;
    private final int errorCode;
    private final String description;

    @JsonCreator
    public TelegramError(@JsonProperty(value="ok") Boolean ok, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="description") String description) {
        Preconditions.notNull((Object)ok, (String)"Status should be provided.");
        this.ok = ok;
        Preconditions.notNull((Object)ok, (String)"Error code should be provided.");
        this.errorCode = errorCode;
        this.description = description;
    }

    public boolean isOk() {
        return this.ok;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

