/*
 * Decompiled with CFR 0.152.
 */
package org.isuper.telegram.api.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.isuper.telegram.utils.TelegramUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Location {
    @JsonProperty(value="latitude")
    public final float latitude;
    @JsonProperty(value="longitude")
    public final float longitude;

    @JsonCreator
    public Location(@JsonProperty(value="latitude") float latitude, @JsonProperty(value="longitude") float longitude) {
        if (Math.abs(latitude) > 90.0f) {
            throw new IllegalArgumentException(String.format("Invalid latitude %f", Float.valueOf(latitude)));
        }
        this.latitude = latitude;
        if (Math.abs(longitude) > 180.0f) {
            throw new IllegalArgumentException(String.format("Invalid longitude %f", Float.valueOf(longitude)));
        }
        this.longitude = longitude;
    }

    public String toJSON() {
        try {
            return TelegramUtils.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public String toString() {
        return this.toJSON();
    }
}

