/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.api.models.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Super Wayne
 *
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiResponse<T> {
	
	private final boolean ok;
	private final T result;

	/**
	 * @param ok
	 * 					The request was successful or not.
	 * @param result
	 * 					The result.
	 */
	@JsonCreator
	public ApiResponse(
			@JsonProperty("ok") boolean ok,
			@JsonProperty("result") T result
		) {
		this.ok = ok;
		this.result = result;
	}
	/**
	 * @return
	 * 			The request was successful or not.
	 */
	public boolean isOk() {
		return this.ok;
	}
	/**
	 * @return
	 * 			The result.
	 */
	public T getResult() {
		return this.result;
	}

}
