/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.api;

import java.util.List;

import org.isuper.telegram.api.models.Chat;
import org.isuper.telegram.api.models.ChatMember;
import org.isuper.telegram.api.models.Message;
import org.isuper.telegram.api.models.Update;
import org.isuper.telegram.api.models.User;
import org.isuper.telegram.api.models.http.AnswerInlineQueryPayload;
import org.isuper.telegram.api.models.http.ApiResponse;
import org.isuper.telegram.api.models.http.EditMessageCaptionPayload;
import org.isuper.telegram.api.models.http.EditMessageReplyMarkupPayload;
import org.isuper.telegram.api.models.http.EditMessageTextPayload;
import org.isuper.telegram.api.models.http.ForwardMessagePayload;
import org.isuper.telegram.api.models.http.GetUpdatesPayload;
import org.isuper.telegram.api.models.http.SendMessagePayload;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * @author Super Wayne
 *
 */
public interface TelegramBotApi {

	@POST("/bot{apiToken}/getMe")
	Call<ApiResponse<User>> getMe(@Path("apiToken") String apiToken);

	@POST("/bot{apiToken}/getUpdates")
	Call<ApiResponse<List<Update>>> getUpdates(@Path("apiToken") String apiToken, @Body GetUpdatesPayload payload);

	@POST("/bot{apiToken}/sendMessage")
	Call<ApiResponse<Message>> sendMessage(@Path("apiToken") String apiToken, @Body SendMessagePayload payload);

	@POST("/bot{apiToken}/forwardMessage")
	Call<ApiResponse<Message>> forwardMessage(@Path("apiToken") String apiToken, @Body ForwardMessagePayload payload);

	@POST("/bot{apiToken}/editMessageText")
	Call<ApiResponse<Message>> editMessageText(@Path("apiToken") String apiToken, @Body EditMessageTextPayload payload);

	@POST("/bot{apiToken}/editMessageCaption")
	Call<ApiResponse<Message>> editMessageCaption(@Path("apiToken") String apiToken, @Body EditMessageCaptionPayload payload);

	@POST("/bot{apiToken}/editMessageReplyMarkup")
	Call<ApiResponse<Message>> editMessageReplyMarkup(@Path("apiToken") String apiToken, @Body EditMessageReplyMarkupPayload payload);

	@POST("/bot{apiToken}/answerInlineQuery")
	Call<ApiResponse<Boolean>> answerInlineQuery(@Path("apiToken") String apiToken, @Body AnswerInlineQueryPayload payload);

	@FormUrlEncoded
	@POST("/bot{apiToken}/kickChatMember")
	Call<ApiResponse<Boolean>> kickChatMember(@Path("apiToken") String apiToken, @Field("chat_id") String chatId, @Field("user_id") long userId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/kickChatMember")
	Call<ApiResponse<Boolean>> kickChatMember(@Path("apiToken") String apiToken, @Field("chat_id") long chatId, @Field("user_id") long userId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/unbanChatMember")
	Call<ApiResponse<Boolean>> unbanChatMember(@Path("apiToken") String apiToken, @Field("chat_id") String chatId, @Field("user_id") long userId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/unbanChatMember")
	Call<ApiResponse<Boolean>> unbanChatMember(@Path("apiToken") String apiToken, @Field("chat_id") long chatId, @Field("user_id") long userId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChat")
	Call<ApiResponse<Chat>> getChat(@Path("apiToken") String apiToken, @Field("chat_id") String chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChat")
	Call<ApiResponse<Chat>> getChat(@Path("apiToken") String apiToken, @Field("chat_id") long chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatAdministrators")
	Call<ApiResponse<List<ChatMember>>> getChatAdministrators(@Path("apiToken") String apiToken, @Field("chat_id") String chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatAdministrators")
	Call<ApiResponse<List<ChatMember>>> getChatAdministrators(@Path("apiToken") String apiToken, @Field("chat_id") long chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatMembersCount")
	Call<ApiResponse<Integer>> getChatMembersCount(@Path("apiToken") String apiToken, @Field("chat_id") String chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatMembersCount")
	Call<ApiResponse<Integer>> getChatMembersCount(@Path("apiToken") String apiToken, @Field("chat_id") long chatId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatMember")
	Call<ApiResponse<ChatMember>> getChatMember(@Path("apiToken") String apiToken, @Field("chat_id") String chatId, @Field("user_id") long userId);

	@FormUrlEncoded
	@POST("/bot{apiToken}/getChatMember")
	Call<ApiResponse<ChatMember>> getChatMember(@Path("apiToken") String apiToken, @Field("chat_id") long chatId, @Field("user_id") long userId);

}
