/**
 * Copyright 2014-2017 Super Wayne
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.isuper.telegram.api;

import org.isuper.telegram.utils.TelegramUtils;

import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

/**
 * @author Super Wayne
 *
 */
public class TelegramApiBuilder {
	
	public static final Converter.Factory DEFAULT_CONVERTER_FACTORY = JacksonConverterFactory.create(TelegramUtils.getObjectMapper());
	public static final String BASE_URL = "https://api.telegram.org/";
	
	public TelegramApiBuilder() {
	}
	
	public TelegramBotApi build() {
		OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
        return new Retrofit.Builder()
        		.baseUrl(BASE_URL)
        		.addConverterFactory(DEFAULT_CONVERTER_FACTORY)
        		.client(clientBuilder.build())
        		.build()
        		.create(TelegramBotApi.class);
	}
	
}
