/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class LogicalPath {
    private LogicalPath() {
    }

    public static boolean isAbsolute(String path) {
        return path.startsWith("/");
    }

    public static String parentPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash <= 0) {
            return LogicalPath.isAbsolute(path) ? "/" : null;
        }
        return path.substring(0, lastSlash);
    }

    public static String objectName(String path) {
        int lastSlash = path.lastIndexOf(47);
        return lastSlash == -1 ? path : path.substring(lastSlash + 1);
    }

    public static List<String> segments(String path) {
        if ("/".equals(path)) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.add("/");
            return parts;
        }
        List<String> parts = Arrays.stream(path.split("/")).collect(Collectors.toList());
        if (LogicalPath.isAbsolute(path)) {
            parts.set(0, "/");
        }
        if (path.endsWith("/")) {
            parts.add("");
        }
        return parts;
    }
}

