/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.high_level.common.AdminTag;
import org.irods.irods4j.input_validation.Preconditions;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ModAVUMetadataInp_PI;

public class IRODSMetadata {
    public static final AdminTag asAdmin = AdminTag.instance;

    private static void doOneOffMetadataOperationOnLogicalPath(boolean asAdmin, IRODSApi.RcComm comm, OneOffMetadataOperation op, boolean isCollection, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        int ec;
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(logicalPath, "Logical path is null or empty");
        Preconditions.notNullOrEmpty(attrName, "Metadata attribute name is null or empty");
        Preconditions.notNullOrEmpty(attrValue, "Metadata attribute value is null or empty");
        attrUnits.ifPresent(v -> Preconditions.notNullOrEmpty(v, "Metadata attribute units is null or empty"));
        ModAVUMetadataInp_PI input = new ModAVUMetadataInp_PI();
        input.arg0 = op.value;
        input.arg1 = isCollection ? "-C" : "-d";
        input.arg2 = logicalPath;
        input.arg3 = attrName;
        input.arg4 = attrValue;
        input.arg5 = attrUnits.orElse("");
        input.KeyValPair_PI = new KeyValPair_PI();
        if (asAdmin) {
            input.KeyValPair_PI.ssLen = 1;
            input.KeyValPair_PI.keyWord = new ArrayList<String>();
            input.KeyValPair_PI.svalue = new ArrayList<String>();
            input.KeyValPair_PI.keyWord.add("irodsAdmin");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcModAVUMetadata(comm, input)) < 0) {
            throw new IRODSException(ec, "rcModAVUMetadata error");
        }
    }

    public static void addMetadataToCollection(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.ADD;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void addMetadataToCollection(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.ADD;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromCollection(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.REMOVE;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromCollection(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.REMOVE;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnCollection(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.SET;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnCollection(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.SET;
        boolean isCollection = true;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, true, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void addMetadataToDataObject(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.ADD;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void addMetadataToDataObject(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.ADD;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromDataObject(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.REMOVE;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromDataObject(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.REMOVE;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnDataObject(IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = false;
        OneOffMetadataOperation op = OneOffMetadataOperation.SET;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(false, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnDataObject(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        boolean asAdmin = true;
        OneOffMetadataOperation op = OneOffMetadataOperation.SET;
        boolean isCollection = false;
        IRODSMetadata.doOneOffMetadataOperationOnLogicalPath(true, comm, op, false, logicalPath, attrName, attrValue, attrUnits);
    }

    private static void doOneOffMetadataOperationOnResource(IRODSApi.RcComm comm, String resourceName, OneOffMetadataOperation op, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(resourceName, "Resource name is null or empty");
        Preconditions.notNullOrEmpty(attrName, "Metadata attribute name is null or empty");
        Preconditions.notNullOrEmpty(attrValue, "Metadata attribute value is null or empty");
        attrUnits.ifPresent(v -> Preconditions.notNullOrEmpty(v, "Metadata attribute units is null or empty"));
        ModAVUMetadataInp_PI input = new ModAVUMetadataInp_PI();
        input.arg0 = op.value;
        input.arg1 = "-R";
        input.arg2 = resourceName;
        input.arg3 = attrName;
        input.arg4 = attrValue;
        input.arg5 = attrUnits.orElse("");
        input.KeyValPair_PI = new KeyValPair_PI();
        int ec = IRODSApi.rcModAVUMetadata(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcModAVUMetadata error");
        }
    }

    public static void addMetadataToResource(IRODSApi.RcComm comm, String resourceName, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnResource(comm, resourceName, OneOffMetadataOperation.ADD, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromResource(IRODSApi.RcComm comm, String resourceName, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnResource(comm, resourceName, OneOffMetadataOperation.REMOVE, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnResource(IRODSApi.RcComm comm, String resourceName, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnResource(comm, resourceName, OneOffMetadataOperation.SET, attrName, attrValue, attrUnits);
    }

    private static void doOneOffMetadataOperationOnUserOrGroup(IRODSApi.RcComm comm, String userOrGroup, OneOffMetadataOperation op, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(userOrGroup, "User/Group name is null or empty");
        Preconditions.notNullOrEmpty(attrName, "Metadata attribute name is null or empty");
        Preconditions.notNullOrEmpty(attrValue, "Metadata attribute value is null or empty");
        attrUnits.ifPresent(v -> Preconditions.notNullOrEmpty(v, "Metadata attribute units is null or empty"));
        ModAVUMetadataInp_PI input = new ModAVUMetadataInp_PI();
        input.arg0 = op.value;
        input.arg1 = "-u";
        input.arg2 = userOrGroup;
        input.arg3 = attrName;
        input.arg4 = attrValue;
        input.arg5 = attrUnits.orElse("");
        input.KeyValPair_PI = new KeyValPair_PI();
        int ec = IRODSApi.rcModAVUMetadata(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcModAVUMetadata error");
        }
    }

    public static void addMetadataToUserOrGroup(IRODSApi.RcComm comm, String userOrGroup, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnUserOrGroup(comm, userOrGroup, OneOffMetadataOperation.ADD, attrName, attrValue, attrUnits);
    }

    public static void removeMetadataFromUserOrGroup(IRODSApi.RcComm comm, String userOrGroup, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnUserOrGroup(comm, userOrGroup, OneOffMetadataOperation.REMOVE, attrName, attrValue, attrUnits);
    }

    public static void setMetadataOnUserOrGroup(IRODSApi.RcComm comm, String userOrGroup, String attrName, String attrValue, Optional<String> attrUnits) throws IOException, IRODSException {
        IRODSMetadata.doOneOffMetadataOperationOnUserOrGroup(comm, userOrGroup, OneOffMetadataOperation.SET, attrName, attrValue, attrUnits);
    }

    private static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToLogicalPathImpl(boolean asAdmin, IRODSApi.RcComm comm, String logicalPath, String entityType, List<AtomicMetadataOperation> operations) throws IOException {
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(logicalPath, "Logical path is null or empty");
        Preconditions.greaterThanOrEqualToValue(operations.size(), 0L, "Atomic metadata operations is null or empty");
        AtomicMetadataOperationsResult errorInfo = new AtomicMetadataOperationsResult();
        HashMap<String, Object> inputStruct = new HashMap<String, Object>();
        inputStruct.put("admin_mode", asAdmin);
        inputStruct.put("entity_name", logicalPath);
        inputStruct.put("entity_type", entityType);
        inputStruct.put("operations", operations);
        String input = JsonUtil.toJsonString(inputStruct);
        Reference<String> output = new Reference<String>();
        errorInfo.errorCode = IRODSApi.rcAtomicApplyMetadataOperations(comm, input, output);
        if (errorInfo.errorCode < 0) {
            errorInfo.jsonOutput = (String)output.value;
        }
        return errorInfo;
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToCollection(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, List<AtomicMetadataOperation> operations) throws IOException {
        return IRODSMetadata.atomicApplyMetadataOperationsToLogicalPathImpl(true, comm, logicalPath, "collection", operations);
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToCollection(IRODSApi.RcComm comm, String logicalPath, List<AtomicMetadataOperation> operations) throws IOException {
        return IRODSMetadata.atomicApplyMetadataOperationsToLogicalPathImpl(false, comm, logicalPath, "collection", operations);
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToDataObject(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, List<AtomicMetadataOperation> operations) throws IOException {
        return IRODSMetadata.atomicApplyMetadataOperationsToLogicalPathImpl(true, comm, logicalPath, "data_object", operations);
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToDataObject(IRODSApi.RcComm comm, String logicalPath, List<AtomicMetadataOperation> operations) throws IOException {
        return IRODSMetadata.atomicApplyMetadataOperationsToLogicalPathImpl(false, comm, logicalPath, "data_object", operations);
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToResource(IRODSApi.RcComm comm, String resourceName, List<AtomicMetadataOperation> operations) throws IOException {
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(resourceName, "Resource name is null or empty");
        Preconditions.greaterThanOrEqualToValue(operations.size(), 0L, "Atomic metadata operations is empty");
        AtomicMetadataOperationsResult errorInfo = new AtomicMetadataOperationsResult();
        HashMap<String, Object> inputStruct = new HashMap<String, Object>();
        inputStruct.put("admin_mode", false);
        inputStruct.put("entity_name", resourceName);
        inputStruct.put("entity_type", "resource");
        inputStruct.put("operations", operations);
        String input = JsonUtil.toJsonString(inputStruct);
        Reference<String> output = new Reference<String>();
        errorInfo.errorCode = IRODSApi.rcAtomicApplyMetadataOperations(comm, input, output);
        if (errorInfo.errorCode < 0) {
            errorInfo.jsonOutput = (String)output.value;
        }
        return errorInfo;
    }

    public static AtomicMetadataOperationsResult atomicApplyMetadataOperationsToUserOrGroup(IRODSApi.RcComm comm, String userOrGroup, List<AtomicMetadataOperation> operations) throws IOException {
        Preconditions.notNull(comm, "RcComm is null");
        Preconditions.notNullOrEmpty(userOrGroup, "User/Group name is null or empty");
        Preconditions.greaterThanOrEqualToValue(operations.size(), 0L, "Atomic metadata operations is empty");
        AtomicMetadataOperationsResult errorInfo = new AtomicMetadataOperationsResult();
        HashMap<String, Object> inputStruct = new HashMap<String, Object>();
        inputStruct.put("admin_mode", false);
        inputStruct.put("entity_name", userOrGroup);
        inputStruct.put("entity_type", "user");
        inputStruct.put("operations", operations);
        String input = JsonUtil.toJsonString(inputStruct);
        Reference<String> output = new Reference<String>();
        errorInfo.errorCode = IRODSApi.rcAtomicApplyMetadataOperations(comm, input, output);
        if (errorInfo.errorCode < 0) {
            errorInfo.jsonOutput = (String)output.value;
        }
        return errorInfo;
    }

    private static enum OneOffMetadataOperation {
        ADD("add"),
        REMOVE("rm"),
        SET("set");

        String value;

        private OneOffMetadataOperation(String v) {
            this.value = v;
        }
    }

    public static final class AtomicMetadataOperationsResult {
        public int errorCode;
        public String jsonOutput;

        AtomicMetadataOperationsResult() {
        }
    }

    public static final class AtomicMetadataOperation {
        String operation;
        String attribute;
        String value;
        String units;

        public AtomicMetadataOperation(AtomicOperation op, String attrName, String attrValue) {
            Preconditions.notNull((Object)op, "Atomic operation is null");
            Preconditions.notNullOrEmpty(attrName, "Metadata attribute name is null or empty");
            Preconditions.notNullOrEmpty(attrValue, "Metadata attribute value is null or empty");
            this.operation = op.value;
            this.attribute = attrName;
            this.value = attrValue;
            this.units = "";
        }

        public AtomicMetadataOperation(AtomicOperation op, String attrName, String attrValue, String attrUnits) {
            Preconditions.notNull((Object)op, "Atomic operation is null");
            Preconditions.notNullOrEmpty(attrName, "Metadata attribute name is null or empty");
            Preconditions.notNullOrEmpty(attrValue, "Metadata attribute value is null or empty");
            Preconditions.notNullOrEmpty(attrUnits, "Metadata attribute units is null or empty");
            this.operation = op.value;
            this.attribute = attrName;
            this.value = attrValue;
            this.units = attrUnits;
        }
    }

    public static enum AtomicOperation {
        ADD("add"),
        REMOVE("remove");

        String value;

        private AtomicOperation(String v) {
            this.value = v;
        }
    }
}

