/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.FileLseekOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.OpenedDataObjInp_PI;

public class IRODSDataObjectStream
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private IRODSApi.RcComm comm;
    private int fd = -1;
    private long replicaNumber = -1L;
    private String replicaToken;

    public void open(IRODSApi.RcComm comm, String logicalPath, int openMode) throws IOException, IRODSException {
        Optional<Long> replicaNumber = Optional.empty();
        Optional<String> rootResource = Optional.empty();
        Optional<String> replicaToken = Optional.empty();
        this.openImpl(comm, logicalPath, openMode, replicaNumber, rootResource, replicaToken);
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, long replicaNumber, int openMode) throws IOException, IRODSException {
        Optional<String> rootResource = Optional.empty();
        Optional<String> replicaToken = Optional.empty();
        this.openImpl(comm, logicalPath, openMode, Optional.of(replicaNumber), rootResource, replicaToken);
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, String rootResource, int openMode) throws IOException, IRODSException {
        Optional<Long> replicaNumber = Optional.empty();
        Optional<String> replicaToken = Optional.empty();
        this.openImpl(comm, logicalPath, openMode, replicaNumber, Optional.of(rootResource), replicaToken);
    }

    public void open(IRODSApi.RcComm comm, String replicaToken, String logicalPath, long replicaNumber, int openMode) throws IOException, IRODSException {
        Optional<String> rootResource = Optional.empty();
        this.openImpl(comm, logicalPath, openMode, Optional.of(replicaNumber), rootResource, Optional.of(replicaToken));
    }

    @Override
    public void close() throws Exception {
        this.close(null);
    }

    public void close(OnCloseSuccess onCloseSuccess) throws IOException {
        int ec;
        if (-1 == this.fd) {
            return;
        }
        HashMap<String, Constable> input = new HashMap<String, Constable>();
        input.put("fd", Integer.valueOf(this.fd));
        if (null != onCloseSuccess) {
            input.put("update_size", Boolean.valueOf(onCloseSuccess.updateSize));
            input.put("update_status", Boolean.valueOf(onCloseSuccess.updateStatus));
            input.put("compute_checksum", Boolean.valueOf(onCloseSuccess.computeChecksum));
            input.put("send_notifications", Boolean.valueOf(onCloseSuccess.sendNotifications));
            input.put("preserve_replica_state_table", Boolean.valueOf(onCloseSuccess.preserveReplicaStateTable));
        }
        if ((ec = IRODSApi.rcReplicaClose(this.comm, JsonUtil.toJsonString(input))) < 0) {
            log.error("rcReplicaClose error");
        }
        this.fd = -1;
        this.replicaNumber = -1L;
        this.replicaToken = null;
    }

    public long seek(int offset, SeekDirection direction) throws IOException, IRODSException {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        OpenedDataObjInp_PI input = new OpenedDataObjInp_PI();
        input.l1descInx = this.fd;
        input.offset = offset;
        input.KeyValPair_PI = new KeyValPair_PI();
        switch (direction) {
            case BEGIN: {
                input.whence = 0;
                break;
            }
            case CURRENT: {
                input.whence = 1;
                break;
            }
            case END: {
                input.whence = 2;
            }
        }
        Reference<FileLseekOut_PI> output = new Reference<FileLseekOut_PI>();
        int ec = IRODSApi.rcDataObjLseek(this.comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjLseek error");
        }
        return ((FileLseekOut_PI)output.value).offset;
    }

    public int read(byte[] buffer, int count) throws IOException, IRODSException {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        IRODSDataObjectStream.throwIfInvalidBufferSize(buffer.length, count);
        OpenedDataObjInp_PI input = new OpenedDataObjInp_PI();
        input.l1descInx = this.fd;
        input.len = count;
        input.KeyValPair_PI = new KeyValPair_PI();
        IRODSApi.ByteArrayReference readBuffer = new IRODSApi.ByteArrayReference();
        readBuffer.data = buffer;
        int bytesRead = IRODSApi.rcDataObjRead(this.comm, input, readBuffer);
        if (bytesRead < 0) {
            throw new IRODSException(bytesRead, "rcDataObjRead error");
        }
        return bytesRead;
    }

    public int write(byte[] buffer, int count) throws IOException, IRODSException {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        IRODSDataObjectStream.throwIfInvalidBufferSize(buffer.length, count);
        OpenedDataObjInp_PI input = new OpenedDataObjInp_PI();
        input.l1descInx = this.fd;
        input.len = count;
        input.KeyValPair_PI = new KeyValPair_PI();
        int bytesWritten = IRODSApi.rcDataObjWrite(this.comm, input, buffer);
        if (bytesWritten < 0) {
            throw new IRODSException(bytesWritten, "rcDataObjWrite error");
        }
        return bytesWritten;
    }

    public boolean isOpen() {
        return this.fd >= 3;
    }

    public int getNativeHandle() {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        return this.fd;
    }

    public long getReplicaNumber() {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        return this.replicaNumber;
    }

    public String getReplicaToken() {
        IRODSDataObjectStream.throwIfInvalidL1Descriptor(this.fd);
        return this.replicaToken;
    }

    private void openImpl(IRODSApi.RcComm comm, String logicalPath, int openMode, Optional<Long> replicaNumber, Optional<String> rootResource, Optional<String> replicaToken) throws IOException, IRODSException {
        if (null == logicalPath || logicalPath.isEmpty()) {
            throw new IllegalArgumentException("Logical path is null or empty");
        }
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.dataSize = -1L;
        input.createMode = 384;
        input.openFlags = openMode;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        replicaNumber.ifPresent(v -> {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("replNum");
            input.KeyValPair_PI.svalue.add(v.toString());
            this.replicaNumber = v;
        });
        rootResource.ifPresent(v -> {
            if (replicaNumber.isPresent()) {
                throw new IllegalStateException("Replica number and root resource cannot be set at the same time");
            }
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("rescName");
            input.KeyValPair_PI.svalue.add((String)v);
        });
        replicaToken.ifPresent(v -> {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("replicaToken");
            input.KeyValPair_PI.svalue.add((String)v);
            this.replicaToken = v;
        });
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcReplicaOpen(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcReplicaOpen error");
        }
        this.fd = ec;
        this.comm = comm;
        ObjectMapper jm = JsonUtil.getJsonMapper();
        JsonNode l1descInfo = jm.readTree((String)output.value);
        JsonNode doi = l1descInfo.get("data_object_info");
        if (-1L == this.replicaNumber) {
            this.replicaNumber = doi.get("replica_number").asLong();
        }
        if (null == this.replicaToken) {
            this.replicaToken = l1descInfo.get("replica_token").asText();
        }
    }

    private static void throwIfInvalidL1Descriptor(int fd) {
        if (-1 == fd) {
            throw new IllegalStateException("Stream not open");
        }
    }

    private static void throwIfInvalidBufferSize(int bufferSize, int count) {
        if (count < 0 || count > bufferSize) {
            throw new IndexOutOfBoundsException("Byte count is less than 0 or exceeds buffer size");
        }
    }

    public static class OnCloseSuccess {
        public boolean updateSize = true;
        public boolean updateStatus = true;
        public boolean computeChecksum;
        public boolean sendNotifications = true;
        public boolean preserveReplicaStateTable;
    }

    public static enum SeekDirection {
        BEGIN,
        CURRENT,
        END;

    }
}

