/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.vfs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.high_level.administration.IRODSUsers;
import org.irods.irods4j.high_level.catalog.IRODSQuery;
import org.irods.irods4j.high_level.common.AdminTag;
import org.irods.irods4j.high_level.vfs.CollectionEntry;
import org.irods.irods4j.high_level.vfs.EntityPermission;
import org.irods.irods4j.high_level.vfs.IRODSCollectionIterator;
import org.irods.irods4j.high_level.vfs.IRODSFilesystemException;
import org.irods.irods4j.high_level.vfs.LogicalPath;
import org.irods.irods4j.high_level.vfs.ObjectStatus;
import org.irods.irods4j.high_level.vfs.Permission;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.CollInpNew_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.CollOprStat_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjCopyInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ModAccessControlInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RodsObjStat_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.TransferStat_PI;

public class IRODSFilesystem {
    private static final Logger log = LogManager.getLogger();
    public static final AdminTag asAdmin = AdminTag.instance;

    public static void copy(IRODSApi.RcComm comm, String from, String to, int copyOptions) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(from, "From/Source path is null or empty");
        IRODSFilesystem.throwIfNullOrEmpty(to, "To/Destination path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(from);
        IRODSFilesystem.throwIfPathLengthExceedsLimit(to);
        ObjectStatus fromStatus = IRODSFilesystem.status(comm, from);
        if (!IRODSFilesystem.exists(fromStatus)) {
            throw new IRODSFilesystemException(-358000, from, "From/Source path does not exist");
        }
        ObjectStatus toStatus = IRODSFilesystem.status(comm, to);
        if (IRODSFilesystem.exists(toStatus) && IRODSFilesystem.equivalent(comm, from, to)) {
            throw new IRODSFilesystemException(-339000, to, "Paths identify the same object");
        }
        if (IRODSFilesystem.isOther(fromStatus)) {
            throw new IRODSFilesystemException(-836000, from, "Object type is not supported");
        }
        if (IRODSFilesystem.isOther(toStatus)) {
            throw new IRODSFilesystemException(-836000, to, "Object type is not supported");
        }
        if (IRODSFilesystem.isCollection(fromStatus) && IRODSFilesystem.isDataObject(toStatus)) {
            throw new IRODSFilesystemException(-130000, from, to, "Incompatible paths");
        }
        if (IRODSFilesystem.isDataObject(fromStatus)) {
            if (16 == (0x10 & copyOptions)) {
                return;
            }
            if (IRODSFilesystem.isCollection(toStatus)) {
                String objectName = LogicalPath.objectName(from);
                String toPath = String.join((CharSequence)"/", to, objectName);
                IRODSFilesystem.copyDataObject(comm, from, toPath, copyOptions);
                return;
            }
            IRODSFilesystem.copyDataObject(comm, from, to, copyOptions);
        } else if (IRODSFilesystem.isCollection(fromStatus) && (8 == (8 & copyOptions) || 0 == copyOptions)) {
            if (!IRODSFilesystem.exists(toStatus) && !IRODSFilesystem.createCollection(comm, to, from)) {
                throw new IRODSFilesystemException(-1098000, to, "Cannot create collection");
            }
            for (CollectionEntry e : new IRODSCollectionIterator(comm, from)) {
                String objectName = LogicalPath.objectName(e.path);
                String toPath = String.join((CharSequence)"/", to, objectName);
                IRODSFilesystem.copy(comm, e.path, toPath, copyOptions | 0x20);
            }
        }
    }

    public static void copy(IRODSApi.RcComm comm, String from, String to) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.copy(comm, from, to, 0);
    }

    public static boolean copyDataObject(IRODSApi.RcComm comm, String from, String to, int copyOptions) throws IRODSFilesystemException, IOException, IRODSException {
        Reference<TransferStat_PI> output;
        int ec;
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(from, "From/Source path is null or empty");
        IRODSFilesystem.throwIfNullOrEmpty(to, "To/Destination path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(from);
        IRODSFilesystem.throwIfPathLengthExceedsLimit(to);
        if (!IRODSFilesystem.isDataObject(comm, from)) {
            throw new IRODSFilesystemException(-1105000, "From/Source path does not identify a data object", from);
        }
        DataObjCopyInp_PI input = new DataObjCopyInp_PI();
        input.DataObjInp_PI = new DataObjInp_PI[]{new DataObjInp_PI(), new DataObjInp_PI()};
        DataObjInp_PI srcInput = input.DataObjInp_PI[0];
        srcInput.objPath = from;
        srcInput.KeyValPair_PI = new KeyValPair_PI();
        DataObjInp_PI dstInput = input.DataObjInp_PI[1];
        dstInput.objPath = to;
        dstInput.KeyValPair_PI = new KeyValPair_PI();
        ObjectStatus s = IRODSFilesystem.status(comm, to);
        if (IRODSFilesystem.exists(s)) {
            if (IRODSFilesystem.equivalent(comm, from, to)) {
                throw new IRODSFilesystemException(-339000, "Paths identify the same data object", from, to);
            }
            if (!IRODSFilesystem.isDataObject(s)) {
                throw new IRODSFilesystemException(-1105000, "To/Destination path does not identify a data object", to);
            }
            if (1 == copyOptions) {
                return false;
            }
            if (2 == copyOptions) {
                ++dstInput.KeyValPair_PI.ssLen;
                dstInput.KeyValPair_PI.keyWord = new ArrayList<String>();
                dstInput.KeyValPair_PI.svalue = new ArrayList<String>();
                dstInput.KeyValPair_PI.keyWord.add("forceFlag");
                dstInput.KeyValPair_PI.svalue.add("");
            } else if (4 == copyOptions) {
                if (IRODSFilesystem.lastWriteTime(comm, from) <= IRODSFilesystem.lastWriteTime(comm, to)) {
                    return false;
                }
                ++dstInput.KeyValPair_PI.ssLen;
                dstInput.KeyValPair_PI.keyWord = new ArrayList<String>();
                dstInput.KeyValPair_PI.svalue = new ArrayList<String>();
                dstInput.KeyValPair_PI.keyWord.add("forceFlag");
                dstInput.KeyValPair_PI.svalue.add("");
            }
        }
        if ((ec = IRODSApi.rcDataObjCopy(comm, input, output = new Reference<TransferStat_PI>())) < 0) {
            throw new IRODSFilesystemException(ec, "rcDataObjCopy error", from, to);
        }
        return true;
    }

    public static boolean copyDataObject(IRODSApi.RcComm comm, String from, String to) throws IRODSFilesystemException, IOException, IRODSException {
        return IRODSFilesystem.copyDataObject(comm, from, to, 0);
    }

    public static boolean createCollection(IRODSApi.RcComm comm, String path) throws IOException, IRODSFilesystemException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        CollInpNew_PI input = new CollInpNew_PI();
        input.collName = path;
        input.KeyValPair_PI = new KeyValPair_PI();
        int ec = IRODSApi.rcCollCreate(comm, input);
        if (ec < 0) {
            throw new IRODSFilesystemException(ec, "rcCollCreate error", path);
        }
        return true;
    }

    public static boolean createCollection(IRODSApi.RcComm comm, String path, String existingPath) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfNullOrEmpty(existingPath, "Existing path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        IRODSFilesystem.throwIfPathLengthExceedsLimit(existingPath);
        ObjectStatus s = IRODSFilesystem.status(comm, existingPath);
        if (!IRODSFilesystem.isCollection(s)) {
            throw new IRODSFilesystemException(-1105000, "Existing path does not identify a collection", existingPath);
        }
        IRODSFilesystem.createCollection(comm, path);
        StringBuilder usernameSb = new StringBuilder();
        for (EntityPermission perm : s.getPermissions()) {
            usernameSb.delete(0, usernameSb.length());
            usernameSb.append(perm.name).append('#').append(perm.zone);
            IRODSFilesystem.permissions(comm, path, usernameSb.toString(), perm.prms);
        }
        return true;
    }

    public static boolean createCollections(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        if (IRODSFilesystem.exists(comm, path)) {
            return false;
        }
        CollInpNew_PI input = new CollInpNew_PI();
        input.collName = path;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.ssLen = 1;
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        input.KeyValPair_PI.keyWord.add("recursiveOpr");
        input.KeyValPair_PI.svalue.add("");
        return IRODSApi.rcCollCreate(comm, input) == 0;
    }

    public static boolean exists(ObjectStatus status) {
        return IRODSFilesystem.statusKnown(status) && status.getType() != ObjectStatus.ObjectType.NOT_FOUND;
    }

    public static boolean exists(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        return IRODSFilesystem.exists(IRODSFilesystem.status(comm, path));
    }

    public static boolean isCollectionRegistered(IRODSApi.RcComm comm, String path) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        String query = String.format("select COLL_ID where COLL_NAME = '%s'", LogicalPath.parentPath(path));
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        return zone.isPresent() ? !IRODSQuery.executeGenQuery2(comm, zone.get(), query).isEmpty() : !IRODSQuery.executeGenQuery2(comm, query).isEmpty();
    }

    public static boolean isDataObjectRegistered(IRODSApi.RcComm comm, String path) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        String query = String.format("select DATA_ID where COLL_NAME = '%s' and DATA_NAME = '%s'", LogicalPath.parentPath(path), LogicalPath.objectName(path));
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        return zone.isPresent() ? !IRODSQuery.executeGenQuery2(comm, zone.get(), query).isEmpty() : !IRODSQuery.executeGenQuery2(comm, query).isEmpty();
    }

    public static boolean equivalent(IRODSApi.RcComm comm, String path1, String path2) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path1, "Path 1 is null or empty");
        IRODSFilesystem.throwIfNullOrEmpty(path1, "Path 2 is null or empty");
        StatInfo p1Info = IRODSFilesystem.stat(comm, path1);
        if (p1Info.error < 0) {
            throw new IRODSFilesystemException(p1Info.error, "Stat error", path1);
        }
        if (0 == p1Info.type) {
            throw new IRODSFilesystemException(-358000, "Path 1 does not exist", path1);
        }
        StatInfo p2Info = IRODSFilesystem.stat(comm, path1);
        if (p2Info.error < 0) {
            throw new IRODSFilesystemException(p2Info.error, "Stat error", path2);
        }
        if (0 == p2Info.type) {
            throw new IRODSFilesystemException(-358000, "Path 2 does not exist", path2);
        }
        return p1Info.id == p2Info.id;
    }

    public static long dataObjectSize(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        List<List<String>> rows;
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        if (!IRODSFilesystem.isDataObject(comm, path)) {
            throw new IRODSFilesystemException(-171000, "Path does not identify a data object", path);
        }
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        String query = String.format("select DATA_SIZE, DATA_MODIFY_TIME where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_STATUS = '1'", LogicalPath.parentPath(path), LogicalPath.objectName(path));
        List<List<String>> list = rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
        if (rows.isEmpty()) {
            throw new IRODSFilesystemException(-166000, "No good replica available", path);
        }
        long latestMtime = 0L;
        long size = 0L;
        for (List<String> row : rows) {
            long currentMtime = Long.parseLong(row.get(1));
            if (currentMtime <= latestMtime) continue;
            latestMtime = currentMtime;
            size = Long.parseLong(row.get(0));
        }
        return size;
    }

    public static boolean isCollection(ObjectStatus status) {
        return status.getType() == ObjectStatus.ObjectType.COLLECTION;
    }

    public static boolean isCollection(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        return IRODSFilesystem.isCollection(IRODSFilesystem.status(comm, path));
    }

    public static boolean isDataObject(ObjectStatus status) {
        return status.getType() == ObjectStatus.ObjectType.DATA_OBJECT;
    }

    public static boolean isDataObject(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        return IRODSFilesystem.isDataObject(IRODSFilesystem.status(comm, path));
    }

    public static boolean isOther(ObjectStatus status) {
        return status.getType() == ObjectStatus.ObjectType.UNKNOWN;
    }

    public static boolean isOther(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        return IRODSFilesystem.isOther(IRODSFilesystem.status(comm, path));
    }

    public static boolean isSpecialCollection(IRODSApi.RcComm comm, String path) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        String query = String.format("select COLL_TYPE, COLL_INFO1, COLL_INFO2 where COLL_NAME = '%s'", path);
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        List<List<String>> rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
        Iterator<List<String>> iterator = rows.iterator();
        if (iterator.hasNext()) {
            List<String> row = iterator.next();
            return !row.get(0).isEmpty() && (!row.get(1).isEmpty() || !row.get(2).isEmpty());
        }
        return false;
    }

    public static boolean isEmpty(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        ObjectStatus s = IRODSFilesystem.status(comm, path);
        if (!IRODSFilesystem.isCollection(s)) {
            throw new IRODSFilesystemException(-836000, "Path does not identify a collection", path);
        }
        return IRODSFilesystem.isCollectionEmpty(comm, path);
    }

    public static long lastWriteTime(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        ObjectStatus s = IRODSFilesystem.status(comm, path);
        String query = null;
        if (IRODSFilesystem.isDataObject(s)) {
            query = String.format("select max(DATA_MODIFY_TIME) where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_STATUS = '1'", LogicalPath.parentPath(path), LogicalPath.objectName(path));
        } else if (IRODSFilesystem.isCollection(s)) {
            query = String.format("select COLL_MODIFY_TIME where COLL_NAME = '%s'", path);
        } else {
            throw new IRODSFilesystemException(-1105000, "Path does not identify a data object or collection", path);
        }
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        List<List<String>> rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
        Iterator<List<String>> iterator = rows.iterator();
        if (iterator.hasNext()) {
            List<String> row = iterator.next();
            return Long.parseLong(row.get(0));
        }
        throw new IRODSFilesystemException(-808000, "Modify time unavailable", path);
    }

    public static void lastWriteTime(IRODSApi.RcComm comm, String path, long newModifyTime) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        if (!IRODSFilesystem.isCollection(comm, path)) {
            throw new IRODSFilesystemException(-170000, "Path does not identify a collection", path);
        }
        CollInpNew_PI input = new CollInpNew_PI();
        input.collName = path;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.ssLen = 1;
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        input.KeyValPair_PI.keyWord.add("collectionMtime");
        input.KeyValPair_PI.svalue.add(String.format("%011d", newModifyTime));
        int ec = IRODSApi.rcModColl(comm, input);
        if (ec < 0) {
            throw new IRODSFilesystemException(ec, "rcModColl error", path);
        }
    }

    public static boolean remove(IRODSApi.RcComm comm, String path, RemoveOptions removeOptions) throws IOException, IRODSException {
        ExtendedRemoveOptions options = new ExtendedRemoveOptions();
        options.noTrash = RemoveOptions.NO_TRASH == removeOptions;
        options.recursive = false;
        return IRODSFilesystem.removeImpl(comm, path, options);
    }

    public static boolean remove(IRODSApi.RcComm comm, String path) throws IOException, IRODSException {
        return IRODSFilesystem.remove(comm, path, RemoveOptions.NONE);
    }

    public static void removeAll(IRODSApi.RcComm comm, String path, RemoveOptions removeOptions) throws IOException, IRODSException {
        ExtendedRemoveOptions options = new ExtendedRemoveOptions();
        options.noTrash = RemoveOptions.NO_TRASH == removeOptions;
        options.recursive = true;
        IRODSFilesystem.removeImpl(comm, path, options);
    }

    public static void removeAll(IRODSApi.RcComm comm, String path) throws IOException, IRODSException {
        IRODSFilesystem.removeAll(comm, path, RemoveOptions.NONE);
    }

    public static void permissions(IRODSApi.RcComm comm, String path, String userOrGroup, Permission prms) throws IRODSFilesystemException, IOException {
        boolean addAdminFlag = false;
        IRODSFilesystem.setPermissions(false, comm, path, userOrGroup, prms);
    }

    public static void permissions(AdminTag adminTag, IRODSApi.RcComm comm, String path, String userOrGroup, Permission prms) throws IRODSFilesystemException, IOException {
        boolean addAdminFlag = true;
        IRODSFilesystem.setPermissions(true, comm, path, userOrGroup, prms);
    }

    public static void enableInheritance(IRODSApi.RcComm comm, String path, boolean enable) throws IOException, IRODSException {
        boolean addAdminFlag = false;
        IRODSFilesystem.setInheritance(false, comm, path, enable);
    }

    public static void enableInheritance(AdminTag adminTag, IRODSApi.RcComm comm, String path, boolean enable) throws IOException, IRODSException {
        boolean addAdminFlag = true;
        IRODSFilesystem.setInheritance(true, comm, path, enable);
    }

    public static void rename(IRODSApi.RcComm comm, String oldPath, String newPath) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(oldPath, "Old Path is null or empty");
        IRODSFilesystem.throwIfNullOrEmpty(newPath, "New Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(oldPath);
        IRODSFilesystem.throwIfPathLengthExceedsLimit(newPath);
        DataObjCopyInp_PI input = new DataObjCopyInp_PI();
        input.DataObjInp_PI = new DataObjInp_PI[]{new DataObjInp_PI(), new DataObjInp_PI()};
        input.DataObjInp_PI[0].objPath = oldPath;
        input.DataObjInp_PI[0].KeyValPair_PI = new KeyValPair_PI();
        input.DataObjInp_PI[1].objPath = newPath;
        input.DataObjInp_PI[1].KeyValPair_PI = new KeyValPair_PI();
        int ec = IRODSApi.rcDataObjRename(comm, input);
        if (ec < 0) {
            throw new IRODSFilesystemException(ec, "rcDataObjRename error", oldPath, newPath);
        }
    }

    public static ObjectStatus status(IRODSApi.RcComm comm, String path) throws IOException, IRODSException, IRODSFilesystemException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        StatInfo s = IRODSFilesystem.stat(comm, path);
        if (s.error < 0) {
            throw new IRODSFilesystemException(s.error, "Stat error");
        }
        ObjectStatus status = new ObjectStatus();
        status.setPermissions(s.prms);
        status.setInheritance(s.inheritance);
        switch (s.type) {
            case 1: {
                status.setType(ObjectStatus.ObjectType.DATA_OBJECT);
                break;
            }
            case 2: {
                status.setType(ObjectStatus.ObjectType.COLLECTION);
                break;
            }
            case 0: {
                status.setType(ObjectStatus.ObjectType.NOT_FOUND);
                break;
            }
            default: {
                status.setType(ObjectStatus.ObjectType.NONE);
            }
        }
        return status;
    }

    public static boolean statusKnown(ObjectStatus status) {
        return status.getType() != ObjectStatus.ObjectType.NONE;
    }

    public static String dataObjectChecksum(IRODSApi.RcComm comm, String path) throws IRODSFilesystemException, NumberFormatException, IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Logical path is null or empty");
        if (!IRODSFilesystem.isDataObject(comm, path)) {
            throw new IRODSFilesystemException(-130000, "Logical path does not point to a data object", path);
        }
        String query = String.format("select DATA_CHECKSUM, DATA_MODIFY_TIME where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_STATUS = '1'", LogicalPath.parentPath(path), LogicalPath.objectName(path));
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        long latestMtime = 0L;
        String checksum = "";
        List<List<String>> rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
        for (List<String> row : rows) {
            long curMtime = Long.parseLong(row.get(1));
            if (curMtime <= latestMtime) continue;
            latestMtime = curMtime;
            checksum = row.get(0);
        }
        return checksum;
    }

    private static Optional<String> extractZoneFromPath(String path) {
        if (!LogicalPath.isAbsolute(path)) {
            throw new IllegalArgumentException("Path is not absolute");
        }
        List<String> segments = LogicalPath.segments(path);
        if (segments.size() <= 1) {
            return Optional.empty();
        }
        return Optional.of(segments.get(1));
    }

    private static void throwIfNull(Object object, String message) {
        if (null == object) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void throwIfNullOrEmpty(String s, String message) {
        if (null == s || s.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void throwIfPathLengthExceedsLimit(String path) throws IRODSFilesystemException {
        if (path.getBytes(StandardCharsets.UTF_8).length > 1087) {
            throw new IRODSFilesystemException(-346000, "Path exceeds maximum length", path);
        }
    }

    private static Permission toPermissionEnum(String perm) {
        switch (perm) {
            case "null": {
                return Permission.NULL;
            }
            case "read_metadata": {
                return Permission.READ_METADATA;
            }
            case "read_object": {
                return Permission.READ_OBJECT;
            }
            case "read object": {
                return Permission.READ_OBJECT;
            }
            case "read": {
                return Permission.READ_OBJECT;
            }
            case "create_metadata": {
                return Permission.CREATE_METADATA;
            }
            case "modify_metadata": {
                return Permission.MODIFY_METADATA;
            }
            case "delete_metadata": {
                return Permission.DELETE_METADATA;
            }
            case "create_object": {
                return Permission.CREATE_OBJECT;
            }
            case "modify_object": {
                return Permission.MODIFY_OBJECT;
            }
            case "modify object": {
                return Permission.MODIFY_OBJECT;
            }
            case "write": {
                return Permission.MODIFY_OBJECT;
            }
            case "delete_object": {
                return Permission.DELETE_OBJECT;
            }
            case "own": {
                return Permission.OWN;
            }
        }
        throw new IllegalArgumentException("Unknown Permission string: " + perm);
    }

    private static List<EntityPermission> toEntityPermissionsList(IRODSApi.RcComm comm, String path, int objectType) throws IOException, IRODSException {
        Optional<String> zone;
        ArrayList<EntityPermission> perms = new ArrayList<EntityPermission>();
        if (1 == objectType) {
            zone = IRODSFilesystem.extractZoneFromPath(path);
            HashMap<String, String> map = new HashMap<String, String>();
            String query = String.format("select DATA_ACCESS_USER_ID, DATA_ACCESS_PERM_NAME where COLL_NAME = '%s' and DATA_NAME = '%s'", LogicalPath.parentPath(path), LogicalPath.objectName(path));
            List<List<String>> rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
            for (List<String> row2 : rows) {
                map.put(row2.get(0), row2.get(1));
            }
            if (map.isEmpty()) {
                return perms;
            }
            query = String.format("select USER_ID, USER_NAME, USER_ZONE, USER_TYPE where USER_ID in ('%s')", String.join((CharSequence)"', '", map.keySet()));
            log.debug("Query for data object permissions = [{}]", (Object)query);
            rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
            for (List<String> row2 : rows) {
                EntityPermission ep = new EntityPermission();
                ep.name = row2.get(1);
                ep.zone = row2.get(2);
                ep.prms = IRODSFilesystem.toPermissionEnum((String)map.get(row2.get(0)));
                ep.type = IRODSUsers.toUserType(row2.get(3));
                perms.add(ep);
            }
        }
        if (2 == objectType) {
            zone = IRODSFilesystem.extractZoneFromPath(path);
            List<String> bindArgs = Arrays.asList(path);
            if (zone.isPresent()) {
                IRODSQuery.executeSpecificQuery(comm, zone.get(), "ShowCollAcls", bindArgs, row -> {
                    EntityPermission ep = new EntityPermission();
                    ep.name = (String)row.get(0);
                    ep.zone = (String)row.get(1);
                    ep.prms = IRODSFilesystem.toPermissionEnum((String)row.get(2));
                    ep.type = IRODSUsers.toUserType((String)row.get(3));
                    perms.add(ep);
                    return true;
                });
            } else {
                IRODSQuery.executeSpecificQuery(comm, "ShowCollAcls", bindArgs, row -> {
                    EntityPermission ep = new EntityPermission();
                    ep.name = (String)row.get(0);
                    ep.zone = (String)row.get(1);
                    ep.prms = IRODSFilesystem.toPermissionEnum((String)row.get(2));
                    ep.type = IRODSUsers.toUserType((String)row.get(3));
                    perms.add(ep);
                    return true;
                });
            }
        }
        return perms;
    }

    private static boolean getInheritance(IRODSApi.RcComm comm, String path, int objectType) throws IOException, IRODSException {
        if (2 != objectType) {
            return false;
        }
        Optional<String> zone = IRODSFilesystem.extractZoneFromPath(path);
        String query = String.format("select COLL_INHERITANCE where COLL_NAME = '%s'", path);
        List<List<String>> rows = zone.isPresent() ? IRODSQuery.executeGenQuery2(comm, zone.get(), query) : IRODSQuery.executeGenQuery2(comm, query);
        Iterator<List<String>> iterator = rows.iterator();
        if (iterator.hasNext()) {
            List<String> row = iterator.next();
            return "1".equals(row.get(0));
        }
        return false;
    }

    private static StatInfo stat(IRODSApi.RcComm comm, String logicalPath) throws IOException, IRODSException {
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        Reference<RodsObjStat_PI> output = new Reference<RodsObjStat_PI>();
        StatInfo statInfo = new StatInfo();
        statInfo.error = IRODSApi.rcObjStat(comm, input, output);
        if (statInfo.error >= 0) {
            statInfo.id = Integer.parseInt(((RodsObjStat_PI)output.value).dataId);
            statInfo.ctime = Long.parseLong(((RodsObjStat_PI)output.value).createTime);
            statInfo.mtime = Long.parseLong(((RodsObjStat_PI)output.value).modifyTime);
            statInfo.size = ((RodsObjStat_PI)output.value).objSize;
            statInfo.type = ((RodsObjStat_PI)output.value).objType;
            statInfo.mode = ((RodsObjStat_PI)output.value).dataMode;
            statInfo.inheritance = IRODSFilesystem.getInheritance(comm, logicalPath, statInfo.type);
            statInfo.prms = IRODSFilesystem.toEntityPermissionsList(comm, logicalPath, statInfo.type);
        } else if (-310000 == statInfo.error) {
            statInfo.error = 0;
            statInfo.type = 0;
        }
        return statInfo;
    }

    private static void setInheritance(boolean addAdminFlag, IRODSApi.RcComm comm, String logicalPath, boolean enableInheritance) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(logicalPath);
        if (!IRODSFilesystem.isCollection(comm, logicalPath)) {
            throw new IRODSFilesystemException(-170000, "Path does not identify a collection", logicalPath);
        }
        ModAccessControlInp_PI input = new ModAccessControlInp_PI();
        input.userName = "";
        input.zone = "";
        input.path = logicalPath;
        StringBuilder access = new StringBuilder();
        if (addAdminFlag) {
            access.append("admin:");
        }
        access.append(enableInheritance ? "inherit" : "noinherit");
        input.accessLevel = access.toString();
        int ec = IRODSApi.rcModAccessControl(comm, input);
        if (ec < 0) {
            throw new IRODSFilesystemException(ec, "rcModAccessControl error", logicalPath);
        }
    }

    private static void setPermissions(boolean addAdminFlag, IRODSApi.RcComm comm, String logicalPath, String userOrGroup, Permission perm) throws IOException, IRODSFilesystemException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(logicalPath);
        String username = userOrGroup;
        String zone = "";
        String[] usernameParts = userOrGroup.split("#");
        if (2 == usernameParts.length) {
            username = usernameParts[0];
            zone = usernameParts[1];
        }
        ModAccessControlInp_PI input = new ModAccessControlInp_PI();
        input.userName = username;
        input.zone = zone;
        input.path = logicalPath;
        StringBuilder access = new StringBuilder();
        if (addAdminFlag) {
            access.append("admin:");
        }
        switch (perm) {
            case NULL: {
                access.append("null");
                break;
            }
            case READ_METADATA: {
                access.append("read_metadata");
                break;
            }
            case READ_OBJECT: {
                access.append("read");
                break;
            }
            case CREATE_METADATA: {
                access.append("create_metadata");
                break;
            }
            case MODIFY_METADATA: {
                access.append("modify_metadata");
                break;
            }
            case DELETE_METADATA: {
                access.append("delete_metadata");
                break;
            }
            case CREATE_OBJECT: {
                access.append("create_object");
                break;
            }
            case MODIFY_OBJECT: {
                access.append("write");
                break;
            }
            case DELETE_OBJECT: {
                access.append("delete_object");
                break;
            }
            case OWN: {
                access.append("own");
            }
        }
        input.accessLevel = access.toString();
        int ec = IRODSApi.rcModAccessControl(comm, input);
        if (ec < 0) {
            throw new IRODSFilesystemException(ec, "rcModAccessControl error", logicalPath);
        }
    }

    private static boolean removeImpl(IRODSApi.RcComm comm, String path, ExtendedRemoveOptions removeOptions) throws IOException, IRODSException {
        IRODSFilesystem.throwIfNull(comm, "RcComm is null");
        IRODSFilesystem.throwIfNullOrEmpty(path, "Path is null or empty");
        IRODSFilesystem.throwIfPathLengthExceedsLimit(path);
        ObjectStatus s = IRODSFilesystem.status(comm, path);
        if (!IRODSFilesystem.exists(s)) {
            return false;
        }
        if (IRODSFilesystem.isDataObject(s)) {
            DataObjInp_PI input = new DataObjInp_PI();
            input.objPath = path;
            input.oprType = removeOptions.unregister ? 26 : 0;
            input.KeyValPair_PI = new KeyValPair_PI();
            if (removeOptions.noTrash) {
                input.KeyValPair_PI.ssLen = 1;
                input.KeyValPair_PI.keyWord = new ArrayList<String>();
                input.KeyValPair_PI.svalue = new ArrayList<String>();
                input.KeyValPair_PI.keyWord.add("forceFlag");
                input.KeyValPair_PI.svalue.add("");
            }
            return IRODSApi.rcDataObjUnlink(comm, input) == 0;
        }
        if (IRODSFilesystem.isCollection(s)) {
            Reference<CollOprStat_PI> output;
            CollInpNew_PI input = new CollInpNew_PI();
            input.collName = path;
            input.KeyValPair_PI = new KeyValPair_PI();
            input.KeyValPair_PI.keyWord = new ArrayList<String>();
            input.KeyValPair_PI.svalue = new ArrayList<String>();
            if (removeOptions.noTrash) {
                ++input.KeyValPair_PI.ssLen;
                input.KeyValPair_PI.keyWord.add("forceFlag");
                input.KeyValPair_PI.svalue.add("");
            }
            if (removeOptions.recursive) {
                ++input.KeyValPair_PI.ssLen;
                input.KeyValPair_PI.keyWord.add("recursiveOpr");
                input.KeyValPair_PI.svalue.add("");
            }
            return IRODSApi.rcRmColl(comm, input, output = new Reference<CollOprStat_PI>()) == 0;
        }
        throw new IRODSFilesystemException(-836000, "Object type is not supported", path);
    }

    private static boolean isCollectionEmpty(IRODSApi.RcComm comm, String path) throws IRODSException, IOException {
        return new IRODSCollectionIterator(comm, path).iterator().hasNext();
    }

    public static final class CopyOptions {
        public static final int NONE = 0;
        public static final int SKIP_EXISTING = 1;
        public static final int OVERWRITE_EXISTING = 2;
        public static final int UPDATE_EXISTING = 4;
        public static final int RECURSIVE = 8;
        public static final int COLLECTIONS_ONLY = 16;
        private static final int IN_RECURSIVE_COPY = 32;
    }

    private static final class StatInfo {
        int error;
        long size;
        int type;
        int mode;
        long id;
        long ctime;
        long mtime;
        List<EntityPermission> prms;
        boolean inheritance;

        private StatInfo() {
        }
    }

    private static final class ExtendedRemoveOptions {
        public boolean noTrash = false;
        public boolean verbose = false;
        public boolean progress = false;
        public boolean recursive = false;
        public boolean unregister = false;

        private ExtendedRemoveOptions() {
        }
    }

    public static enum RemoveOptions {
        NONE,
        NO_TRASH;

    }
}

