/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.high_level.io.IRODSDataObjectStream;
import org.irods.irods4j.input_validation.Preconditions;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class IRODSDataObjectOutputStream
extends OutputStream {
    private static final Logger log = LogManager.getLogger();
    private IRODSDataObjectStream in = new IRODSDataObjectStream();
    private byte[] buffer;
    private int position;

    public IRODSDataObjectOutputStream() {
        this.buffer = new byte[65536];
    }

    public IRODSDataObjectOutputStream(int bufferSize) {
        Preconditions.greaterThanOrEqualToValue(bufferSize, 1L, "Buffer size is less than 1");
        this.buffer = new byte[bufferSize];
    }

    public IRODSDataObjectOutputStream(IRODSApi.RcComm comm, String logicalPath, boolean truncate, boolean append) throws IOException, IRODSException {
        this.open(comm, logicalPath, truncate, append);
    }

    public IRODSDataObjectOutputStream(IRODSApi.RcComm comm, String logicalPath, String rootResourceName, boolean truncate, boolean append) throws IOException, IRODSException {
        this.open(comm, logicalPath, rootResourceName, truncate, append);
    }

    public IRODSDataObjectOutputStream(IRODSApi.RcComm comm, String logicalPath, long replicaNumber, boolean truncate, boolean append) throws IOException, IRODSException {
        this.open(comm, logicalPath, replicaNumber, truncate, append);
    }

    public IRODSDataObjectOutputStream(IRODSApi.RcComm comm, String replicaToken, String logicalPath, long replicaNumber, boolean truncate, boolean append) throws IOException, IRODSException {
        this.open(comm, replicaToken, logicalPath, replicaNumber, truncate, append);
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, boolean truncate, boolean append) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        int mode = truncate ? 512 : 0;
        this.in.open(comm, logicalPath, 0x41 | (mode |= append ? 1024 : 0));
        this.position = 0;
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, String rootResourceName, boolean truncate, boolean append) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        int mode = truncate ? 512 : 0;
        this.in.open(comm, logicalPath, rootResourceName, 0x41 | (mode |= append ? 1024 : 0));
        this.position = 0;
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, long replicaNumber, boolean truncate, boolean append) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        int mode = truncate ? 512 : 0;
        this.in.open(comm, logicalPath, replicaNumber, 1 | (mode |= append ? 1024 : 0));
        this.position = 0;
    }

    public void open(IRODSApi.RcComm comm, String replicaToken, String logicalPath, long replicaNumber, boolean truncate, boolean append) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        int mode = truncate ? 512 : 0;
        this.in.open(comm, replicaToken, logicalPath, replicaNumber, 1 | (mode |= append ? 1024 : 0));
        this.position = 0;
    }

    public boolean isOpen() {
        return this.in.isOpen();
    }

    public int getNativeHandle() {
        return this.in.getNativeHandle();
    }

    public long getReplicaNumber() {
        return this.in.getReplicaNumber();
    }

    public String getReplicaToken() {
        return this.in.getReplicaToken();
    }

    public void seek(int offset, IRODSDataObjectStream.SeekDirection direction) throws IOException, IRODSException {
        this.flushBuffer();
        this.in.seek(offset, direction);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.length == this.position) {
            try {
                this.flushBuffer();
            }
            catch (IRODSException e) {
                throw new IOException(e);
            }
        }
        this.buffer[this.position++] = (byte)b;
    }

    public void flushBuffer() throws IOException, IRODSException {
        if (0 == this.position) {
            return;
        }
        this.in.write(this.buffer, this.position);
        this.position = 0;
    }

    public void close(IRODSDataObjectStream.OnCloseSuccess closeInstructions) {
        try {
            this.flushBuffer();
        }
        catch (IOException | IRODSException e) {
            log.error(e.getMessage());
        }
        try {
            this.in.close(closeInstructions);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    private void initInternalBufferIfNecessary() {
        if (null == this.buffer) {
            this.buffer = new byte[65536];
        }
    }
}

