/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.high_level.io.IRODSDataObjectStream;
import org.irods.irods4j.input_validation.Preconditions;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class IRODSDataObjectInputStream
extends InputStream {
    private static final Logger log = LogManager.getLogger();
    private IRODSDataObjectStream in = new IRODSDataObjectStream();
    private byte[] buffer;
    private int bytesInBuffer;
    private int position;

    public IRODSDataObjectInputStream() {
        this.buffer = new byte[65536];
        this.bytesInBuffer = this.buffer.length;
    }

    public IRODSDataObjectInputStream(int bufferSize) {
        Preconditions.greaterThanOrEqualToValue(bufferSize, 1L, "Buffer size is less than 1");
        this.buffer = new byte[bufferSize];
        this.bytesInBuffer = bufferSize;
    }

    public IRODSDataObjectInputStream(IRODSApi.RcComm comm, String logicalPath) throws IOException, IRODSException {
        this.open(comm, logicalPath);
    }

    public IRODSDataObjectInputStream(IRODSApi.RcComm comm, String logicalPath, String rootResourceName) throws IOException, IRODSException {
        this.open(comm, logicalPath, rootResourceName);
    }

    public IRODSDataObjectInputStream(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        this.open(comm, logicalPath, replicaNumber);
    }

    public void open(IRODSApi.RcComm comm, String logicalPath) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        this.in.open(comm, logicalPath, 0);
        this.position = this.bytesInBuffer;
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, String rootResourceName) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        this.in.open(comm, logicalPath, rootResourceName, 0);
        this.position = this.bytesInBuffer;
    }

    public void open(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        this.initInternalBufferIfNecessary();
        this.in.open(comm, logicalPath, replicaNumber, 0);
        this.position = this.bytesInBuffer;
    }

    public boolean isOpen() {
        return this.in.isOpen();
    }

    public int getNativeHandle() {
        return this.in.getNativeHandle();
    }

    public long getReplicaNumber() {
        return this.in.getReplicaNumber();
    }

    public String getReplicaToken() {
        return this.in.getReplicaToken();
    }

    public void seek(int offset, IRODSDataObjectStream.SeekDirection direction) throws IOException, IRODSException {
        this.position = this.bytesInBuffer;
        this.in.seek(offset, direction);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesInBuffer == this.position) {
            if (this.bytesInBuffer < this.buffer.length) {
                return -1;
            }
            try {
                int bytesRead = this.in.read(this.buffer, this.buffer.length);
                if (0 == bytesRead) {
                    return -1;
                }
                this.bytesInBuffer = bytesRead;
                this.position = 0;
            }
            catch (IOException | IRODSException e) {
                throw new IOException(e);
            }
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void initInternalBufferIfNecessary() {
        if (null != this.buffer) {
            return;
        }
        this.buffer = new byte[65536];
        this.bytesInBuffer = this.buffer.length;
    }
}

