/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import java.io.Console;
import java.io.IOException;
import java.util.Arrays;
import java.util.Scanner;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthManager;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.authentication.NativeAuthPlugin;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class PamInteractiveAuthPlugin
extends AuthPlugin {
    private static final Logger log = LogManager.getLogger();
    private static final String PERFORM_RUNNING = "running";
    private static final String PERFORM_READY = "ready";
    private static final String PERFORM_WAITING = "waiting";
    private static final String PERFORM_WAITING_PW = "waiting_pw";
    private static final String PERFORM_RESPONSE = "response";
    private static final String PERFORM_NEXT = "next";
    private static final String PERFORM_ERROR = "error";
    private static final String PERFORM_TIMEOUT = "timeout";
    private static final String PERFORM_AUTHENTICATED = "authenticated";
    private static final String PERFORM_NOT_AUTHENTICATED = "not_authenticated";
    private static final String PERFORM_NATIVE_AUTH = "perform_native_auth";
    private boolean requireSecureConnection = true;
    private final Function<String, String> getInputHandler;
    private final Function<String, String> getSensitiveInputHandler;

    public PamInteractiveAuthPlugin(boolean requireSecureConnection) {
        this(requireSecureConnection, PamInteractiveAuthPlugin::getInputFromClientStdin, PamInteractiveAuthPlugin::getPasswordFromClientStdin);
    }

    public PamInteractiveAuthPlugin(boolean requireSecureConnection, Function<String, String> getInputHandler, Function<String, String> getSensitiveInputHandler) {
        if (null == getInputHandler) {
            throw new IllegalArgumentException("getInputHandler callback is null");
        }
        if (null == getSensitiveInputHandler) {
            throw new IllegalArgumentException("getSensitiveInputHandler callback is null");
        }
        this.requireSecureConnection = requireSecureConnection;
        this.getInputHandler = getInputHandler;
        this.getSensitiveInputHandler = getSensitiveInputHandler;
        this.addOperation("auth_client_auth_request", this::clientRequest);
        this.addOperation("auth_client_auth_response", this::clientResponse);
        this.addOperation(PERFORM_RUNNING, this::stepGeneric);
        this.addOperation(PERFORM_READY, this::stepGeneric);
        this.addOperation(PERFORM_NEXT, this::stepClientNext);
        this.addOperation(PERFORM_RESPONSE, this::stepGeneric);
        this.addOperation(PERFORM_WAITING, this::stepWaiting);
        this.addOperation(PERFORM_WAITING_PW, this::stepWaitingPw);
        this.addOperation(PERFORM_ERROR, this::stepError);
        this.addOperation(PERFORM_TIMEOUT, this::stepTimeout);
        this.addOperation(PERFORM_AUTHENTICATED, this::stepAuthenticated);
        this.addOperation(PERFORM_NOT_AUTHENTICATED, this::stepNotAuthenticated);
        this.addOperation(PERFORM_NATIVE_AUTH, this::performNativeAuth);
    }

    @Override
    public String getName() {
        return "pam_interactive";
    }

    @Override
    public JsonNode authClientStart(IRODSApi.RcComm comm, JsonNode context) {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "auth_client_auth_request");
        resp.put("pdirty", false);
        resp.set("pstate", (JsonNode)JsonUtil.getJsonMapper().createObjectNode());
        resp.put("user_name", comm.proxyUsername);
        resp.put("zone_name", comm.proxyUserZone);
        resp.remove("password");
        return resp;
    }

    private JsonNode clientRequest(IRODSApi.RcComm comm, JsonNode context) throws IOException, IRODSException {
        ObjectNode req = (ObjectNode)context.deepCopy();
        req.put("next_operation", "auth_agent_auth_request");
        if (this.requireSecureConnection) {
            if (!comm.secure) {
                throw new IllegalStateException("SSL/TLS is required for PAM authentication");
            }
        } else if (!comm.secure) {
            log.warn("Using insecure channel for authentication. Password will be visible on the network.");
        }
        ObjectNode resp = (ObjectNode)this.request(comm, (JsonNode)req);
        resp.put("next_operation", "auth_client_auth_response");
        return resp;
    }

    private JsonNode clientResponse(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException {
        if (!context.has("user_name")) {
            throw new IllegalStateException("Missing property: user_name");
        }
        if (!context.has("zone_name")) {
            throw new IllegalStateException("Missing property: zone_name");
        }
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "auth_agent_auth_response");
        return this.request(rcComm, (JsonNode)resp);
    }

    private JsonNode stepClientNext(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException, JsonPatchException {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        JsonNode prompt = resp.get("msg").get("prompt");
        if (prompt.isTextual()) {
            System.out.println(prompt.asText());
        }
        PamInteractiveAuthPlugin.patchState((JsonNode)resp);
        resp.put("next_operation", "auth_agent_auth_response");
        return this.request(rcComm, (JsonNode)resp);
    }

    private JsonNode stepWaiting(IRODSApi.RcComm rcComm, JsonNode context) throws Exception {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        if (PamInteractiveAuthPlugin.retrieveEntry((JsonNode)resp)) {
            resp.put("next_operation", "auth_agent_auth_response");
            PamInteractiveAuthPlugin.patchState((JsonNode)resp);
            return this.request(rcComm, (JsonNode)resp);
        }
        String prompt = PamInteractiveAuthPlugin.getStringValue(resp.get("msg"), "prompt", "");
        String defaultValue = PamInteractiveAuthPlugin.getDefaultValue((JsonNode)resp);
        String input = this.getInputHandler.apply(prompt);
        if ((input = input.replaceAll(" ", "")).isEmpty()) {
            resp.put("resp", defaultValue);
        } else {
            resp.put("resp", input);
        }
        resp.put("next_operation", "auth_agent_auth_response");
        PamInteractiveAuthPlugin.patchState((JsonNode)resp);
        return this.request(rcComm, (JsonNode)resp);
    }

    private JsonNode stepWaitingPw(IRODSApi.RcComm rcComm, JsonNode context) throws Exception {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        if (PamInteractiveAuthPlugin.retrieveEntry((JsonNode)resp)) {
            resp.put("next_operation", "auth_agent_auth_response");
            PamInteractiveAuthPlugin.patchState((JsonNode)resp);
            return this.request(rcComm, (JsonNode)resp);
        }
        String prompt = PamInteractiveAuthPlugin.getStringValue(resp.get("msg"), "prompt", "");
        String defaultValue = PamInteractiveAuthPlugin.getDefaultValue((JsonNode)resp);
        String pw = this.getSensitiveInputHandler.apply(prompt);
        if (pw.isEmpty()) {
            resp.put("resp", defaultValue);
        } else {
            resp.put("resp", pw);
        }
        PamInteractiveAuthPlugin.patchState((JsonNode)resp);
        resp.put("next_operation", "auth_agent_auth_response");
        return this.request(rcComm, (JsonNode)resp);
    }

    private JsonNode stepError(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException {
        System.out.println(PERFORM_ERROR);
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "authentication_flow_complete");
        rcComm.loggedIn = false;
        return resp;
    }

    private JsonNode stepTimeout(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException {
        System.out.println(PERFORM_TIMEOUT);
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "authentication_flow_complete");
        rcComm.loggedIn = false;
        return resp;
    }

    private JsonNode stepAuthenticated(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", PERFORM_NATIVE_AUTH);
        return resp;
    }

    private JsonNode stepNotAuthenticated(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "authentication_flow_complete");
        rcComm.loggedIn = false;
        return resp;
    }

    private JsonNode stepGeneric(IRODSApi.RcComm rcComm, JsonNode context) throws IRODSException, IOException, JsonPatchException {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        PamInteractiveAuthPlugin.patchState((JsonNode)resp);
        resp.put("next_operation", "auth_agent_auth_response");
        return this.request(rcComm, (JsonNode)resp);
    }

    private JsonNode performNativeAuth(IRODSApi.RcComm comm, JsonNode context) throws Exception {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.remove("a_pw");
        ObjectNode input = JsonUtil.getJsonMapper().createObjectNode();
        input.put("password", resp.get("request_result").asText());
        AuthManager.authenticateClient(comm, new NativeAuthPlugin(), (JsonNode)input);
        resp.put("next_operation", "authentication_flow_complete");
        comm.loggedIn = true;
        return resp;
    }

    private static void patchState(JsonNode state) throws IOException, JsonPatchException {
        if (!state.has("patch")) {
            return;
        }
        ObjectNode patch = (ObjectNode)state.get("patch").deepCopy();
        patch.forEach(node -> {
            String opStr;
            JsonNode op = node.get("op");
            String string = opStr = null != op ? op.asText("") : "";
            if (("add".equals(opStr) || "replace".equals(opStr)) && !node.has("value")) {
                String value = PamInteractiveAuthPlugin.getStringValue(state, "resp", "");
                ((ObjectNode)node).put("value", value);
            }
        });
        ObjectNode node2 = (ObjectNode)state;
        JsonPatch jsonPatch = JsonPatch.fromJson((JsonNode)patch);
        node2.set("pstate", jsonPatch.apply(node2.get("pstate")));
        node2.put("pdirty", true);
        ((ObjectNode)node2.get("msg")).remove("patch");
    }

    private static String getDefaultValue(JsonNode request) {
        JsonNode pstate;
        String defaultPath = PamInteractiveAuthPlugin.getStringValue(request.get("msg"), "default_path", "");
        if (!defaultPath.isEmpty() && null != (pstate = request.get("pstate"))) {
            return pstate.at(defaultPath).asText("");
        }
        return "";
    }

    private static boolean retrieveEntry(JsonNode request) {
        JsonNode msg = request.get("msg");
        if (null != msg && msg.has("retrieve")) {
            JsonNode pstate;
            JsonNode retrPath = msg.get("retrieve");
            if (null != retrPath && !(pstate = request.get("pstate").at(retrPath.asText())).isMissingNode()) {
                ((ObjectNode)request).put("resp", pstate.asText());
                return true;
            }
            ((ObjectNode)request).put("resp", "");
            return true;
        }
        return false;
    }

    private static String getStringValue(JsonNode node, String key, String defaultValue) {
        if (null == node) {
            return defaultValue;
        }
        JsonNode tmp = node.get(key);
        return null != tmp ? tmp.asText(defaultValue) : defaultValue;
    }

    private static String getInputFromClientStdin(String prompt) {
        Scanner scanner = new Scanner(System.in);
        return scanner.nextLine();
    }

    private static String getPasswordFromClientStdin(String prompt) {
        Console console = System.console();
        if (null == console) {
            throw new IllegalStateException("No console available. Cannot disable echo.");
        }
        char[] passwdChars = console.readPassword();
        String passwd = new String(passwdChars);
        Arrays.fill(passwdChars, ' ');
        System.out.println();
        return passwd;
    }
}

