/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.low_level.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthManager;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.common.XmlUtil;
import org.irods.irods4j.low_level.network.Network;
import org.irods.irods4j.low_level.protocol.packing_instructions.BinBytesBuf_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.BytesBuf_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.CS_NEG_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.CollEnt_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.CollInpNew_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.CollOprStat_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjCopyInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjInfo_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DelayRuleLockInput_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DelayRuleUnlockInput_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.DelayServerMigrationInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ExecMyRuleInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.FileLseekOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GenQueryInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GenQueryOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GeneralAdminInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.Genquery2Input_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GridConfigurationInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GridConfigurationOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.INT_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.IRODS_STR_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MiscSvrInfo_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ModAVUMetadataInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ModAccessControlInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ModDataObjMeta_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsParamArray_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsgHeader_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.OpenedDataObjInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ProcStatInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RErrMsg_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RError_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RULE_EXEC_DEL_INP_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RULE_EXEC_MOD_INP_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RegReplica_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RodsObjStat_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SSLEndInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SSLStartInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.STR_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SpecificQueryInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.StartupPack_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SwitchUserInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.TicketAdminInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.TransferStat_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.UnregDataObj_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.UserAdminInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.Version_PI;

public class IRODSApi {
    public static final Logger log = LogManager.getLogger();
    private static String appName = "irods4j";

    public static void setApplicationName(String name) {
        if (null == name || name.isEmpty()) {
            throw new IllegalArgumentException("Application name is null or empty");
        }
        if (!"irods4j".equals(appName)) {
            throw new RuntimeException("setApplicationName() invoked more than once");
        }
        appName = name;
    }

    private static void sendApiRequest(OutputStream out, int apiNumber) throws IOException {
        MsgHeader_PI mh = new MsgHeader_PI();
        mh.type = "RODS_API_REQ";
        mh.intInfo = apiNumber;
        Network.write(out, mh);
        out.flush();
    }

    private static void sendApiRequest(OutputStream out, int apiNumber, Object data) throws IOException {
        byte[] msgbody = XmlUtil.toXmlString(data).getBytes(StandardCharsets.UTF_8);
        MsgHeader_PI mh = new MsgHeader_PI();
        mh.type = "RODS_API_REQ";
        mh.intInfo = apiNumber;
        mh.msgLen = msgbody.length;
        Network.write(out, mh);
        Network.writeBytes(out, msgbody);
        out.flush();
    }

    private static void sendApiRequest(OutputStream out, int apiNumber, Object data, byte[] bytes, int byteCount) throws IOException {
        byte[] msgbody = XmlUtil.toXmlString(data).getBytes(StandardCharsets.UTF_8);
        MsgHeader_PI mh = new MsgHeader_PI();
        mh.type = "RODS_API_REQ";
        mh.intInfo = apiNumber;
        mh.msgLen = msgbody.length;
        mh.bsLen = byteCount;
        Network.write(out, mh);
        Network.writeBytes(out, msgbody);
        Network.writeBytes(out, bytes, byteCount);
        out.flush();
    }

    private static <T> int receiveServerResponse(RcComm comm, Class<T> targetClass, Reference<T> output, ByteArrayReference bsBuffer) throws IOException {
        MsgHeader_PI mh = Network.readMsgHeader_PI(comm.sin);
        if (mh.msgLen > 0 && null != targetClass) {
            output.value = Network.readObject(comm.sin, mh.msgLen, targetClass);
        }
        if (mh.errorLen > 0) {
            comm.rError = Network.readObject(comm.sin, mh.errorLen, RError_PI.class);
        }
        if (mh.bsLen > 0 && null != bsBuffer) {
            Network.readBytes(comm.sin, bsBuffer.data, mh.bsLen);
        }
        return mh.intInfo;
    }

    public static RcComm rcConnect(String host, int port, String clientUsername, String clientUserZone, Optional<String> proxyUsername, Optional<String> proxyUserZone, Optional<ConnectionOptions> options, Optional<RErrMsg_PI> errorInfo) throws Exception {
        if (null == host || host.isEmpty()) {
            throw new IllegalArgumentException("Host is null or empty");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("Port is less than or equal to 0");
        }
        if (null == clientUsername || clientUsername.isEmpty()) {
            throw new IllegalArgumentException("Client username is null or empty");
        }
        if (null == clientUserZone || clientUserZone.isEmpty()) {
            throw new IllegalArgumentException("Client zone is null or empty");
        }
        ConnectionOptions connOptions = options.orElse(new ConnectionOptions());
        RcComm comm = new RcComm();
        comm.socket = comm.plainSocket = new Socket();
        comm.socket.setKeepAlive(connOptions.enableTcpKeepAlive);
        comm.socket.setTcpNoDelay(connOptions.enableTcpNoDelay);
        if (connOptions.tcpSendBufferSize > 0) {
            log.debug("Old socket send buffer size = {}", (Object)comm.socket.getSendBufferSize());
            comm.socket.setSendBufferSize(connOptions.tcpSendBufferSize);
            log.debug("New socket send buffer size = {}", (Object)comm.socket.getSendBufferSize());
        } else {
            log.debug("Socket send buffer size = {}", (Object)comm.socket.getSendBufferSize());
        }
        if (connOptions.tcpReceiveBufferSize > 0) {
            log.debug("Old socket receive buffer size = {}", (Object)comm.socket.getReceiveBufferSize());
            comm.socket.setReceiveBufferSize(connOptions.tcpReceiveBufferSize);
            log.debug("New socket receive buffer size = {}", (Object)comm.socket.getReceiveBufferSize());
        } else {
            log.debug("Socket receive buffer size = {}", (Object)comm.socket.getReceiveBufferSize());
        }
        if (connOptions.applySocketPerformancePreferences) {
            comm.socket.setPerformancePreferences(connOptions.ppConnectionTime, connOptions.ppLatency, connOptions.ppBandwidth);
        }
        comm.socket.connect(new InetSocketAddress(host, port));
        try {
            comm.sin = new BufferedInputStream(comm.socket.getInputStream());
            comm.sout = new BufferedOutputStream(comm.socket.getOutputStream());
            StartupPack_PI sp = new StartupPack_PI();
            sp.clientUser = comm.clientUsername = clientUsername;
            sp.clientRcatZone = comm.clientUserZone = clientUserZone;
            sp.proxyUser = comm.proxyUsername = proxyUsername.orElse(clientUsername);
            sp.proxyRcatZone = comm.proxyUserZone = proxyUserZone.orElse(clientUserZone);
            sp.option = appName + "request_server_negotiation";
            byte[] msgbody = XmlUtil.toXmlString(sp).getBytes(StandardCharsets.UTF_8);
            MsgHeader_PI hdr = new MsgHeader_PI();
            hdr.type = "RODS_CONNECT";
            hdr.msgLen = msgbody.length;
            Network.write(comm.sout, hdr);
            Network.writeBytes(comm.sout, msgbody);
            comm.sout.flush();
            MsgHeader_PI mh = Network.readMsgHeader_PI(comm.sin);
            log.debug("Received MsgHeader_PI: {}", (Object)XmlUtil.toXmlString(mh));
            if (mh.intInfo < 0) {
                if (errorInfo.isPresent()) {
                    errorInfo.get().status = mh.intInfo;
                    errorInfo.get().msg = "StartupPack error";
                }
                comm.socket.close();
                return null;
            }
            CS_NEG_PI csneg = Network.readObject(comm.sin, mh.msgLen, CS_NEG_PI.class);
            log.debug("Received CS_NEG_PI: {}", (Object)XmlUtil.toXmlString(csneg));
            if (1 != csneg.status) {
                log.error("Client-Server negotiation error: CS_NEG_STATUS={}", (Object)csneg.status);
                if (errorInfo.isPresent()) {
                    errorInfo.get().status = csneg.status;
                    errorInfo.get().msg = "Client-server negotiation error";
                }
                comm.socket.close();
                return null;
            }
            csneg = IRODSApi.clientServerNegotiation(comm, connOptions.clientServerNegotiation, csneg.result);
            msgbody = XmlUtil.toXmlString(csneg).getBytes(StandardCharsets.UTF_8);
            hdr.type = "RODS_CS_NEG_T";
            hdr.msgLen = msgbody.length;
            Network.write(comm.sout, hdr);
            Network.writeBytes(comm.sout, msgbody);
            comm.sout.flush();
            mh = Network.readMsgHeader_PI(comm.sin);
            log.debug("Received MsgHeader_PI: {}", (Object)XmlUtil.toXmlString(mh));
            if (mh.intInfo < 0) {
                if (errorInfo.isPresent()) {
                    errorInfo.get().status = mh.intInfo;
                    errorInfo.get().msg = "Client-Server negotiation error";
                }
                comm.socket.close();
                return null;
            }
            Version_PI vers = Network.readObject(comm.sin, mh.msgLen, Version_PI.class);
            log.debug("Received Version_PI: {}", (Object)XmlUtil.toXmlString(vers));
            comm.apiVersion = vers.apiVersion;
            comm.relVersion = vers.relVersion;
            comm.status = vers.status;
            comm.cookie = vers.cookie;
            comm.hashAlgorithm = connOptions.hashAlgorithm;
            IRODSApi.enableTLS(comm, connOptions);
        }
        catch (Exception e) {
            log.error("Authentication error: {}", (Object)e.getMessage());
            if (errorInfo.isPresent()) {
                errorInfo.get().status = -167000;
                errorInfo.get().msg = "Unexpected error";
            }
            comm.socket.close();
            return null;
        }
        return comm;
    }

    private static CS_NEG_PI clientServerNegotiation(RcComm comm, String clientNeg, String serverNeg) {
        CS_NEG_PI csneg = new CS_NEG_PI();
        csneg.status = 1;
        if ("CS_NEG_REQUIRE".equals(clientNeg)) {
            if ("CS_NEG_REQUIRE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_SSL;";
                comm.usingTLS = true;
            } else if ("CS_NEG_DONT_CARE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_SSL;";
                comm.usingTLS = true;
            } else if ("CS_NEG_REFUSE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_FAILURE;";
            }
        } else if ("CS_NEG_DONT_CARE".equals(clientNeg)) {
            if ("CS_NEG_REQUIRE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_SSL;";
                comm.usingTLS = true;
            } else if ("CS_NEG_DONT_CARE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_SSL;";
                comm.usingTLS = true;
            } else if ("CS_NEG_REFUSE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_TCP;";
            }
        } else if ("CS_NEG_REFUSE".equals(clientNeg)) {
            if ("CS_NEG_REQUIRE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_FAILURE;";
            } else if ("CS_NEG_DONT_CARE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_TCP;";
            } else if ("CS_NEG_REFUSE".equals(serverNeg)) {
                csneg.result = "cs_neg_result_kw=CS_NEG_USE_TCP;";
            }
        } else {
            csneg.status = 0;
            csneg.result = "cs_neg_result_kw=CS_NEG_FAILURE;";
        }
        return csneg;
    }

    private static void enableTLS(RcComm comm, ConnectionOptions options) throws Exception {
        if (comm.secure) {
            log.debug("SSL/TLS is already in use.");
            return;
        }
        if (!comm.usingTLS) {
            log.debug("Continuing without SSL/TLS.");
            return;
        }
        if (null != options.sslTruststore) {
            log.debug("Loading Truststore.");
            KeyStore trustStore = KeyStore.getInstance("JKS");
            if (null != options.sslTruststorePassword) {
                try (FileInputStream fis = new FileInputStream(options.sslTruststore);){
                    trustStore.load(fis, options.sslTruststorePassword.toCharArray());
                }
            }
            log.debug("Initializing Truststore.");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            log.debug("Initializing SSL context.");
            SSLContext sslContext = null;
            if (null == options.sslProtocol) {
                sslContext = SSLContext.getDefault();
            } else {
                sslContext = SSLContext.getInstance(options.sslProtocol);
                sslContext.init(null, tmf.getTrustManagers(), null);
            }
            log.debug("Securing socket communication.");
            SSLSocketFactory factory = sslContext.getSocketFactory();
            String host = comm.socket.getInetAddress().getHostAddress();
            int port = comm.socket.getPort();
            boolean autoCloseUnderlyingSocket = true;
            comm.sslSocket = (SSLSocket)factory.createSocket(comm.socket, host, port, autoCloseUnderlyingSocket);
            for (String p : comm.sslSocket.getSupportedProtocols()) {
                log.debug("Supported TLS protocol: {}", (Object)p);
            }
            for (String p : comm.sslSocket.getEnabledProtocols()) {
                log.debug("Enabled TLS protocol: {}", (Object)p);
            }
            comm.sslSocket.startHandshake();
            log.debug("Connection secured!");
        } else {
            log.debug("Securing socket communication.");
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            String host = comm.socket.getInetAddress().getHostAddress();
            int port = comm.socket.getPort();
            boolean autoCloseUnderlyingSocket = true;
            comm.sslSocket = (SSLSocket)factory.createSocket(comm.socket, host, port, autoCloseUnderlyingSocket);
            comm.sslSocket.startHandshake();
            log.debug("Connection secured!");
        }
        MsgHeader_PI mh = new MsgHeader_PI();
        mh.type = options.encryptionAlgorithm;
        mh.msgLen = options.encryptionKeySize;
        mh.errorLen = options.encryptionSaltSize;
        mh.bsLen = options.encryptionNumHashRounds;
        BufferedOutputStream sout = new BufferedOutputStream(comm.sslSocket.getOutputStream());
        Network.write(sout, mh);
        byte[] key = new byte[options.encryptionKeySize];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(key);
        BytesBuf_PI bbuf = new BytesBuf_PI();
        bbuf.buflen = key.length;
        bbuf.buf = key;
        byte[] msgbody = XmlUtil.toXmlString(bbuf).getBytes(StandardCharsets.UTF_8);
        mh.type = "SHARED_SECRET";
        mh.msgLen = msgbody.length;
        mh.errorLen = 0;
        mh.bsLen = 0;
        mh.intInfo = 0;
        Network.write(sout, mh);
        Network.writeBytes(sout, msgbody);
        sout.flush();
        comm.socket = comm.sslSocket;
        comm.sin = new BufferedInputStream(comm.sslSocket.getInputStream());
        comm.sout = sout;
        comm.secure = true;
    }

    private static int rcSslStart(RcComm comm) throws IOException {
        SSLStartInp_PI input = new SSLStartInp_PI();
        input.arg0 = null;
        IRODSApi.sendApiRequest(comm.sout, 1100, input);
        MsgHeader_PI mh = Network.readMsgHeader_PI(comm.sin);
        log.debug("Received MsgHeader_PI: {}", (Object)XmlUtil.toXmlString(mh));
        return mh.intInfo;
    }

    private static int rcSslEnd(RcComm comm) throws IOException {
        SSLEndInp_PI input = new SSLEndInp_PI();
        IRODSApi.sendApiRequest(comm.sout, 1101, input);
        MsgHeader_PI mh = Network.readMsgHeader_PI(comm.sin);
        log.debug("Received MsgHeader_PI: {}", (Object)XmlUtil.toXmlString(mh));
        return mh.intInfo;
    }

    public static void rcDisconnect(RcComm comm) throws IOException {
        MsgHeader_PI hdr = new MsgHeader_PI();
        hdr.type = "RODS_DISCONNECT";
        Network.write(comm.sout, hdr);
        comm.sout.flush();
        if (comm.secure) {
            comm.sslSocket.close();
        } else {
            comm.socket.close();
        }
    }

    public static void rcAuthenticateClient(RcComm comm, AuthPlugin authPlugin, String password) throws Exception {
        ObjectNode input = JsonUtil.getJsonMapper().createObjectNode();
        input.put("password", password);
        input.put("a_ttl", "0");
        AuthManager.authenticateClient(comm, authPlugin, (JsonNode)input);
    }

    public static int rcObjStat(RcComm comm, DataObjInp_PI input, Reference<RodsObjStat_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 633, input);
        return IRODSApi.receiveServerResponse(comm, RodsObjStat_PI.class, output, null);
    }

    public static int rcGenQuery(RcComm comm, GenQueryInp_PI input, Reference<GenQueryOut_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 702, input);
        return IRODSApi.receiveServerResponse(comm, GenQueryOut_PI.class, output, null);
    }

    public static int rcGenQuery2(RcComm comm, Genquery2Input_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 10221, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static int rcReplicaOpen(RcComm comm, DataObjInp_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20003, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcReplicaTruncate(RcComm comm, DataObjInp_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 802, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static int rcDataObjLseek(RcComm comm, OpenedDataObjInp_PI input, Reference<FileLseekOut_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 674, input);
        return IRODSApi.receiveServerResponse(comm, FileLseekOut_PI.class, output, null);
    }

    public static int rcDataObjRead(RcComm comm, OpenedDataObjInp_PI input, ByteArrayReference byteArray) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 675, input);
        return IRODSApi.receiveServerResponse(comm, null, null, byteArray);
    }

    public static int rcDataObjWrite(RcComm comm, OpenedDataObjInp_PI input, byte[] buffer) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 676, input, buffer, input.len);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcReplicaClose(RcComm comm, String closeOptions) throws IOException {
        BinBytesBuf_PI input = new BinBytesBuf_PI();
        input.buf = closeOptions;
        input.buflen = closeOptions.getBytes(StandardCharsets.UTF_8).length;
        IRODSApi.sendApiRequest(comm.sout, 20004, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcAtomicApplyMetadataOperations(RcComm comm, String input, Reference<String> output) throws IOException {
        BinBytesBuf_PI bbbuf = new BinBytesBuf_PI();
        bbbuf.buf = input;
        bbbuf.buflen = input.getBytes(StandardCharsets.UTF_8).length;
        IRODSApi.sendApiRequest(comm.sout, 20002, bbbuf);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcAtomicApplyAclOperations(RcComm comm, String input, Reference<String> output) throws IOException {
        BinBytesBuf_PI bbbuf = new BinBytesBuf_PI();
        bbbuf.buf = input;
        bbbuf.buflen = input.getBytes(StandardCharsets.UTF_8).length;
        IRODSApi.sendApiRequest(comm.sout, 20005, bbbuf);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcTouch(RcComm comm, String input) throws IOException {
        BinBytesBuf_PI bbbuf = new BinBytesBuf_PI();
        bbbuf.buf = input;
        bbbuf.buflen = input.getBytes(StandardCharsets.UTF_8).length;
        IRODSApi.sendApiRequest(comm.sout, 20007, bbbuf);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcGetGridConfigurationValue(RcComm comm, GridConfigurationInp_PI input, Reference<GridConfigurationOut_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20009, input);
        return IRODSApi.receiveServerResponse(comm, GridConfigurationOut_PI.class, output, null);
    }

    public static int rcSetGridConfigurationValue(RcComm comm, GridConfigurationInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20010, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcSetDelayServerMigrationInfo(RcComm comm, DelayServerMigrationInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20011, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcGetDelayRuleInfo(RcComm comm, String input, Reference<String> output) throws IOException {
        STR_PI strPI = new STR_PI();
        strPI.myStr = input;
        IRODSApi.sendApiRequest(comm.sout, 20013, strPI);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcGetFileDescriptorInfo(RcComm comm, String input, Reference<String> output) throws IOException {
        BinBytesBuf_PI bbbuf = new BinBytesBuf_PI();
        bbbuf.buf = input;
        bbbuf.buflen = input.getBytes(StandardCharsets.UTF_8).length;
        IRODSApi.sendApiRequest(comm.sout, 20000, bbbuf);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcSwitchUser(RcComm comm, SwitchUserInp_PI input) throws IOException {
        if (null == input.username || input.username.isEmpty()) {
            throw new IllegalArgumentException("Username is null or empty");
        }
        if (null == input.zone || input.zone.isEmpty()) {
            throw new IllegalArgumentException("Zone is null or empty");
        }
        if (comm.clientUsername.equals(input.username) && comm.clientUserZone.equals(input.zone)) {
            return 0;
        }
        IRODSApi.sendApiRequest(comm.sout, 20012, input);
        int ec = IRODSApi.receiveServerResponse(comm, null, null, null);
        if (0 == ec) {
            comm.clientUsername = input.username;
            comm.clientUserZone = input.zone;
            if (null != input.KeyValPair_PI && input.KeyValPair_PI.ssLen > 0 && input.KeyValPair_PI.keyWord.contains("switch_proxy_user")) {
                comm.proxyUsername = input.username;
                comm.proxyUserZone = input.zone;
            }
        }
        return ec;
    }

    public static int rcCheckAuthCredentials(RcComm comm, DataObjInp_PI input, Reference<Integer> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 800, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, INT_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((INT_PI)outputPI.value).myInt;
        }
        return ec;
    }

    public static int rcRegisterPhysicalPath(RcComm comm, DataObjInp_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20008, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, BinBytesBuf_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((BinBytesBuf_PI)outputPI.value).buf;
        }
        return ec;
    }

    public static int rcModAVUMetadata(RcComm comm, ModAVUMetadataInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 706, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcModAccessControl(RcComm comm, ModAccessControlInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 707, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcModDataObjMeta(RcComm comm, ModDataObjMeta_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 622, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDataObjectModifyInfo(RcComm comm, ModDataObjMeta_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 20001, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDataObjRename(RcComm comm, DataObjCopyInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 627, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDataObjCopy(RcComm comm, DataObjCopyInp_PI input, Reference<TransferStat_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 696, input);
        return IRODSApi.receiveServerResponse(comm, TransferStat_PI.class, output, null);
    }

    public static int rcDataObjRepl(RcComm comm, DataObjInp_PI input, Reference<TransferStat_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 695, input);
        return IRODSApi.receiveServerResponse(comm, TransferStat_PI.class, output, null);
    }

    public static int rcDataObjCreate(RcComm comm, DataObjInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 601, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDataObjChksum(RcComm comm, DataObjInp_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 629, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static int rcDataObjUnlink(RcComm comm, DataObjInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 615, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDataObjTrim(RcComm comm, DataObjInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 632, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDelayRuleLock(RcComm comm, DelayRuleLockInput_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 10222, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcDelayRuleUnlock(RcComm comm, DelayRuleUnlockInput_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 10223, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcCollCreate(RcComm comm, CollInpNew_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 681, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcModColl(RcComm comm, CollInpNew_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 680, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcOpenCollection(RcComm comm, CollInpNew_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 678, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcReadCollection(RcComm comm, int handle, Reference<CollEnt_PI> output) throws IOException {
        INT_PI input = new INT_PI();
        input.myInt = handle;
        IRODSApi.sendApiRequest(comm.sout, 713, input);
        return IRODSApi.receiveServerResponse(comm, CollEnt_PI.class, output, null);
    }

    public static int rcCloseCollection(RcComm comm, int handle) throws IOException {
        INT_PI input = new INT_PI();
        input.myInt = handle;
        IRODSApi.sendApiRequest(comm.sout, 661, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcRmColl(RcComm comm, CollInpNew_PI input, Reference<CollOprStat_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 679, input);
        return IRODSApi.receiveServerResponse(comm, CollOprStat_PI.class, output, null);
    }

    public static int rcTicketAdmin(RcComm comm, TicketAdminInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 723, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcUnregDataObj(RcComm comm, UnregDataObj_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 620, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcUserAdmin(RcComm comm, UserAdminInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 714, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcSpecificQuery(RcComm comm, SpecificQueryInp_PI input, Reference<GenQueryOut_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 722, input);
        return IRODSApi.receiveServerResponse(comm, GenQueryOut_PI.class, output, null);
    }

    public static int rcGetResourceInfoForOperation(RcComm comm, DataObjInp_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 10220, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static int rcZoneReport(RcComm comm, Reference<BytesBuf_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 10205);
        return IRODSApi.receiveServerResponse(comm, BytesBuf_PI.class, output, null);
    }

    public static int rcGetMiscSvrInfo(RcComm comm, Reference<MiscSvrInfo_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 700);
        return IRODSApi.receiveServerResponse(comm, MiscSvrInfo_PI.class, output, null);
    }

    public static int rcGeneralAdmin(RcComm comm, GeneralAdminInp_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 701, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcExecMyRule(RcComm comm, ExecMyRuleInp_PI input, Reference<MsParamArray_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 625, input);
        return IRODSApi.receiveServerResponse(comm, MsParamArray_PI.class, output, null);
    }

    public static int rcProcStat(RcComm comm, ProcStatInp_PI input, Reference<GenQueryOut_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 690);
        return IRODSApi.receiveServerResponse(comm, GenQueryOut_PI.class, output, null);
    }

    public static int rcRuleExecSubmit(RcComm comm, RULE_EXEC_DEL_INP_PI input, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 623, input);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, IRODS_STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((IRODS_STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static int rcRuleExecMod(RcComm comm, RULE_EXEC_MOD_INP_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 708, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    public static int rcRuleExecDel(RcComm comm, RULE_EXEC_DEL_INP_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 624, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    private static int rcRegReplica(RcComm comm, RegReplica_PI input) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 621, input);
        return IRODSApi.receiveServerResponse(comm, null, null, null);
    }

    private static int rcRegDataOb(RcComm comm, DataObjInfo_PI input, Reference<DataObjInfo_PI> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 619, input);
        return IRODSApi.receiveServerResponse(comm, DataObjInfo_PI.class, output, null);
    }

    public static int rcGetLibraryFeatures(RcComm comm, Reference<String> output) throws IOException {
        IRODSApi.sendApiRequest(comm.sout, 801);
        Reference outputPI = new Reference();
        int ec = IRODSApi.receiveServerResponse(comm, STR_PI.class, outputPI, null);
        if (null != outputPI.value) {
            output.value = ((STR_PI)outputPI.value).myStr;
        }
        return ec;
    }

    public static class RcComm {
        public Socket socket;
        public Socket plainSocket;
        public SSLSocket sslSocket;
        public InputStream sin;
        public OutputStream sout;
        public boolean usingTLS = false;
        public boolean secure = false;
        public boolean loggedIn = false;
        public String clientUsername;
        public String clientUserZone;
        public String proxyUsername;
        public String proxyUserZone;
        public String sessionSignature;
        public String relVersion;
        public String apiVersion;
        public int status;
        public int cookie;
        public String hashAlgorithm;
        public RError_PI rError;
    }

    public static class ByteArrayReference {
        public byte[] data;
    }

    public static final class ConnectionOptions {
        public String clientServerNegotiation = "CS_NEG_REFUSE";
        public String sslTruststore;
        public String sslTruststorePassword;
        public String sslProtocol;
        public String encryptionAlgorithm = "AES-256-CBC";
        public int encryptionKeySize = 32;
        public int encryptionNumHashRounds = 16;
        public int encryptionSaltSize = 8;
        public String hashAlgorithm = "md5";
        public boolean enableTcpKeepAlive = true;
        public boolean enableTcpNoDelay = false;
        public int tcpSendBufferSize = -1;
        public int tcpReceiveBufferSize = -1;
        public boolean applySocketPerformancePreferences = false;
        public int ppConnectionTime = 0;
        public int ppLatency = 0;
        public int ppBandwidth = 0;

        public ConnectionOptions copy() {
            ConnectionOptions copy = new ConnectionOptions();
            copy.clientServerNegotiation = this.clientServerNegotiation;
            copy.sslTruststore = this.sslTruststore;
            copy.sslTruststorePassword = this.sslTruststorePassword;
            copy.sslProtocol = this.sslProtocol;
            copy.encryptionAlgorithm = this.encryptionAlgorithm;
            copy.encryptionKeySize = this.encryptionKeySize;
            copy.encryptionNumHashRounds = this.encryptionNumHashRounds;
            copy.encryptionSaltSize = this.encryptionSaltSize;
            copy.hashAlgorithm = this.hashAlgorithm;
            copy.enableTcpKeepAlive = this.enableTcpKeepAlive;
            copy.enableTcpNoDelay = this.enableTcpNoDelay;
            copy.tcpSendBufferSize = this.tcpSendBufferSize;
            copy.tcpReceiveBufferSize = this.tcpReceiveBufferSize;
            copy.applySocketPerformancePreferences = this.applySocketPerformancePreferences;
            copy.ppConnectionTime = this.ppConnectionTime;
            copy.ppLatency = this.ppLatency;
            copy.ppBandwidth = this.ppBandwidth;
            return copy;
        }
    }
}

