/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.vfs;

import java.io.IOException;
import java.util.Iterator;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.high_level.vfs.CollectionEntry;
import org.irods.irods4j.high_level.vfs.IRODSCollectionIterator;
import org.irods.irods4j.high_level.vfs.IRODSFilesystemException;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class IRODSRecursiveCollectionIterator
implements Iterable<CollectionEntry> {
    private static final Logger log = LogManager.getLogger();
    private static final int DEFAULT_NUMBER_OF_ROWS_PER_PAGE = 512;
    private IRODSApi.RcComm comm;
    private Stack<IRODSCollectionIterator> stack;
    private IRODSCollectionIterator.CollectionEntryIterator curIter;
    private IRODSCollectionIterator.CollectionOptions options;
    private boolean recurse = true;

    public IRODSRecursiveCollectionIterator(IRODSApi.RcComm comm, String logicalPath) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, IRODSCollectionIterator.CollectionOptions.NONE);
    }

    public IRODSRecursiveCollectionIterator(IRODSApi.RcComm comm, String logicalPath, int rowsPerPage) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, rowsPerPage, IRODSCollectionIterator.CollectionOptions.NONE);
    }

    public IRODSRecursiveCollectionIterator(IRODSApi.RcComm comm, String logicalPath, IRODSCollectionIterator.CollectionOptions options) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, 512, options);
    }

    public IRODSRecursiveCollectionIterator(IRODSApi.RcComm comm, String logicalPath, int rowsPerPage, IRODSCollectionIterator.CollectionOptions options) throws IRODSFilesystemException, IOException, IRODSException {
        IRODSCollectionIterator iter = new IRODSCollectionIterator(comm, logicalPath, rowsPerPage, options);
        this.curIter = (IRODSCollectionIterator.CollectionEntryIterator)iter.iterator();
        this.stack = new Stack();
        this.stack.push(iter);
        this.comm = comm;
        this.options = options;
    }

    public IRODSCollectionIterator.CollectionOptions getCollectionOptions() {
        return this.options;
    }

    public int getDepth() {
        return this.stack.size() - 1;
    }

    public boolean recursionPending() {
        return this.recurse;
    }

    public void pop() {
        if (this.stack.isEmpty()) {
            return;
        }
        this.stack.pop();
        this.curIter = this.stack.isEmpty() ? null : (IRODSCollectionIterator.CollectionEntryIterator)this.stack.peek().iterator();
    }

    public void disableRecursionPending() {
        this.recurse = false;
    }

    @Override
    public Iterator<CollectionEntry> iterator() {
        return new RecursiveCollectionEntryIterator(this);
    }

    public static final class RecursiveCollectionEntryIterator
    implements Iterator<CollectionEntry> {
        private IRODSRecursiveCollectionIterator iter;

        private RecursiveCollectionEntryIterator(IRODSRecursiveCollectionIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            while (null != this.iter.curIter) {
                if (this.iter.curIter.hasNext()) {
                    return true;
                }
                try {
                    this.iter.stack.pop();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                if (this.iter.stack.isEmpty()) {
                    this.iter.curIter = null;
                    return false;
                }
                this.iter.curIter = (IRODSCollectionIterator.CollectionEntryIterator)((IRODSCollectionIterator)this.iter.stack.peek()).iterator();
            }
            return false;
        }

        @Override
        public CollectionEntry next() {
            boolean addedNewCollection = false;
            CollectionEntry entry = this.iter.curIter.next();
            if (entry.isCollection() && this.iter.recurse) {
                Iterator<CollectionEntry> iterator;
                IRODSCollectionIterator tmpIter = null;
                try {
                    tmpIter = new IRODSCollectionIterator(this.iter.comm, entry.path, ((IRODSCollectionIterator)this.iter.stack.peek()).getRowsPerPage(), this.iter.options);
                }
                catch (IOException | IRODSException e) {
                    log.error(e.getMessage());
                }
                if (null != tmpIter && (iterator = tmpIter.iterator()).hasNext()) {
                    addedNewCollection = true;
                    this.iter.stack.push(tmpIter);
                    this.iter.curIter = (IRODSCollectionIterator.CollectionEntryIterator)iterator;
                    entry = iterator.next();
                }
            }
            if (!addedNewCollection) {
                // empty if block
            }
            this.iter.recurse = true;
            return entry;
        }
    }
}

