/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.vfs;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.high_level.catalog.IRODSQuery;
import org.irods.irods4j.high_level.vfs.CollectionEntry;
import org.irods.irods4j.high_level.vfs.IRODSFilesystemException;
import org.irods.irods4j.high_level.vfs.ObjectStatus;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class IRODSCollectionIterator
implements Iterable<CollectionEntry> {
    private static final Logger log = LogManager.getLogger();
    private static final int DEFAULT_NUMBER_OF_ROWS_PER_PAGE = 512;
    private IRODSApi.RcComm comm;
    private String logicalPath;
    private int rowsPerPage;
    private CollectionOptions collOptions;
    private List<List<String>> rows;
    private int rowIndex = 0;
    private boolean addPivotCondition = false;
    private boolean searchForCollections = false;
    private StringBuilder querySb;
    private String lastObjectId = "";

    public IRODSCollectionIterator(IRODSApi.RcComm comm, String logicalPath) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, CollectionOptions.NONE);
    }

    public IRODSCollectionIterator(IRODSApi.RcComm comm, String logicalPath, int rowsPerPage) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, rowsPerPage, CollectionOptions.NONE);
    }

    public IRODSCollectionIterator(IRODSApi.RcComm comm, String logicalPath, CollectionOptions options) throws IRODSFilesystemException, IOException, IRODSException {
        this(comm, logicalPath, 512, options);
    }

    public IRODSCollectionIterator(IRODSApi.RcComm comm, String logicalPath, int rowsPerPage, CollectionOptions options) throws IRODSFilesystemException, IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == logicalPath || logicalPath.isEmpty()) {
            throw new IllegalArgumentException("Logical path is null or empty");
        }
        if (rowsPerPage < 1) {
            throw new IllegalArgumentException("Rows per page is less than 1");
        }
        if (null == options) {
            throw new IllegalArgumentException("Collection options is null");
        }
        this.comm = comm;
        this.logicalPath = logicalPath;
        this.rowsPerPage = rowsPerPage;
        this.collOptions = options;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    @Override
    public Iterator<CollectionEntry> iterator() {
        return new CollectionEntryIterator(this);
    }

    public static enum CollectionOptions {
        NONE,
        SKIP_PERMISSION_DENIED;

    }

    public static final class CollectionEntryIterator
    implements Iterator<CollectionEntry> {
        private IRODSCollectionIterator iter;

        private CollectionEntryIterator(IRODSCollectionIterator iter) {
            this.iter = iter;
            if (null != iter.rows) {
                return;
            }
            iter.rows = null;
            iter.rowIndex = 0;
            iter.addPivotCondition = false;
            iter.searchForCollections = false;
            iter.querySb = new StringBuilder(512);
        }

        @Override
        public boolean hasNext() {
            if (null != this.iter.rows) {
                while (++this.iter.rowIndex < this.iter.rows.size()) {
                    String objectId = (String)((List)this.iter.rows.get(this.iter.rowIndex)).get(0);
                    if (this.iter.lastObjectId.equals(objectId)) continue;
                    this.iter.lastObjectId = objectId;
                    return true;
                }
                if (this.iter.rows.size() < this.iter.rowsPerPage) {
                    if (this.iter.searchForCollections) {
                        return false;
                    }
                    this.iter.searchForCollections = true;
                    this.iter.addPivotCondition = false;
                } else {
                    this.iter.addPivotCondition = true;
                }
                this.iter.rowIndex = 0;
            }
            if (!this.iter.searchForCollections) {
                this.iter.querySb.delete(0, this.iter.querySb.length());
                this.iter.querySb.append("select DATA_ID, DATA_NAME, DATA_SIZE, DATA_CHECKSUM, DATA_MODE, DATA_CREATE_TIME, DATA_MODIFY_TIME, DATA_REPL_STATUS where COLL_NAME = '");
                this.iter.querySb.append(this.iter.logicalPath);
                this.iter.querySb.append("'");
                if (this.iter.addPivotCondition) {
                    this.iter.addPivotCondition = false;
                    this.iter.querySb.append(" and DATA_ID > '");
                    this.iter.querySb.append((String)((List)this.iter.rows.get(this.iter.rows.size() - 1)).get(0));
                    this.iter.querySb.append("' order by DATA_ID, DATA_REPL_STATUS desc, DATA_MODIFY_TIME desc limit ");
                    this.iter.querySb.append(this.iter.rowsPerPage);
                } else {
                    this.iter.querySb.append(" order by DATA_ID, DATA_REPL_STATUS desc, DATA_MODIFY_TIME desc limit ");
                    this.iter.querySb.append(this.iter.rowsPerPage);
                }
                try {
                    this.iter.rows = IRODSQuery.executeGenQuery2(this.iter.comm, ((IRODSCollectionIterator)this.iter).comm.proxyUserZone, this.iter.querySb.toString());
                    if (!this.iter.rows.isEmpty()) {
                        this.iter.lastObjectId = (String)((List)this.iter.rows.get(0)).get(0);
                        return true;
                    }
                    this.iter.searchForCollections = true;
                    this.iter.rowIndex = 0;
                }
                catch (IOException | IRODSException e) {
                    log.error(e.getMessage());
                }
            }
            if (this.iter.searchForCollections) {
                this.iter.querySb.delete(0, this.iter.querySb.length());
                this.iter.querySb.append("select COLL_ID, COLL_NAME, COLL_CREATE_TIME, COLL_MODIFY_TIME where COLL_PARENT_NAME = '");
                this.iter.querySb.append(this.iter.logicalPath);
                this.iter.querySb.append("'");
                if (this.iter.addPivotCondition) {
                    this.iter.addPivotCondition = false;
                    this.iter.querySb.append(" and COLL_ID > '");
                    this.iter.querySb.append((String)((List)this.iter.rows.get(this.iter.rows.size() - 1)).get(0));
                    this.iter.querySb.append("' order by COLL_ID limit ");
                    this.iter.querySb.append(this.iter.rowsPerPage);
                } else {
                    this.iter.querySb.append(" order by COLL_ID limit ");
                    this.iter.querySb.append(this.iter.rowsPerPage);
                }
                try {
                    this.iter.rows = IRODSQuery.executeGenQuery2(this.iter.comm, ((IRODSCollectionIterator)this.iter).comm.proxyUserZone, this.iter.querySb.toString());
                    if (!this.iter.rows.isEmpty()) {
                        this.iter.lastObjectId = (String)((List)this.iter.rows.get(0)).get(0);
                        return true;
                    }
                }
                catch (IOException | IRODSException e) {
                    log.error(e.getMessage());
                }
            }
            return false;
        }

        @Override
        public CollectionEntry next() {
            List row = (List)this.iter.rows.get(this.iter.rowIndex);
            CollectionEntry e = new CollectionEntry();
            if (this.iter.searchForCollections) {
                e.dataId = (String)row.get(0);
                e.path = (String)row.get(1);
                e.ctime = Long.parseLong((String)row.get(2));
                e.mtime = Long.parseLong((String)row.get(3));
                e.status = new ObjectStatus();
                e.status.setType(ObjectStatus.ObjectType.COLLECTION);
                return e;
            }
            e.dataId = (String)row.get(0);
            e.path = String.join((CharSequence)"/", this.iter.logicalPath, (CharSequence)row.get(1));
            e.dataSize = Long.parseLong((String)row.get(2));
            e.checksum = (String)row.get(3);
            e.dataMode = Integer.parseInt((String)row.get(4));
            e.ctime = Long.parseLong((String)row.get(5));
            e.mtime = Long.parseLong((String)row.get(6));
            e.status = new ObjectStatus();
            e.status.setType(ObjectStatus.ObjectType.DATA_OBJECT);
            return e;
        }
    }
}

