/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.policy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.BinBytesBuf_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ExecCmdOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.ExecMyRuleInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsParamArray_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsParam_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.RHostAddr_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.STR_PI;

public class IRODSRules {
    public static List<String> getAvailableRuleEnginePluginInstances(IRODSApi.RcComm comm) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        ExecMyRuleInp_PI input = new ExecMyRuleInp_PI();
        input.RHostAddr_PI = new RHostAddr_PI();
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.ssLen = 1;
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        input.KeyValPair_PI.keyWord.add("available");
        input.KeyValPair_PI.svalue.add("");
        input.MsParamArray_PI = new MsParamArray_PI();
        input.MsParamArray_PI.paramLen = 0;
        Reference<MsParamArray_PI> output = new Reference<MsParamArray_PI>();
        int ec = IRODSApi.rcExecMyRule(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcExecMyRule error");
        }
        ArrayList<String> repInstances = new ArrayList<String>();
        if (comm.rError.count > 0) {
            String[] lines = comm.rError.RErrMsg_PI.get((int)0).msg.split("\n");
            for (int i = 1; i < lines.length; ++i) {
                repInstances.add(lines[i].trim());
            }
        }
        return repInstances;
    }

    public static Map<String, String> executeRule(IRODSApi.RcComm comm, RuleArguments args) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == args) {
            throw new IllegalArgumentException("Rule arguments is null");
        }
        ExecMyRuleInp_PI input = new ExecMyRuleInp_PI();
        input.RHostAddr_PI = new RHostAddr_PI();
        StringBuilder ruleTextSb = new StringBuilder("@external rule { ");
        ruleTextSb.append(args.ruleText);
        ruleTextSb.append(" }");
        input.myRule = ruleTextSb.toString();
        input.KeyValPair_PI = new KeyValPair_PI();
        args.ruleEnginePluginInstance.ifPresent(instanceName -> {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord = new ArrayList<String>();
            input.KeyValPair_PI.svalue = new ArrayList<String>();
            input.KeyValPair_PI.keyWord.add("instance_name");
            input.KeyValPair_PI.svalue.add((String)instanceName);
        });
        input.MsParamArray_PI = new MsParamArray_PI();
        input.MsParamArray_PI.paramLen = 0;
        args.input.ifPresent(m -> m.forEach((name, value) -> {
            ++input.MsParamArray_PI.paramLen;
            if (null == input.MsParamArray_PI.MsParam_PI) {
                input.MsParamArray_PI.MsParam_PI = new ArrayList<MsParam_PI>();
            }
            MsParam_PI mp = new MsParam_PI();
            mp.label = name;
            mp.type = "STR_PI";
            mp.inOutStruct = new STR_PI();
            ((STR_PI)mp.inOutStruct).myStr = value;
            input.MsParamArray_PI.MsParam_PI.add(mp);
        }));
        args.output.ifPresent(l -> {
            input.outParamDesc = String.join((CharSequence)"%", l);
        });
        Reference<MsParamArray_PI> output = new Reference<MsParamArray_PI>();
        int ec = IRODSApi.rcExecMyRule(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcExecMyRule error");
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (int i = 0; i < ((MsParamArray_PI)output.value).paramLen; ++i) {
            MsParam_PI msp = ((MsParamArray_PI)output.value).MsParam_PI.get(i);
            if ("STR_PI".equals(msp.type)) {
                results.put(msp.label, ((STR_PI)msp.inOutStruct).myStr);
                continue;
            }
            if (!"ExecCmdOut_PI".equals(msp.type)) continue;
            ExecCmdOut_PI ruleExecOut = (ExecCmdOut_PI)msp.inOutStruct;
            BinBytesBuf_PI bbbuf = ruleExecOut.BinBytesBuf_PI.get(0);
            results.put("stdout", bbbuf.buflen > 0 ? bbbuf.buf.trim() : "");
            bbbuf = ruleExecOut.BinBytesBuf_PI.get(1);
            results.put("stderr", bbbuf.buflen > 0 ? bbbuf.buf.trim() : "");
        }
        return results;
    }

    public static final class RuleArguments {
        public String ruleText;
        public Optional<Map<String, String>> input;
        public Optional<List<String>> output;
        public Optional<String> ruleEnginePluginInstance;
    }
}

