/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.connection;

import java.io.IOException;
import java.util.Optional;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.high_level.connection.QualifiedUsername;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.RErrMsg_PI;

public class IRODSConnection
implements AutoCloseable {
    private String host;
    private int port;
    private QualifiedUsername clientUser;
    private QualifiedUsername proxyUser;
    private IRODSApi.ConnectionOptions connOptions;
    private IRODSApi.RcComm comm;

    public IRODSConnection() {
        this.connOptions = new IRODSApi.ConnectionOptions();
    }

    public IRODSConnection(IRODSApi.ConnectionOptions options) {
        if (null == options) {
            throw new IllegalArgumentException("Connection options is null");
        }
        this.connOptions = options.copy();
    }

    public void connect(String host, int port, QualifiedUsername clientUser) throws Exception {
        IRODSConnection.throwIfInvalidHost(host);
        IRODSConnection.throwIfInvalidPortNumber(port);
        IRODSConnection.throwIfInvalidClientUser(clientUser);
        this.host = host;
        this.port = port;
        this.clientUser = clientUser;
        this.doConnect();
    }

    public void connect(String host, int port, QualifiedUsername proxyUser, QualifiedUsername clientUser) throws Exception {
        IRODSConnection.throwIfInvalidHost(host);
        IRODSConnection.throwIfInvalidPortNumber(port);
        IRODSConnection.throwIfInvalidProxyUser(proxyUser);
        IRODSConnection.throwIfInvalidClientUser(clientUser);
        this.host = host;
        this.port = port;
        this.clientUser = clientUser;
        this.proxyUser = proxyUser;
        this.doConnect();
    }

    public void connect() throws Exception {
        this.doConnect();
    }

    public void authenticate(AuthPlugin authPlugin, String password) throws Exception {
        IRODSApi.rcAuthenticateClient(this.comm, authPlugin, password);
    }

    public boolean isConnected() {
        return null != this.comm && this.comm.socket.isConnected();
    }

    public IRODSApi.RcComm getRcComm() {
        if (!this.isConnected()) {
            throw new IllegalStateException("No active connection to server");
        }
        return this.comm;
    }

    public IRODSApi.RcComm release() {
        IRODSApi.RcComm connection = this.getRcComm();
        this.comm = null;
        return connection;
    }

    public void disconnect() throws IOException {
        if (null == this.comm) {
            return;
        }
        try {
            IRODSApi.rcDisconnect(this.comm);
        }
        finally {
            this.comm = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    private static void throwIfInvalidHost(String host) {
        if (null == host || host.isEmpty()) {
            throw new IllegalArgumentException("Host is null or empty");
        }
    }

    private static void throwIfInvalidPortNumber(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("Port is less than or equal to 0");
        }
    }

    private static void throwIfInvalidProxyUser(QualifiedUsername user) {
        if (null == user) {
            throw new IllegalArgumentException("Proxy user is null");
        }
    }

    private static void throwIfInvalidClientUser(QualifiedUsername user) {
        if (null == user) {
            throw new IllegalArgumentException("Client user is null");
        }
    }

    private void doConnect() throws Exception {
        this.disconnect();
        Optional<String> proxyUserName = Optional.empty();
        Optional<String> proxyUserZone = Optional.empty();
        if (null != this.proxyUser) {
            proxyUserName = Optional.of(this.proxyUser.getName());
            proxyUserZone = Optional.of(this.proxyUser.getZone());
        }
        Optional<IRODSApi.ConnectionOptions> options = Optional.of(this.connOptions);
        Optional<RErrMsg_PI> errInfo = Optional.of(new RErrMsg_PI());
        this.comm = IRODSApi.rcConnect(this.host, this.port, this.clientUser.getName(), this.clientUser.getZone(), proxyUserName, proxyUserZone, options, errInfo);
        if (null == this.comm || errInfo.get().status < 0) {
            throw new IRODSException(errInfo.get().status, "rcConnect error");
        }
    }
}

