/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.low_level.api.GenQuery1AggregationFunctions;
import org.irods.irods4j.low_level.api.GenQuery1SortOptions;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.GenQueryInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.GenQueryOut_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.Genquery2Input_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.InxIvalPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.InxValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SpecificQueryInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.SqlResult_PI;

public class IRODSQuery {
    public static Map<String, Map<String, String>> getColumnMappings(IRODSApi.RcComm comm) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.column_mappings = 1;
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        return JsonUtil.fromJsonString((String)output.value, new TypeReference<Map<String, Map<String, String>>>(){});
    }

    public static String getGeneratedSQL(IRODSApi.RcComm comm, String query) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == query || query.isEmpty()) {
            throw new IllegalArgumentException("Query string is null or empty");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = query;
        input.sql_only = 1;
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        return (String)output.value;
    }

    public static List<List<String>> executeGenQuery2(IRODSApi.RcComm comm, String query) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == query || query.isEmpty()) {
            throw new IllegalArgumentException("Query string is null or empty");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = query;
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        return JsonUtil.fromJsonString((String)output.value, new TypeReference<List<List<String>>>(){});
    }

    public static List<List<String>> executeGenQuery2(IRODSApi.RcComm comm, String zone, String query) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == zone || zone.isEmpty()) {
            throw new IllegalArgumentException("Zone is null or empty");
        }
        if (null == query || query.isEmpty()) {
            throw new IllegalArgumentException("Query string is null or empty");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = query;
        input.zone = zone;
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        return JsonUtil.fromJsonString((String)output.value, new TypeReference<List<List<String>>>(){});
    }

    public static void executeGenQuery1(IRODSApi.RcComm comm, GenQuery1QueryArgs queryArgs, Function<List<String>, Boolean> rowHandler) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == queryArgs) {
            throw new IllegalArgumentException("Query arguments is null");
        }
        GenQueryInp_PI input = queryArgs.getGenQueryInp_PI();
        Reference<GenQueryOut_PI> output = new Reference<GenQueryOut_PI>();
        while (true) {
            int ec;
            if ((ec = IRODSApi.rcGenQuery(comm, input, output)) < 0) {
                if (-808000 == ec) break;
                throw new IRODSException(ec, "rcGenQuery error");
            }
            ArrayList<String> row = new ArrayList<String>();
            for (int r = 0; r < ((GenQueryOut_PI)output.value).rowCnt; ++r) {
                for (int c = 0; c < ((GenQueryOut_PI)output.value).attriCnt; ++c) {
                    SqlResult_PI sqlResult = ((GenQueryOut_PI)output.value).SqlResult_PI.get(c);
                    row.add(sqlResult.value.get(r));
                }
                if (!rowHandler.apply(Collections.unmodifiableList(row)).booleanValue()) {
                    return;
                }
                row.clear();
            }
            if (((GenQueryOut_PI)output.value).continueInx <= 0) break;
            input.continueInx = ((GenQueryOut_PI)output.value).continueInx;
        }
    }

    public static void executeSpecificQuery(IRODSApi.RcComm comm, String zone, String specificQueryName, List<String> bindArgs, Function<List<String>, Boolean> rowHandler) throws IOException, IRODSException {
        IRODSQuery.executeSpecificQueryImpl(comm, Optional.of(zone), specificQueryName, bindArgs, rowHandler);
    }

    public static void executeSpecificQuery(IRODSApi.RcComm comm, String specificQueryName, List<String> bindArgs, Function<List<String>, Boolean> rowHandler) throws IOException, IRODSException {
        IRODSQuery.executeSpecificQueryImpl(comm, Optional.empty(), specificQueryName, bindArgs, rowHandler);
    }

    private static void executeSpecificQueryImpl(IRODSApi.RcComm comm, Optional<String> zone, String specificQueryName, List<String> bindArgs, Function<List<String>, Boolean> rowHandler) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == specificQueryName || specificQueryName.isEmpty()) {
            throw new IllegalArgumentException("SpecificQuery name is null or empty");
        }
        if (null == bindArgs) {
            throw new IllegalArgumentException("Bind arguments is null");
        }
        if (bindArgs.size() > 10) {
            throw new IllegalArgumentException("Max number of bind arguments is greater than 10");
        }
        SpecificQueryInp_PI input = new SpecificQueryInp_PI();
        input.sql = specificQueryName;
        input.maxRows = 256;
        input.KeyValPair_PI = new KeyValPair_PI();
        zone.ifPresent(value -> {
            if (value.isEmpty()) {
                throw new IllegalArgumentException("Zone is null or empty");
            }
            input.KeyValPair_PI.ssLen = 1;
            input.KeyValPair_PI.keyWord = new ArrayList<String>();
            input.KeyValPair_PI.svalue = new ArrayList<String>();
            input.KeyValPair_PI.keyWord.add("zone");
            input.KeyValPair_PI.svalue.add((String)value);
        });
        block12: for (int i = 0; i < 10 && i < bindArgs.size(); ++i) {
            switch (i) {
                case 0: {
                    input.arg1 = bindArgs.get(i);
                    continue block12;
                }
                case 1: {
                    input.arg2 = bindArgs.get(i);
                    continue block12;
                }
                case 2: {
                    input.arg3 = bindArgs.get(i);
                    continue block12;
                }
                case 3: {
                    input.arg4 = bindArgs.get(i);
                    continue block12;
                }
                case 4: {
                    input.arg5 = bindArgs.get(i);
                    continue block12;
                }
                case 5: {
                    input.arg6 = bindArgs.get(i);
                    continue block12;
                }
                case 6: {
                    input.arg7 = bindArgs.get(i);
                    continue block12;
                }
                case 7: {
                    input.arg8 = bindArgs.get(i);
                    continue block12;
                }
                case 8: {
                    input.arg9 = bindArgs.get(i);
                    continue block12;
                }
                case 9: {
                    input.arg10 = bindArgs.get(i);
                }
            }
        }
        Reference<GenQueryOut_PI> output = new Reference<GenQueryOut_PI>();
        while (true) {
            int ec;
            if ((ec = IRODSApi.rcSpecificQuery(comm, input, output)) < 0) {
                if (-808000 == ec) break;
                throw new IRODSException(ec, "rcSpecificQuery error");
            }
            ArrayList<String> row = new ArrayList<String>();
            for (int r = 0; r < ((GenQueryOut_PI)output.value).rowCnt; ++r) {
                for (int c = 0; c < ((GenQueryOut_PI)output.value).attriCnt; ++c) {
                    SqlResult_PI sqlResult = ((GenQueryOut_PI)output.value).SqlResult_PI.get(c);
                    row.add(sqlResult.value.get(r));
                }
                if (!rowHandler.apply(Collections.unmodifiableList(row)).booleanValue()) {
                    return;
                }
                row.clear();
            }
            if (((GenQueryOut_PI)output.value).continueInx <= 0) break;
            input.continueInx = ((GenQueryOut_PI)output.value).continueInx;
        }
    }

    public static final class GenQuery1QueryArgs {
        private GenQueryInp_PI input = new GenQueryInp_PI();

        public GenQuery1QueryArgs() {
            this.init();
        }

        public void setMaxRowsPerPage(int rows) {
            if (rows <= 0) {
                throw new IllegalArgumentException("Max rows per page is less than or equal to 0");
            }
            this.input.maxRows = rows;
        }

        public void setRowOffset(int offset) {
            if (offset <= 0) {
                throw new IllegalArgumentException("Row offset is less than or equal to 0");
            }
            this.input.partialStartIndex = offset;
        }

        public void enableReturnTotalRowCount() {
            this.input.options |= 0x20;
        }

        public void enableNoDistinct() {
            this.input.options |= 0x40;
        }

        public void enableQuotaQuery() {
            this.input.options |= 0x80;
        }

        public void enableAutoClose() {
            this.input.options |= 0x100;
        }

        public void enableUpperCaseWhere() {
            this.input.options |= 0x200;
        }

        public void addApiOption(String name, String value) {
            if (null == name || name.isEmpty()) {
                throw new IllegalArgumentException("Option name is null or empty");
            }
            if (null == value || value.isEmpty()) {
                throw new IllegalArgumentException("Option value is null or empty");
            }
            ++this.input.KeyValPair_PI.ssLen;
            this.input.KeyValPair_PI.keyWord.add(name);
            this.input.KeyValPair_PI.svalue.add(value);
        }

        public void addColumnToSelectClause(int columnId) {
            if (columnId <= 0) {
                throw new IllegalArgumentException("Column Id is less than or equal to 0");
            }
            if (this.input.InxIvalPair_PI.iiLen == 50) {
                throw new IllegalStateException("Max number of columns in SELECT clause has been reached");
            }
            ++this.input.InxIvalPair_PI.iiLen;
            this.input.InxIvalPair_PI.inx.add(columnId);
            this.input.InxIvalPair_PI.ivalue.add(0);
        }

        public void addColumnToSelectClause(int columnId, GenQuery1SortOptions sortOption) {
            if (columnId <= 0) {
                throw new IllegalArgumentException("Column Id is less than or equal to 0");
            }
            if (this.input.InxIvalPair_PI.iiLen == 50) {
                throw new IllegalStateException("Max number of columns in SELECT clause has been reached");
            }
            if (null == sortOption) {
                throw new IllegalArgumentException("Sort option is null");
            }
            ++this.input.InxIvalPair_PI.iiLen;
            this.input.InxIvalPair_PI.inx.add(columnId);
            int opt = 0;
            switch (sortOption) {
                case NONE: {
                    break;
                }
                case ORDER_BY: {
                    opt = 1024;
                    break;
                }
                case ORDER_BY_DESC: {
                    opt = 2048;
                }
            }
            this.input.InxIvalPair_PI.ivalue.add(opt);
        }

        public void addColumnToSelectClause(int columnId, GenQuery1AggregationFunctions aggFn) {
            if (columnId <= 0) {
                throw new IllegalArgumentException("Column Id is less than or equal to 0");
            }
            if (this.input.InxIvalPair_PI.iiLen == 50) {
                throw new IllegalStateException("Max number of columns in SELECT clause has been reached");
            }
            if (null == aggFn) {
                throw new IllegalArgumentException("Aggregation function is null");
            }
            ++this.input.InxIvalPair_PI.iiLen;
            this.input.InxIvalPair_PI.inx.add(columnId);
            int opt = 0;
            switch (aggFn) {
                case NONE: {
                    break;
                }
                case SELECT_MIN: {
                    opt = 2;
                    break;
                }
                case SELECT_MAX: {
                    opt = 3;
                    break;
                }
                case SELECT_SUM: {
                    opt = 4;
                    break;
                }
                case SELECT_AVG: {
                    opt = 5;
                    break;
                }
                case SELECT_COUNT: {
                    opt = 6;
                }
            }
            this.input.InxIvalPair_PI.ivalue.add(opt);
        }

        public void addConditionToWhereClause(int columnId, String condition) {
            if (columnId <= 0) {
                throw new IllegalArgumentException("Column Id is less than or equal to 0");
            }
            if (null == condition || condition.isEmpty()) {
                throw new IllegalArgumentException("Condition string is null or empty");
            }
            ++this.input.InxValPair_PI.isLen;
            this.input.InxValPair_PI.inx.add(columnId);
            this.input.InxValPair_PI.svalue.add(condition);
        }

        public GenQueryInp_PI getGenQueryInp_PI() {
            return this.input;
        }

        public void init() {
            this.input = new GenQueryInp_PI();
            this.input.maxRows = 256;
            this.input.KeyValPair_PI = new KeyValPair_PI();
            this.input.KeyValPair_PI.keyWord = new ArrayList<String>();
            this.input.KeyValPair_PI.svalue = new ArrayList<String>();
            this.input.InxIvalPair_PI = new InxIvalPair_PI();
            this.input.InxIvalPair_PI.inx = new ArrayList<Integer>();
            this.input.InxIvalPair_PI.ivalue = new ArrayList<Integer>();
            this.input.InxValPair_PI = new InxValPair_PI();
            this.input.InxValPair_PI.inx = new ArrayList<Integer>();
            this.input.InxValPair_PI.svalue = new ArrayList<String>();
        }
    }
}

