/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.low_level.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.XmlUtil;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsgHeader_PI;

public class Network {
    private static final Logger log = LogManager.getLogger();

    public static void write(OutputStream out, MsgHeader_PI msgHeader) throws IOException {
        String msg = XmlUtil.toXmlString(msgHeader);
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.putInt(msg.length());
        out.write(bbuf.array());
        out.write(msg.getBytes());
        if (log.isDebugEnabled()) {
            log.debug("Wrote {} bytes", (Object)msg.length());
            log.debug("Message:\n{}", (Object)msg);
        }
    }

    public static <T> void writeXml(OutputStream out, T object) throws IOException {
        String msg = XmlUtil.toXmlString(object);
        out.write(msg.getBytes());
        log.debug("Wrote:\n{}", (Object)msg);
    }

    public static <T> void writeJson(OutputStream out, T object) throws IOException {
        String msg = JsonUtil.toJsonString(object);
        out.write(msg.getBytes());
        log.debug("Wrote:\n{}", (Object)msg);
    }

    public static MsgHeader_PI readMsgHeader_PI(InputStream in) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        byte[] msgHeaderLengthBytes = in.readNBytes(4);
        bbuf.put(msgHeaderLengthBytes);
        bbuf.flip();
        int msgHeaderLength = bbuf.getInt();
        byte[] msgHeaderBytes = in.readNBytes(msgHeaderLength);
        if (log.isDebugEnabled()) {
            log.debug("Received:\n{}", (Object)new String(msgHeaderBytes, StandardCharsets.UTF_8));
        }
        return XmlUtil.fromBytes(msgHeaderBytes, MsgHeader_PI.class);
    }

    public static <T> T readObject(InputStream in, int size, Class<T> clazz) throws IOException {
        byte[] bytes = in.readNBytes(size);
        if (log.isDebugEnabled()) {
            log.debug("Received:\n{}", (Object)new String(bytes, StandardCharsets.UTF_8));
        }
        return XmlUtil.fromBytes(bytes, clazz);
    }

    public static byte[] readBytes(InputStream in, int size) throws IOException {
        byte[] bytes = in.readNBytes(size);
        if (log.isDebugEnabled()) {
            log.debug("Received:\n{}", (Object)new String(bytes, StandardCharsets.UTF_8));
        }
        return bytes;
    }

    public static void readBytes(InputStream in, byte[] buffer, int size) throws IOException {
        in.readNBytes(buffer, 0, size);
    }

    public static void writeBytes(OutputStream out, byte[] bytes) throws IOException {
        out.write(bytes);
    }

    public static void writeBytes(OutputStream out, byte[] bytes, int count) throws IOException {
        out.write(bytes, 0, count);
    }
}

