/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.administration;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.common.Versioning;
import org.irods.irods4j.high_level.administration.Common;
import org.irods.irods4j.high_level.administration.IRODSZones;
import org.irods.irods4j.high_level.catalog.IRODSQuery;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.GeneralAdminInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.Genquery2Input_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.UserAdminInp_PI;

public class IRODSUsers {
    public static UserType toUserType(String v) {
        if ("rodsuser".equals(v)) {
            return UserType.RODSUSER;
        }
        if ("groupadmin".equals(v)) {
            return UserType.GROUPADMIN;
        }
        if ("rodsadmin".equals(v)) {
            return UserType.RODSADMIN;
        }
        if ("rodsgroup".equals(v)) {
            return UserType.RODSGROUP;
        }
        throw new IllegalArgumentException("User type not supported: " + v);
    }

    public static String toString(UserType v) {
        switch (v) {
            case RODSUSER: {
                return "rodsuser";
            }
            case GROUPADMIN: {
                return "groupadmin";
            }
            case RODSADMIN: {
                return "rodsadmin";
            }
        }
        throw new IllegalArgumentException("User type not supported");
    }

    public static String localUniqueName(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (user.zone.isEmpty()) {
            return user.name;
        }
        StringBuilder qualifiedName = new StringBuilder(user.name);
        if (!user.zone.equals(Common.getLocalZone(comm))) {
            qualifiedName.append('#');
            qualifiedName.append(user.zone);
        }
        return qualifiedName.toString();
    }

    public static void addUser(IRODSApi.RcComm comm, User user, UserType userType, IRODSZones.ZoneType zoneType) throws IOException, IRODSException {
        User currentUser;
        Optional<UserType> currentUserType;
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        if (null == userType) {
            throw new IllegalArgumentException("User type is null");
        }
        if (null == zoneType) {
            throw new IllegalArgumentException("Zone type is null");
        }
        String name = IRODSUsers.localUniqueName(comm, user);
        String zone = null;
        if (IRODSZones.ZoneType.LOCAL == zoneType) {
            zone = Common.getLocalZone(comm);
        }
        if ((currentUserType = IRODSUsers.type(comm, currentUser = new User(comm.clientUsername, Optional.of(comm.clientUserZone)))).get() == UserType.GROUPADMIN) {
            UserAdminInp_PI input = new UserAdminInp_PI();
            input.arg0 = "mkuser";
            input.arg1 = name;
            input.arg3 = zone;
            int ec = IRODSApi.rcUserAdmin(comm, input);
            if (ec < 0) {
                throw new IRODSException(ec, "rcUserAdmin error");
            }
            return;
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "add";
        input.arg1 = "user";
        input.arg2 = name;
        input.arg3 = IRODSUsers.toString(currentUserType.get());
        input.arg4 = zone;
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void removeUser(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "rm";
        input.arg1 = "user";
        input.arg2 = IRODSUsers.localUniqueName(comm, user);
        input.arg3 = user.zone;
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void modifyUser(IRODSApi.RcComm comm, User user, UserProperty property) throws IOException, IRODSException, NoSuchAlgorithmException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        if (null == property) {
            throw new IllegalArgumentException("User property is null");
        }
        String name = IRODSUsers.localUniqueName(comm, user);
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "modify";
        input.arg1 = "user";
        input.arg2 = name;
        if (property instanceof UserPasswordProperty) {
            UserPasswordProperty p = (UserPasswordProperty)property;
            input.arg3 = "password";
            input.arg4 = IRODSUsers.obfuscatePassword(p, comm.hashAlgorithm);
        } else if (property instanceof UserTypeProperty) {
            UserTypeProperty p = (UserTypeProperty)property;
            input.arg3 = "type";
            input.arg4 = IRODSUsers.toString(p.value);
        } else if (property instanceof UserAuthenticationProperty) {
            UserAuthenticationProperty p = (UserAuthenticationProperty)property;
            input.arg4 = p.value;
            if (UserAuthenticationOperation.ADD == p.op) {
                input.arg3 = "addAuth";
            } else if (UserAuthenticationOperation.REMOVE == p.op) {
                input.arg3 = "rmAuth";
            }
        }
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void addGroup(IRODSApi.RcComm comm, Group group) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        String zone = Common.getLocalZone(comm);
        User currentUser = new User(comm.clientUsername, Optional.of(comm.clientUserZone));
        Optional<UserType> currentUserType = IRODSUsers.type(comm, currentUser);
        if (currentUserType.get() == UserType.GROUPADMIN) {
            UserAdminInp_PI input = new UserAdminInp_PI();
            input.arg0 = "mkgroup";
            input.arg1 = group.name;
            input.arg2 = "rodsgroup";
            input.arg3 = zone;
            int ec = IRODSApi.rcUserAdmin(comm, input);
            if (ec < 0) {
                throw new IRODSException(ec, "rcUserAdmin error");
            }
            return;
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "add";
        input.arg2 = group.name;
        input.arg4 = zone;
        if (Versioning.compareVersions(comm.relVersion.substring(4), "4.3.3") > 0) {
            input.arg1 = "group";
        } else {
            input.arg1 = "user";
            input.arg3 = "rodsgroup";
        }
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void removeGroup(IRODSApi.RcComm comm, Group group) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "rm";
        input.arg1 = "group";
        input.arg2 = group.name;
        input.arg3 = Common.getLocalZone(comm);
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void addUserToGroup(IRODSApi.RcComm comm, Group group, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        User currentUser = new User(comm.clientUsername, Optional.of(comm.clientUserZone));
        Optional<UserType> currentUserType = IRODSUsers.type(comm, currentUser);
        if (currentUserType.get() == UserType.GROUPADMIN) {
            UserAdminInp_PI input = new UserAdminInp_PI();
            input.arg0 = "modify";
            input.arg1 = "group";
            input.arg2 = group.name;
            input.arg3 = "add";
            input.arg4 = user.name;
            input.arg5 = user.zone;
            int ec = IRODSApi.rcUserAdmin(comm, input);
            if (ec < 0) {
                throw new IRODSException(ec, "rcUserAdmin error");
            }
            return;
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "modify";
        input.arg1 = "group";
        input.arg2 = group.name;
        input.arg3 = "add";
        input.arg4 = user.name;
        input.arg5 = user.zone;
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static void removeUserFromGroup(IRODSApi.RcComm comm, Group group, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        User currentUser = new User(comm.clientUsername, Optional.of(comm.clientUserZone));
        Optional<UserType> currentUserType = IRODSUsers.type(comm, currentUser);
        if (currentUserType.get() == UserType.GROUPADMIN) {
            UserAdminInp_PI input = new UserAdminInp_PI();
            input.arg0 = "modify";
            input.arg1 = "group";
            input.arg2 = group.name;
            input.arg3 = "remove";
            input.arg4 = user.name;
            input.arg5 = user.zone;
            int ec = IRODSApi.rcUserAdmin(comm, input);
            if (ec < 0) {
                throw new IRODSException(ec, "rcUserAdmin error");
            }
            return;
        }
        GeneralAdminInp_PI input = new GeneralAdminInp_PI();
        input.arg0 = "modify";
        input.arg1 = "group";
        input.arg2 = group.name;
        input.arg3 = "remove";
        input.arg4 = user.name;
        input.arg5 = user.zone;
        int ec = IRODSApi.rcGeneralAdmin(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGeneralAdmin error");
        }
    }

    public static List<User> users(IRODSApi.RcComm comm) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = "select USER_NAME, USER_ZONE where USER_TYPE != 'rodsgroup' limit 100000";
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        ArrayList<User> users = new ArrayList<User>();
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        if (!rows.isEmpty()) {
            rows.forEach(row -> users.add(new User((String)row.get(0), Optional.of((String)row.get(1)))));
        }
        return users;
    }

    public static List<User> users(IRODSApi.RcComm comm, Group group) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        IRODSQuery.GenQuery1QueryArgs input = new IRODSQuery.GenQuery1QueryArgs();
        input.addColumnToSelectClause(202);
        input.addColumnToSelectClause(204);
        input.addConditionToWhereClause(203, "!= 'rodsgroup'");
        input.addConditionToWhereClause(901, String.format("= '%s'", group.name));
        ArrayList<User> users = new ArrayList<User>();
        IRODSQuery.executeGenQuery1(comm, input, row -> {
            users.add(new User((String)row.get(0), Optional.of((String)row.get(1))));
            return true;
        });
        return users;
    }

    public static List<Group> groups(IRODSApi.RcComm comm) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = "select USER_NAME where USER_TYPE = 'rodsgroup' limit 100000";
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        rows.forEach(row -> groups.add(new Group((String)row.get(0))));
        return groups;
    }

    public static List<Group> groups(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        List<String> bindArgs = Arrays.asList(IRODSUsers.localUniqueName(comm, user));
        IRODSQuery.executeSpecificQuery(comm, "listGroupsForUser", bindArgs, row -> {
            groups.add(new Group((String)row.get(1)));
            return true;
        });
        return groups;
    }

    public static boolean exists(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = String.format("select USER_ID where USER_TYPE != 'rodsgroup' and USER_NAME = '%s' and USER_ZONE = '%s'", user.name, user.zone.isEmpty() ? Common.getLocalZone(comm) : user.zone);
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        return !rows.isEmpty();
    }

    public static boolean exists(IRODSApi.RcComm comm, Group group) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = String.format("select GROUP_ID where USER_TYPE = 'rodsgroup' and USER_NAME = '%s'", group.name);
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        return !rows.isEmpty();
    }

    public static Optional<String> id(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = String.format("select USER_ID where USER_TYPE != 'rodsgroup' and USER_NAME = '%s' and USER_ZONE = '%s'", user.name, user.zone.isEmpty() ? Common.getLocalZone(comm) : user.zone);
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(rows.get(0).get(0));
    }

    public static Optional<String> id(IRODSApi.RcComm comm, Group group) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == group) {
            throw new IllegalArgumentException("Group is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = String.format("select GROUP_ID where USER_TYPE = 'rodsgroup' and USER_NAME = '%s'", group.name);
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(rows.get(0).get(0));
    }

    public static Optional<UserType> type(IRODSApi.RcComm comm, User user) throws IOException, IRODSException {
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        if (null == user) {
            throw new IllegalArgumentException("User is null");
        }
        Genquery2Input_PI input = new Genquery2Input_PI();
        input.query_string = String.format("select USER_TYPE where USER_TYPE != 'rodsgroup' and USER_NAME = '%s' and USER_ZONE = '%s'", user.name, user.zone.isEmpty() ? Common.getLocalZone(comm) : user.zone);
        Reference<String> output = new Reference<String>();
        int ec = IRODSApi.rcGenQuery2(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcGenQuery2 error");
        }
        TypeReference<List<List<String>>> typeRef = new TypeReference<List<List<String>>>(){};
        List<List<String>> rows = JsonUtil.fromJsonString((String)output.value, typeRef);
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(IRODSUsers.toUserType(rows.get(0).get(0)));
    }

    public static boolean userIsMemberOfGroup(IRODSApi.RcComm comm, Group group, User user) throws IOException, IRODSException {
        IRODSQuery.GenQuery1QueryArgs input = new IRODSQuery.GenQuery1QueryArgs();
        input.addColumnToSelectClause(201);
        input.addConditionToWhereClause(203, "!= 'rodsgroup'");
        input.addConditionToWhereClause(202, String.format("= '%s'", user.name));
        String zone = user.zone.isEmpty() ? Common.getLocalZone(comm) : user.zone;
        input.addConditionToWhereClause(204, String.format("= '%s'", zone));
        input.addConditionToWhereClause(901, String.format("= '%s'", group.name));
        ArrayList userIds = new ArrayList();
        IRODSQuery.executeGenQuery1(comm, input, row -> {
            userIds.add((String)row.get(0));
            return true;
        });
        return !userIds.isEmpty();
    }

    private static String obfuscatePassword(UserPasswordProperty p, String hashAlgo) throws NoSuchAlgorithmException {
        int MAX_PASSWORD_LEN = 50;
        StringBuilder plainTextPasswordSb = new StringBuilder();
        plainTextPasswordSb.append(p.value);
        plainTextPasswordSb.setLength(60);
        int count = 40 - p.value.length();
        if (count > 15) {
            plainTextPasswordSb.append("1gCBizHWbwIYyWLoysGzTe6SyzqFKMniZX05faZHWAwQKXf6Fs".substring(0, count));
        }
        StringBuilder keySb = new StringBuilder();
        if (p.requesterPassword.length() >= 50) {
            throw new IllegalArgumentException("Requester password exceeds max key size: 50");
        }
        keySb.append(p.requesterPassword.substring(0, Math.min(p.requesterPassword.length(), 50)));
        return IRODSUsers.obfEncodeByKey(plainTextPasswordSb.toString(), keySb.toString(), hashAlgo);
    }

    private static String obfEncodeByKey(String data, String key, String hashAlgo) throws NoSuchAlgorithmException {
        int i;
        int[] keyBuf = new int[100];
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        int length = Math.min(keyBuf.length, key.length());
        for (int x = 0; x < length; ++x) {
            keyBuf[x] = keyBytes[x] & 0xFF;
        }
        byte[] hexKey = IRODSUsers.obfMakeOneWayHash(hashAlgo, keyBuf, keyBuf.length);
        int[] buffer = new int[64];
        IRODSUsers.copyIntArrayToByteArray(buffer, 0, hexKey, hexKey.length);
        byte[] v = IRODSUsers.obfMakeOneWayHash(hashAlgo, buffer, 16);
        IRODSUsers.copyIntArrayToByteArray(buffer, 16, v, v.length);
        v = IRODSUsers.obfMakeOneWayHash(hashAlgo, buffer, 32);
        IRODSUsers.copyIntArrayToByteArray(buffer, 32, v, v.length);
        v = IRODSUsers.obfMakeOneWayHash(hashAlgo, buffer, 32);
        IRODSUsers.copyIntArrayToByteArray(buffer, 48, v, v.length);
        int MAX_PASSWORD_LEN = 50;
        StringBuilder inSb = new StringBuilder(data);
        inSb.setLength(60);
        StringBuilder outSb = new StringBuilder();
        outSb.setLength(150);
        int[] wheel = new int[77];
        int j = 0;
        for (i = 0; i < 10; ++i) {
            wheel[j++] = 48 + i;
        }
        for (i = 0; i < 26; ++i) {
            wheel[j++] = 65 + i;
        }
        for (i = 0; i < 26; ++i) {
            wheel[j++] = 97 + i;
        }
        for (i = 0; i < 15; ++i) {
            wheel[j++] = 33 + i;
        }
        int cpKey = 0;
        int pc = 0;
        int cpIn = 0;
        int cpOut = 0;
        while (true) {
            int k = buffer[cpKey++];
            if (cpKey > 60) {
                cpKey = 0;
            }
            boolean found = false;
            for (int i2 = 0; i2 < wheel.length; ++i2) {
                if (inSb.charAt(cpIn) != wheel[i2]) continue;
                j = i2 + k + pc;
                outSb.setCharAt(cpOut++, (char)(wheel[j %= wheel.length] & 0xFF));
                found = true;
                break;
            }
            if (!found) {
                if (inSb.charAt(cpIn) == '\u0000') {
                    outSb.setLength(cpOut);
                    return outSb.toString();
                }
                outSb.setCharAt(cpOut++, inSb.charAt(cpIn));
            }
            ++cpIn;
        }
    }

    private static byte[] obfMakeOneWayHash(String hashAlgo, int[] buffer, int bufferLength) throws NoSuchAlgorithmException {
        byte[] bufUnsigned = new byte[bufferLength];
        for (int x = 0; x < bufferLength; ++x) {
            bufUnsigned[x] = (byte)(buffer[x] & 0xFF);
        }
        MessageDigest hasher = MessageDigest.getInstance(hashAlgo);
        return hasher.digest(bufUnsigned);
    }

    private static void copyIntArrayToByteArray(int[] dst, int dstOffset, byte[] src, int count) {
        for (int i = 0; i < src.length; ++i) {
            dst[i + dstOffset] = src[i] & 0xFF;
        }
    }

    public static enum UserType {
        RODSUSER,
        GROUPADMIN,
        RODSADMIN,
        RODSGROUP;

    }

    public static final class User
    implements Comparable<User> {
        public String name;
        public String zone;

        public User() {
        }

        public User(String name, Optional<String> zone) {
            this.name = name;
            this.zone = zone.orElse("");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            User other = (User)o;
            return this.name.equals(other.name) && this.zone.equals(other.zone);
        }

        @Override
        public int compareTo(User o) {
            int result = this.name.compareTo(o.name);
            if (0 == result) {
                return this.zone.compareTo(o.zone);
            }
            return result;
        }
    }

    public static final class UserPasswordProperty
    extends UserProperty {
        public String value;
        public String requesterPassword;
    }

    public static final class UserTypeProperty
    extends UserProperty {
        public UserType value;
    }

    public static final class UserAuthenticationProperty
    extends UserProperty {
        public UserAuthenticationOperation op;
        public String value;
    }

    public static enum UserAuthenticationOperation {
        ADD,
        REMOVE;

    }

    public static final class Group
    implements Comparable<Group> {
        public String name;

        public Group() {
        }

        public Group(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            return this.name.equals(((Group)o).name);
        }

        @Override
        public int compareTo(Group o) {
            return this.name.compareTo(o.name);
        }
    }

    public static class UserProperty {
    }
}

