/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.administration;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.irods.irods4j.high_level.common.AdminTag;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.TicketAdminInp_PI;

public class IRODSTickets {
    public static final AdminTag asAdmin = AdminTag.instance;

    public static void createTicket(IRODSApi.RcComm comm, String ticketName, TicketType ticketType, String logicalPath) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == ticketType) {
            throw new IllegalArgumentException("Ticket type is null");
        }
        if (null == logicalPath || logicalPath.isEmpty()) {
            throw new IllegalArgumentException("Logical path is null or empty");
        }
        String type = null;
        if (TicketType.READ == ticketType) {
            type = "read";
        } else if (TicketType.WRITE == ticketType) {
            type = "write";
        }
        IRODSTickets.execTicketOp(comm, false, "create", ticketName, type, logicalPath, ticketName, "");
    }

    public static void createTicket(AdminTag adminTag, IRODSApi.RcComm comm, String ticketName, TicketType ticketType, String logicalPath) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == ticketType) {
            throw new IllegalArgumentException("Ticket type is null");
        }
        if (null == logicalPath || logicalPath.isEmpty()) {
            throw new IllegalArgumentException("Logical path is null or empty");
        }
        String type = null;
        if (TicketType.READ == ticketType) {
            type = "read";
        } else if (TicketType.WRITE == ticketType) {
            type = "write";
        }
        IRODSTickets.execTicketOp(comm, true, "create", ticketName, type, logicalPath, ticketName, "");
    }

    public static String createTicket(IRODSApi.RcComm comm, TicketType ticketType, String logicalPath) throws IOException, IRODSException {
        String ticketName = IRODSTickets.genTicketName();
        IRODSTickets.createTicket(comm, ticketName, ticketType, logicalPath);
        return ticketName;
    }

    public static String createTicket(AdminTag adminTag, IRODSApi.RcComm comm, TicketType ticketType, String logicalPath) throws IOException, IRODSException {
        String ticketName = IRODSTickets.genTicketName();
        IRODSTickets.createTicket(adminTag, comm, ticketName, ticketType, logicalPath);
        return ticketName;
    }

    public static void deleteTicket(IRODSApi.RcComm comm, String ticketName) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        IRODSTickets.execTicketOp(comm, false, "delete", ticketName, "", "", "", "");
    }

    public static void deleteTicket(AdminTag adminTag, IRODSApi.RcComm comm, String ticketName) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        IRODSTickets.execTicketOp(comm, true, "delete", ticketName, "", "", "", "");
    }

    public static void deleteTicket(IRODSApi.RcComm comm, int ticketId) throws IOException, IRODSException {
        IRODSTickets.deleteTicket(comm, Integer.toString(ticketId));
    }

    public static void deleteTicket(AdminTag adminTag, IRODSApi.RcComm comm, int ticketId) throws IOException, IRODSException {
        IRODSTickets.deleteTicket(asAdmin, comm, Integer.toString(ticketId));
    }

    public static void addTicketConstraint(IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        String et = null;
        String cv = null;
        if (constraint instanceof UserConstraint) {
            UserConstraint c = (UserConstraint)constraint;
            et = "user";
            cv = c.value;
        } else if (constraint instanceof GroupConstraint) {
            GroupConstraint c = (GroupConstraint)constraint;
            et = "group";
            cv = c.value;
        } else if (constraint instanceof HostConstraint) {
            HostConstraint c = (HostConstraint)constraint;
            et = "host";
            cv = c.value;
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
        IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "add", et, cv, "");
    }

    public static void addTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == adminTag) {
            throw new IllegalArgumentException("Admin tag is null");
        }
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        String et = null;
        String cv = null;
        if (constraint instanceof UserConstraint) {
            UserConstraint c = (UserConstraint)constraint;
            et = "user";
            cv = c.value;
        } else if (constraint instanceof GroupConstraint) {
            GroupConstraint c = (GroupConstraint)constraint;
            et = "group";
            cv = c.value;
        } else if (constraint instanceof HostConstraint) {
            HostConstraint c = (HostConstraint)constraint;
            et = "host";
            cv = c.value;
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
        IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "add", et, cv, "");
    }

    public static void addTicketConstraint(IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.addTicketConstraint(comm, Integer.toString(ticketId), constraint);
    }

    public static void addTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.addTicketConstraint(adminTag, comm, Integer.toString(ticketId), constraint);
    }

    public static void setTicketConstraint(IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        String property = null;
        int cv = -1;
        if (constraint instanceof UseCountConstraint) {
            UseCountConstraint c = (UseCountConstraint)constraint;
            property = "uses";
            cv = c.value;
        } else if (constraint instanceof WriteCountToDataObjectConstraint) {
            WriteCountToDataObjectConstraint c = (WriteCountToDataObjectConstraint)constraint;
            property = "write-file";
            cv = c.value;
        } else if (constraint instanceof WriteByteCountConstraint) {
            WriteByteCountConstraint c = (WriteByteCountConstraint)constraint;
            property = "write-bytes";
            cv = c.value;
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
        if (cv < 0) {
            throw new IllegalArgumentException("Constraint value is less than 0");
        }
        IRODSTickets.execTicketOp(comm, false, "mod", ticketName, property, Integer.toString(cv), "", "");
    }

    public static void setTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == adminTag) {
            throw new IllegalArgumentException("Admin tag is null");
        }
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        String property = null;
        int cv = -1;
        if (constraint instanceof UseCountConstraint) {
            UseCountConstraint c = (UseCountConstraint)constraint;
            property = "uses";
            cv = c.value;
        } else if (constraint instanceof WriteCountToDataObjectConstraint) {
            WriteCountToDataObjectConstraint c = (WriteCountToDataObjectConstraint)constraint;
            property = "write-file";
            cv = c.value;
        } else if (constraint instanceof WriteByteCountConstraint) {
            WriteByteCountConstraint c = (WriteByteCountConstraint)constraint;
            property = "write-bytes";
            cv = c.value;
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
        if (cv < 0) {
            throw new IllegalArgumentException("Constraint value is less than 0");
        }
        IRODSTickets.execTicketOp(comm, true, "mod", ticketName, property, Integer.toString(cv), "", "");
    }

    public static void setTicketConstraint(IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.setTicketConstraint(comm, Integer.toString(ticketId), constraint);
    }

    public static void setTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.setTicketConstraint(adminTag, comm, Integer.toString(ticketId), constraint);
    }

    public static void removeTicketConstraint(IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        if (constraint instanceof UserConstraint) {
            UserConstraint c = (UserConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "remove", "user", c.value, "");
        } else if (constraint instanceof GroupConstraint) {
            GroupConstraint c = (GroupConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "remove", "group", c.value, "");
        } else if (constraint instanceof HostConstraint) {
            HostConstraint c = (HostConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "remove", "host", c.value, "");
        } else if (constraint instanceof UseCountConstraint) {
            UseCountConstraint c = (UseCountConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "users", "0", "", "");
        } else if (constraint instanceof WriteCountToDataObjectConstraint) {
            WriteCountToDataObjectConstraint c = (WriteCountToDataObjectConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "write-file", "0", "", "");
        } else if (constraint instanceof WriteByteCountConstraint) {
            WriteByteCountConstraint c = (WriteByteCountConstraint)constraint;
            IRODSTickets.execTicketOp(comm, false, "mod", ticketName, "write-bytes", "0", "", "");
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
    }

    public static void removeTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, String ticketName, TicketConstraint constraint) throws IOException, IRODSException {
        if (null == adminTag) {
            throw new IllegalArgumentException("Admin tag is null");
        }
        if (null == ticketName || ticketName.isEmpty()) {
            throw new IllegalArgumentException("Ticket name is null or empty");
        }
        if (null == constraint) {
            throw new IllegalArgumentException("Ticket constraint is null");
        }
        if (constraint instanceof UserConstraint) {
            UserConstraint c = (UserConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "remove", "user", c.value, "");
        } else if (constraint instanceof GroupConstraint) {
            GroupConstraint c = (GroupConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "remove", "group", c.value, "");
        } else if (constraint instanceof HostConstraint) {
            HostConstraint c = (HostConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "remove", "host", c.value, "");
        } else if (constraint instanceof UseCountConstraint) {
            UseCountConstraint c = (UseCountConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "users", "0", "", "");
        } else if (constraint instanceof WriteCountToDataObjectConstraint) {
            WriteCountToDataObjectConstraint c = (WriteCountToDataObjectConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "write-file", "0", "", "");
        } else if (constraint instanceof WriteByteCountConstraint) {
            WriteByteCountConstraint c = (WriteByteCountConstraint)constraint;
            IRODSTickets.execTicketOp(comm, true, "mod", ticketName, "write-bytes", "0", "", "");
        } else {
            throw new IllegalArgumentException("Constraint not supported");
        }
    }

    public static void removeTicketConstraint(IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.removeTicketConstraint(comm, Integer.toString(ticketId), constraint);
    }

    public static void removeTicketConstraint(AdminTag adminTag, IRODSApi.RcComm comm, int ticketId, TicketConstraint constraint) throws IOException, IRODSException {
        IRODSTickets.removeTicketConstraint(adminTag, comm, Integer.toString(ticketId), constraint);
    }

    private static void execTicketOp(IRODSApi.RcComm comm, boolean runAsAdmin, String cmd, String ticketNameOrId, String arg1, String arg2, String arg3, String arg4) throws IOException, IRODSException {
        int ec;
        if (null == comm) {
            throw new IllegalArgumentException("RcComm is null");
        }
        TicketAdminInp_PI input = new TicketAdminInp_PI();
        input.arg1 = cmd;
        input.arg2 = ticketNameOrId;
        input.arg3 = arg1;
        input.arg4 = arg2;
        input.arg5 = arg3;
        input.arg6 = arg4;
        input.KeyValPair_PI = new KeyValPair_PI();
        if (runAsAdmin) {
            input.KeyValPair_PI.ssLen = 1;
            input.KeyValPair_PI.keyWord = new ArrayList<String>();
            input.KeyValPair_PI.svalue = new ArrayList<String>();
            input.KeyValPair_PI.keyWord.add("irodsAdmin");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcTicketAdmin(comm, input)) < 0) {
            throw new IRODSException(ec, "rcTicketAdmin error");
        }
    }

    private static String genTicketName() {
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom rnd = new SecureRandom();
        StringBuilder tsb = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            tsb.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(rnd.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length())));
        }
        return tsb.toString();
    }

    public static enum TicketType {
        READ,
        WRITE;

    }

    public static class UserConstraint
    extends TicketConstraint {
        public String value;
    }

    public static class GroupConstraint
    extends TicketConstraint {
        public String value;
    }

    public static class HostConstraint
    extends TicketConstraint {
        public String value;
    }

    public static class TicketConstraint {
    }

    public static class UseCountConstraint
    extends TicketConstraint {
        public int value = -1;
    }

    public static class WriteCountToDataObjectConstraint
    extends TicketConstraint {
        public int value = -1;
    }

    public static class WriteByteCountConstraint
    extends TicketConstraint {
        public int value = -1;
    }
}

