/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.authentication.NativeAuthPlugin;
import org.irods.irods4j.authentication.PamPasswordAuthPlugin;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class AuthManager {
    private static final Logger log = LogManager.getLogger();

    public static void authenticateClient(IRODSApi.RcComm comm, String authScheme, JsonNode context) throws Exception {
        AuthPlugin plugin;
        log.debug(">>> STARTING AUTHENTICATION");
        if ("native".equals(authScheme)) {
            plugin = new NativeAuthPlugin();
        } else if ("pam_password".equals(authScheme)) {
            plugin = new PamPasswordAuthPlugin();
        } else {
            throw new IllegalArgumentException("Authentication scheme not supported: " + authScheme);
        }
        String nextOp = "auth_client_start";
        JsonNode req = context.deepCopy();
        ObjectNode mutableReq = (ObjectNode)req;
        mutableReq.put("scheme", authScheme);
        mutableReq.put("next_operation", nextOp);
        log.debug("Initial context = {}", (Object)JsonUtil.toJsonString(req));
        while (true) {
            JsonNode resp = plugin.execute(comm, nextOp, req);
            log.debug("Server response = {}", (Object)JsonUtil.toJsonString(resp));
            if (comm.loggedIn) break;
            if (!resp.has("next_operation")) {
                throw new IRODSException(-130000, "Authentication request missing [next_operation] parameter");
            }
            nextOp = resp.get("next_operation").asText();
            if (nextOp.isEmpty() || "flow_complete".equals(nextOp)) {
                throw new IRODSException(-826000, "Authentication flow completed without success");
            }
            req = resp;
        }
    }
}

