/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.high_level.vfs;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.Reference;
import org.irods.irods4j.high_level.catalog.IRODSQuery;
import org.irods.irods4j.high_level.common.AdminTag;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.protocol.packing_instructions.DataObjInp_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.KeyValPair_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.TransferStat_PI;

public class IRODSReplicas {
    public static final AdminTag asAdmin = AdminTag.instance;

    public static long replicaSize(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_SIZE where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_NUM = '%d'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, replicaNumber));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return Long.parseLong(rows.get(0).get(0));
    }

    public static long replicaSize(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Leaf resource is null or empty");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_SIZE where COLL_NAME = '%s' and DATA_NAME = '%s' and RESC_NAME = '%s'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, leafResourceName));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return Long.parseLong(rows.get(0).get(0));
    }

    public static long replicaSizeInStorage(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) {
        throw new UnsupportedOperationException();
    }

    public static long replicaSizeInStorage(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) {
        throw new UnsupportedOperationException();
    }

    public static void replicateReplica(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, int srcReplicaNumber, String dstResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(srcReplicaNumber, 0L, "Source replica number is less than 0");
        IRODSReplicas.throwIfNullOrEmpty(dstResourceName, "Destination resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(srcReplicaNumber));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("destRescName");
        input.KeyValPair_PI.svalue.add(dstResourceName);
        Reference<TransferStat_PI> output = new Reference<TransferStat_PI>();
        int ec = IRODSApi.rcDataObjRepl(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjRepl error");
        }
    }

    public static void replicateReplica(IRODSApi.RcComm comm, String logicalPath, int srcReplicaNumber, String dstResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(srcReplicaNumber, 0L, "Source replica number is less than 0");
        IRODSReplicas.throwIfNullOrEmpty(dstResourceName, "Destination resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(srcReplicaNumber));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("destRescName");
        input.KeyValPair_PI.svalue.add(dstResourceName);
        Reference<TransferStat_PI> output = new Reference<TransferStat_PI>();
        int ec = IRODSApi.rcDataObjRepl(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjRepl error");
        }
    }

    public static void replicateReplica(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String srcResourceName, String dstResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(srcResourceName, "Source resource is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(dstResourceName, "Destination resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(String.valueOf(srcResourceName));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("destRescName");
        input.KeyValPair_PI.svalue.add(dstResourceName);
        Reference<TransferStat_PI> output = new Reference<TransferStat_PI>();
        int ec = IRODSApi.rcDataObjRepl(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjRepl error");
        }
    }

    public static void replicateReplica(IRODSApi.RcComm comm, String logicalPath, String srcResourceName, String dstResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(srcResourceName, "Source resource is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(dstResourceName, "Destination resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(String.valueOf(srcResourceName));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("destRescName");
        input.KeyValPair_PI.svalue.add(dstResourceName);
        Reference<TransferStat_PI> output = new Reference<TransferStat_PI>();
        int ec = IRODSApi.rcDataObjRepl(comm, input, output);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjRepl error");
        }
    }

    public static void trimReplica(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(replicaNumber));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("copies");
        input.KeyValPair_PI.svalue.add("1");
        int ec = IRODSApi.rcDataObjTrim(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjTrim error");
        }
    }

    public static void trimReplica(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(replicaNumber));
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("copies");
        input.KeyValPair_PI.svalue.add("1");
        int ec = IRODSApi.rcDataObjTrim(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjTrim error");
        }
    }

    public static void trimReplica(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(leafResourceName);
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("copies");
        input.KeyValPair_PI.svalue.add("1");
        int ec = IRODSApi.rcDataObjTrim(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjTrim error");
        }
    }

    public static void trimReplica(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(leafResourceName);
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("copies");
        input.KeyValPair_PI.svalue.add("1");
        int ec = IRODSApi.rcDataObjTrim(comm, input);
        if (ec < 0) {
            throw new IRODSException(ec, "rcDataObjTrim error");
        }
    }

    public static String replicaChecksum(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, long replicaNumber, VerificationCalculation calculation) throws IOException, IRODSException {
        Reference<String> output;
        int ec;
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        IRODSReplicas.throwIfNull((Object)calculation, "Checksum verification calculation is null");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(replicaNumber));
        if (VerificationCalculation.ALWAYS == calculation) {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("forceFlag");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcDataObjChksum(comm, input, output = new Reference<String>())) < 0) {
            throw new IRODSException(ec, "rcDataObjChksum error");
        }
        return (String)output.value;
    }

    public static String replicaChecksum(IRODSApi.RcComm comm, String logicalPath, long replicaNumber, VerificationCalculation calculation) throws IOException, IRODSException {
        Reference<String> output;
        int ec;
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        IRODSReplicas.throwIfNull((Object)calculation, "Checksum verification calculation is null");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("replNum");
        input.KeyValPair_PI.svalue.add(String.valueOf(replicaNumber));
        if (VerificationCalculation.ALWAYS == calculation) {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("forceFlag");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcDataObjChksum(comm, input, output = new Reference<String>())) < 0) {
            throw new IRODSException(ec, "rcDataObjChksum error");
        }
        return (String)output.value;
    }

    public static String replicaChecksum(AdminTag adminTag, IRODSApi.RcComm comm, String logicalPath, String leafResourceName, VerificationCalculation calculation) throws IOException, IRODSException {
        Reference<String> output;
        int ec;
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Destination resource is null or empty");
        IRODSReplicas.throwIfNull((Object)calculation, "Checksum verification calculation is null");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("irodsAdmin");
        input.KeyValPair_PI.svalue.add("");
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(leafResourceName);
        if (VerificationCalculation.ALWAYS == calculation) {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("forceFlag");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcDataObjChksum(comm, input, output = new Reference<String>())) < 0) {
            throw new IRODSException(ec, "rcDataObjChksum error");
        }
        return (String)output.value;
    }

    public static String replicaChecksum(IRODSApi.RcComm comm, String logicalPath, String leafResourceName, VerificationCalculation calculation) throws IOException, IRODSException {
        Reference<String> output;
        int ec;
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Destination resource is null or empty");
        IRODSReplicas.throwIfNull((Object)calculation, "Checksum verification calculation is null");
        DataObjInp_PI input = new DataObjInp_PI();
        input.objPath = logicalPath;
        input.KeyValPair_PI = new KeyValPair_PI();
        input.KeyValPair_PI.keyWord = new ArrayList<String>();
        input.KeyValPair_PI.svalue = new ArrayList<String>();
        ++input.KeyValPair_PI.ssLen;
        input.KeyValPair_PI.keyWord.add("rescName");
        input.KeyValPair_PI.svalue.add(leafResourceName);
        if (VerificationCalculation.ALWAYS == calculation) {
            ++input.KeyValPair_PI.ssLen;
            input.KeyValPair_PI.keyWord.add("forceFlag");
            input.KeyValPair_PI.svalue.add("");
        }
        if ((ec = IRODSApi.rcDataObjChksum(comm, input, output = new Reference<String>())) < 0) {
            throw new IRODSException(ec, "rcDataObjChksum error");
        }
        return (String)output.value;
    }

    public static long lastWriteTime(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_MODIFY_TIME where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_NUM = '%d'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, replicaNumber));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return Long.parseLong(rows.get(0).get(0));
    }

    public static long lastWriteTime(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_MODIFY_TIME where COLL_NAME = '%s' and DATA_NAME = '%s' and RESC_NAME = '%s'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, leafResourceName));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return Long.parseLong(rows.get(0).get(0));
    }

    public static void lastWriteTime(IRODSApi.RcComm comm, String logicalPath, long replicaNumber, long newTime) throws JsonProcessingException, IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        IRODSReplicas.throwIfLessThanLowerBound(newTime, 0L, "Modification time is less than 0");
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("logical_path", logicalPath);
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        input.put("options", options);
        options.put("no_create", Boolean.valueOf(true));
        options.put("replica_number", Long.valueOf(replicaNumber));
        options.put("seconds_since_epoch", Long.valueOf(newTime));
        int ec = IRODSApi.rcTouch(comm, JsonUtil.toJsonString(input));
        if (ec < 0) {
            throw new IRODSException(ec, "rcTouch error");
        }
    }

    public static void lastWriteTime(IRODSApi.RcComm comm, String logicalPath, String leafResourceName, long newTime) throws JsonProcessingException, IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(newTime, 0L, "Modification time is less than 0");
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("logical_path", logicalPath);
        HashMap<String, Object> options = new HashMap<String, Object>();
        input.put("options", options);
        options.put("no_create", true);
        options.put("leaf_resource_name", leafResourceName);
        options.put("seconds_since_epoch", newTime);
        int ec = IRODSApi.rcTouch(comm, JsonUtil.toJsonString(input));
        if (ec < 0) {
            throw new IRODSException(ec, "rcTouch error");
        }
    }

    public static long toReplicaNumber(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_REPL_NUM where COLL_NAME = '%s' and DATA_NAME = '%s' and RESC_NAME = '%s'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, leafResourceName));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return Long.parseLong(rows.get(0).get(0));
    }

    public static String toLeafResource(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select RESC_NAME where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_NUM = '%d'";
        List<List<String>> rows = IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, replicaNumber));
        if (!rows.isEmpty()) {
            throw new IllegalStateException("Replica does not exist");
        }
        return rows.get(0).get(0);
    }

    public static boolean replicaExists(IRODSApi.RcComm comm, String logicalPath, long replicaNumber) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfLessThanLowerBound(replicaNumber, 0L, "Replica number is less than 0");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_ID where COLL_NAME = '%s' and DATA_NAME = '%s' and DATA_REPL_NUM = '%d'";
        return !IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, replicaNumber)).isEmpty();
    }

    public static boolean replicaExists(IRODSApi.RcComm comm, String logicalPath, String leafResourceName) throws IOException, IRODSException {
        IRODSReplicas.throwIfNull(comm, "RcComm is null");
        IRODSReplicas.throwIfNullOrEmpty(logicalPath, "Path is null or empty");
        IRODSReplicas.throwIfNullOrEmpty(leafResourceName, "Resource is null or empty");
        Path p = Paths.get(logicalPath, new String[0]);
        String collName = p.getParent().toString();
        String dataName = p.getFileName().toString();
        String query = "select DATA_ID where COLL_NAME = '%s' and DATA_NAME = '%s' and RESC_NAME = '%s'";
        return !IRODSQuery.executeGenQuery2(comm, String.format(query, collName, dataName, leafResourceName)).isEmpty();
    }

    private static void throwIfNull(Object object, String msg) {
        if (null == object) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void throwIfNullOrEmpty(String s, String msg) {
        if (null == s || s.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void throwIfLessThanLowerBound(long value, long lowerBound, String msg) {
        if (value < lowerBound) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static enum VerificationCalculation {
        IF_EMPTY,
        ALWAYS;

    }
}

