/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthManager;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class PamPasswordAuthPlugin
extends AuthPlugin {
    private static final Logger log = LogManager.getLogger();
    private static final String PERFORM_NATIVE_AUTH = "perform_native_auth";

    public PamPasswordAuthPlugin() {
        this.addOperation("auth_client_auth_request", this::clientRequest);
        this.addOperation(PERFORM_NATIVE_AUTH, this::performNativeAuth);
    }

    @Override
    public JsonNode authClientStart(IRODSApi.RcComm comm, JsonNode context) {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "auth_client_auth_request");
        resp.put("user_name", comm.proxyUsername);
        resp.put("zone_name", comm.proxyUserZone);
        resp.put("a_pw", context.get("password").asText());
        resp.remove("password");
        return resp;
    }

    private JsonNode clientRequest(IRODSApi.RcComm comm, JsonNode context) throws IOException, IRODSException {
        ObjectNode req = (ObjectNode)context.deepCopy();
        req.put("next_operation", "auth_agent_auth_request");
        if (!comm.secure) {
            throw new IllegalStateException("SSL/TLS is required for PAM authentication");
        }
        JsonNode resp = this.request(comm, (JsonNode)req);
        ((ObjectNode)resp).put("next_operation", PERFORM_NATIVE_AUTH);
        if (!resp.has("request_result")) {
            throw new IllegalStateException("Missing property: request_result");
        }
        return resp;
    }

    private JsonNode performNativeAuth(IRODSApi.RcComm comm, JsonNode context) throws Exception {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.remove("a_pw");
        ObjectNode input = JsonUtil.getJsonMapper().createObjectNode();
        input.put("password", resp.get("request_result").asText());
        AuthManager.authenticateClient(comm, "native", (JsonNode)input);
        resp.put("next_operation", "authentication_flow_complete");
        return resp;
    }
}

