/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthPlugin;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;

public class NativeAuthPlugin
extends AuthPlugin {
    private static final Logger log = LogManager.getLogger();

    public NativeAuthPlugin() {
        this.addOperation("auth_establish_context", this::establishContext);
        this.addOperation("auth_client_auth_request", this::clientRequest);
        this.addOperation("auth_client_auth_response", this::clientResponse);
    }

    @Override
    public JsonNode authClientStart(IRODSApi.RcComm comm, JsonNode context) {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        resp.put("next_operation", "auth_client_auth_request");
        resp.put("user_name", comm.proxyUsername);
        resp.put("zone_name", comm.proxyUserZone);
        return resp;
    }

    private JsonNode establishContext(IRODSApi.RcComm comm, JsonNode context) throws NoSuchAlgorithmException {
        ObjectNode resp = (ObjectNode)context.deepCopy();
        String requestResult = ((ObjectNode)context).get("request_result").asText();
        StringBuilder requestResultSb = new StringBuilder();
        requestResultSb.append(requestResult);
        int CHALLENGE_LEN = 64;
        requestResultSb.setLength(64);
        log.debug("requestResultSb string = [{}]", (Object)requestResultSb.toString());
        StringBuilder md5BufSb = new StringBuilder();
        md5BufSb.append((CharSequence)requestResultSb);
        comm.sessionSignature = NativeAuthPlugin.generateSessionSignature(md5BufSb.substring(0, 16));
        log.debug("Session signature = [{}]", (Object)comm.sessionSignature);
        if (!"anonymous".equals(context.get("user_name").asText())) {
            int MAX_PASSWORD_LEN = 50;
            StringBuilder passwordSb = new StringBuilder();
            passwordSb.append(context.get("password").asText());
            passwordSb.setLength(50);
            md5BufSb.append((CharSequence)passwordSb);
            log.debug("MD5 string = [{}]", (Object)md5BufSb.toString());
        }
        MessageDigest hasher = MessageDigest.getInstance("md5");
        hasher.update(md5BufSb.toString().getBytes(StandardCharsets.UTF_8));
        int RESPONSE_LEN = 16;
        byte[] digest = hasher.digest();
        for (int i = 0; i < 16; ++i) {
            if (0 != digest[i]) continue;
            int n = i;
            digest[n] = (byte)(digest[n] + 1);
        }
        resp.remove("password");
        resp.put("digest", Base64.getEncoder().encodeToString(digest));
        resp.put("next_operation", "auth_client_auth_response");
        return resp;
    }

    private JsonNode clientRequest(IRODSApi.RcComm comm, JsonNode context) throws IOException, IRODSException {
        ObjectNode req = (ObjectNode)context.deepCopy();
        req.put("next_operation", "auth_agent_auth_request");
        JsonNode resp = this.request(comm, (JsonNode)req);
        ((ObjectNode)resp).put("next_operation", "auth_establish_context");
        return resp;
    }

    private JsonNode clientResponse(IRODSApi.RcComm comm, JsonNode context) throws IOException, IRODSException {
        if (!(context.has("digest") && context.has("user_name") && context.has("zone_name"))) {
            throw new IllegalStateException("Missing digest, user_name, and/or zone_name");
        }
        ObjectNode req = (ObjectNode)context.deepCopy();
        req.put("next_operation", "auth_agent_auth_response");
        JsonNode resp = this.request(comm, (JsonNode)req);
        comm.loggedIn = true;
        ((ObjectNode)resp).put("next_operation", "authentication_flow_complete");
        return resp;
    }

    private static String generateSessionSignature(String buffer) {
        int requiredSize = 16;
        if (buffer.length() < 16) {
            throw new IllegalArgumentException("Buffer must be at least 16 bytes long");
        }
        StringBuilder sigSb = new StringBuilder();
        for (byte ch : buffer.getBytes(StandardCharsets.UTF_8)) {
            sigSb.append(String.format("%02x", ch));
        }
        if (sigSb.length() != 32) {
            throw new IllegalStateException("Session signature is not 32 bytes in length");
        }
        return sigSb.toString();
    }
}

