/*
 * Decompiled with CFR 0.152.
 */
package org.irods.irods4j.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NameNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.irods4j.authentication.AuthPluginOperation;
import org.irods.irods4j.common.JsonUtil;
import org.irods.irods4j.common.XmlUtil;
import org.irods.irods4j.low_level.api.IRODSApi;
import org.irods.irods4j.low_level.api.IRODSException;
import org.irods.irods4j.low_level.network.Network;
import org.irods.irods4j.low_level.protocol.packing_instructions.BinBytesBuf_PI;
import org.irods.irods4j.low_level.protocol.packing_instructions.MsgHeader_PI;

public abstract class AuthPlugin {
    private static final Logger log = LogManager.getLogger();
    public static final String AUTH_CLIENT_START = "auth_client_start";
    public static final String AUTH_AGENT_START = "auth_agent_start";
    public static final String AUTH_ESTABLISH_CONTEXT = "auth_establish_context";
    public static final String AUTH_CLIENT_AUTH_REQUEST = "auth_client_auth_request";
    public static final String AUTH_AGENT_AUTH_REQUEST = "auth_agent_auth_request";
    public static final String AUTH_CLIENT_AUTH_RESPONSE = "auth_client_auth_response";
    public static final String AUTH_AGENT_AUTH_RESPONSE = "auth_agent_auth_response";
    public static final String AUTH_AGENT_AUTH_VERIFY = "auth_agent_auth_verify";
    public static final String AUTH_FLOW_COMPLETE = "authentication_flow_complete";
    public static final String AUTH_NEXT_OPERATION = "next_operation";
    public static final String AUTH_FORCE_PASSWORD_PROMPT = "force_password_prompt";
    public static final String AUTH_USER_KEY = "a_user";
    public static final String AUTH_SCHEME_KWY = "a_scheme";
    public static final String AUTH_TTL_KEY = "a_ttl";
    public static final String AUTH_PASSWORD_KEY = "a_pw";
    public static final String AUTH_RESPONSE_KEY = "a_resp";
    private Map<String, AuthPluginOperation> operations = new HashMap<String, AuthPluginOperation>();

    public AuthPlugin() {
        this.addOperation(AUTH_CLIENT_START, this::authClientStart);
    }

    protected void addOperation(String opName, AuthPluginOperation op) {
        this.operations.put(opName, op);
    }

    public JsonNode execute(IRODSApi.RcComm comm, String operation, JsonNode context) throws Exception {
        AuthPluginOperation op = this.operations.get(operation);
        if (null == op) {
            throw new NameNotFoundException("Operation not supported: " + operation);
        }
        return op.execute(comm, context);
    }

    public abstract JsonNode authClientStart(IRODSApi.RcComm var1, JsonNode var2);

    protected JsonNode request(IRODSApi.RcComm comm, JsonNode msg) throws IOException, IRODSException {
        String json = JsonUtil.toJsonString(msg);
        BinBytesBuf_PI bbbuf = new BinBytesBuf_PI();
        bbbuf.buf = json;
        bbbuf.buflen = json.length();
        String msgbody = XmlUtil.toXmlString(bbbuf);
        MsgHeader_PI hdr = new MsgHeader_PI();
        hdr.type = "RODS_API_REQ";
        hdr.msgLen = msgbody.length();
        hdr.intInfo = 110000;
        Network.write(comm.sout, hdr);
        Network.writeBytes(comm.sout, msgbody.getBytes(StandardCharsets.UTF_8));
        comm.sout.flush();
        MsgHeader_PI mh = Network.readMsgHeader_PI(comm.sin);
        if (log.isDebugEnabled()) {
            log.debug("Received MsgHeader_PI: {}", (Object)XmlUtil.toXmlString(mh));
        }
        if (mh.intInfo < 0) {
            throw new IRODSException(mh.intInfo, "Client request error");
        }
        bbbuf = Network.readObject(comm.sin, mh.msgLen, BinBytesBuf_PI.class);
        ObjectMapper jm = JsonUtil.getJsonMapper();
        return jm.readTree(bbbuf.buf);
    }
}

