/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy.query.builder.sql;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.irenical.drowsy.query.BaseQuery;
import org.irenical.drowsy.query.Query;
import org.irenical.drowsy.query.builder.QueryBuilder;

public abstract class BaseQueryBuilder<BUILDER_CLASS extends QueryBuilder<BUILDER_CLASS>>
implements QueryBuilder<BUILDER_CLASS> {
    private static final char VALUE = '?';
    private final List<Object> parameters = new LinkedList<Object>();
    private final StringBuilder sb = new StringBuilder();
    private final Query.TYPE type;

    public BaseQueryBuilder(Query.TYPE type) {
        this.type = type;
    }

    @Override
    public Query build() {
        BaseQuery result = new BaseQuery();
        result.setParameters(Collections.unmodifiableList(this.parameters));
        result.setQuery(this.sb.toString());
        result.setType(this.type);
        return result;
    }

    @Override
    public BUILDER_CLASS literal(Object sql) {
        this.sb.append(sql);
        return (BUILDER_CLASS)this;
    }

    @Override
    public BUILDER_CLASS literals(Iterable<?> sql, String prefix, String suffix, String separator) {
        if (sql != null) {
            boolean first = true;
            for (Object s : sql) {
                if (first) {
                    if (prefix != null) {
                        this.sb.append(prefix);
                    }
                } else if (separator != null) {
                    this.sb.append(separator);
                }
                this.sb.append(s);
                first = false;
            }
            if (!first && suffix != null) {
                this.sb.append(suffix);
            }
        }
        return (BUILDER_CLASS)this;
    }

    @Override
    public BUILDER_CLASS param(Object value) {
        this.sb.append('?');
        this.parameters.add(value);
        return (BUILDER_CLASS)this;
    }

    @Override
    public BUILDER_CLASS params(Iterable<?> values, String prefix, String suffix, String separator) {
        if (values != null) {
            boolean first = true;
            for (Object value : values) {
                if (first) {
                    if (prefix != null) {
                        this.sb.append(prefix);
                    }
                } else if (separator != null) {
                    this.sb.append(separator);
                }
                this.param(value);
                first = false;
            }
            if (!first && suffix != null) {
                this.sb.append(suffix);
            }
        }
        return (BUILDER_CLASS)this;
    }

    @Override
    public BUILDER_CLASS subquery(Query subquery) {
        this.literal(" (").literal(subquery.getQuery()).literal(")");
        this.parameters.addAll(subquery.getParameters());
        return (BUILDER_CLASS)this;
    }
}

