/*
 * Decompiled with CFR 0.152.
 */
package org.irenical.drowsy.query;

import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Scanner;
import org.irenical.drowsy.query.Query;

public class BaseQuery
implements Query {
    private Query.TYPE type;
    private boolean returnGeneratedKeys;
    private List<Object> parameters;
    private String query;

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryFromResource(ClassLoader classLoader, String resourcePath) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be nul");
        }
        InputStream is = classLoader.getResourceAsStream(resourcePath);
        if (is == null) {
            throw new IllegalArgumentException(String.format("Resource could not be found in the provided path: %s", resourcePath));
        }
        try (Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");){
            if (!scanner.hasNext()) {
                throw new IllegalStateException(String.format("File at %s is empty", resourcePath));
            }
            this.setQuery(scanner.next().trim());
        }
    }

    public void setQueryFromResource(String resourcePath) {
        this.setQueryFromResource(this.getClass().getClassLoader(), resourcePath);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setType(Query.TYPE type) {
        this.type = type;
    }

    @Override
    public boolean returnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }

    public void setReturnGeneratedKeys(boolean returnGeneratedKeys) {
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
        PreparedStatement ps = Query.TYPE.CALL.equals((Object)this.type) ? connection.prepareCall(this.query) : (this.returnGeneratedKeys ? connection.prepareStatement(this.query, 1) : connection.prepareStatement(this.query));
        this.setParameters(ps, this.parameters);
        return ps;
    }

    private void setParameters(PreparedStatement ps, Collection<Object> parameters) throws SQLException {
        if (parameters != null) {
            int current = 1;
            for (Object param : parameters) {
                this.setInputParameter(ps, current++, param);
            }
        }
    }

    private void setInputParameter(PreparedStatement ps, int idx, Object value) throws SQLException {
        if (value instanceof Timestamp) {
            ps.setTimestamp(idx, (Timestamp)value);
        } else if (value instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)value;
            GregorianCalendar cal = GregorianCalendar.from(zdt);
            Timestamp t = Timestamp.from(zdt.toInstant());
            ps.setTimestamp(idx, t, cal);
        } else if (value instanceof Time) {
            ps.setTime(idx, (Time)value);
        } else if (value instanceof Date) {
            ps.setDate(idx, (Date)value);
        } else if (value instanceof Enum) {
            ps.setString(idx, value.toString());
        } else if (value instanceof Class) {
            if (!(ps instanceof CallableStatement)) {
                throw new IllegalArgumentException("Invalid parameter type for non-CallableStatement: " + value.getClass());
            }
            this.setOutputParameter((CallableStatement)ps, idx, (Class)value);
            ps.setString(idx, value.toString());
        } else {
            ps.setObject(idx, value);
        }
    }

    private void setOutputParameter(CallableStatement statement, int idx, Class<?> value) throws SQLException {
        if (String.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 12);
        } else if (Float.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 6);
        } else if (Integer.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 4);
        } else if (Timestamp.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 93);
        } else if (Boolean.class.getName().equals(value.getName())) {
            statement.registerOutParameter(idx, 16);
        } else {
            statement.registerOutParameter(idx, 2000);
        }
    }
}

