/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.rest;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;

class LimitRequestBodyInputStream
extends InputStream {
    private long count;
    private InputStream actual;
    private long maxBodySize;
    private boolean contentLengthOver;

    LimitRequestBodyInputStream(InputStream actual, long maxBodySize, long contentLength) {
        if (contentLength >= 0L && contentLength > maxBodySize) {
            this.contentLengthOver = true;
        }
        this.maxBodySize = maxBodySize;
        this.actual = actual;
    }

    @Override
    public int read() throws IOException {
        this.checkContentLength();
        int i = this.actual.read();
        if (i >= 0) {
            this.countup(1);
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkContentLength();
        int i = this.actual.read(b);
        if (i >= 0) {
            this.countup(i);
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkContentLength();
        int i = this.actual.read(b, off, len);
        if (i >= 0) {
            this.countup(i);
        }
        return i;
    }

    private void countup(int i) {
        this.count += (long)i;
        if (this.count > this.maxBodySize) {
            WebApplicationException ex = new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            try {
                this.actual.close();
            }
            catch (Exception e) {
                ex.addSuppressed((Throwable)e);
            }
            throw ex;
        }
    }

    private void checkContentLength() {
        if (this.contentLengthOver) {
            WebApplicationException ex = new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            try {
                this.actual.close();
            }
            catch (Exception e) {
                ex.addSuppressed((Throwable)e);
            }
            throw ex;
        }
    }
}

